/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.capability.cubicchunks;

import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateContainer;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import io.github.opencubicchunks.cubicchunks.api.world.IColumn;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class FluidStateCapabilityIColumn
implements IFluidStateCapability {
    @Nonnull
    protected final IColumn column;

    public FluidStateCapabilityIColumn(@Nonnull Chunk columnIn) {
        this.column = (IColumn)columnIn;
    }

    @Override
    @Nonnull
    public IFluidStateContainer getContainer(int y) {
        return Objects.requireNonNull(IFluidStateCapability.get((ICapabilityProvider)this.column.getCube(y >> 4))).getContainer(y);
    }

    @Nonnull
    public NBTBase serializeNBT() {
        return new NBTTagByte(0);
    }

    public void deserializeNBT(@Nonnull NBTBase nbtIn) {
        if (nbtIn instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)nbtIn;
            switch (nbt.func_74762_e("version")) {
                case 1: 
                case 2: {
                    nbt.func_150295_c("data", 10).forEach(tagIn -> {
                        NBTTagCompound tag = (NBTTagCompound)tagIn;
                        if (tag.func_150297_b("id", 8) && tag.func_150297_b("pos", 99)) {
                            Block block = Block.func_149684_b((String)tag.func_74779_i("id"));
                            if (block == null) {
                                return;
                            }
                            NBTPrimitive posNbt = (NBTPrimitive)tag.func_74781_a("pos");
                            if (posNbt instanceof NBTTagLong) {
                                BlockPos pos = BlockPos.func_177969_a((long)posNbt.func_150291_c());
                                this.getContainer(pos.func_177956_o()).setFluidState(pos, FluidState.of(block.func_176203_a(tag.func_74762_e("meta"))));
                            } else {
                                this.getContainer((char)posNbt.func_150287_d() >> 8).setFluidState((char)posNbt.func_150287_d(), FluidState.of(block.func_176203_a(tag.func_74762_e("meta"))));
                            }
                        }
                    });
                    return;
                }
            }
            throw new IllegalArgumentException("Could not read chunk data, please update Fluidlogged API to the latest version!");
        }
        if (nbtIn instanceof NBTTagList) {
            ((NBTTagList)nbtIn).forEach(tagIn -> {
                NBTTagCompound nbt;
                if (tagIn instanceof NBTTagCompound && (nbt = (NBTTagCompound)tagIn).func_150297_b("id", 8) && nbt.func_150297_b("pos", 4)) {
                    BlockPos pos = BlockPos.func_177969_a((long)nbt.func_74763_f("pos"));
                    this.getContainer(pos.func_177956_o()).setFluidState(pos, FluidState.of(Block.func_149684_b((String)nbt.func_74779_i("id"))));
                }
            });
        }
    }
}

