/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.datafix;

import git.jbredwards.fluidlogged_api.api.datafix.FluidMappingData;
import git.jbredwards.fluidlogged_api.api.datafix.IFluidloggedDataMapper;
import git.jbredwards.fluidlogged_api.mod.common.datafix.FluidloggedAPIFixableData;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.NibbleArray;

public final class ToFluidloggedDataFixer {
    @Nonnull
    public static NBTTagCompound fix(@Nonnull NBTTagCompound compound) {
        if (IFluidloggedDataMapper.MAPPERS.isEmpty()) {
            return compound;
        }
        BlockPos.MutableBlockPos posBuilder = new BlockPos.MutableBlockPos();
        NBTTagCompound level = compound.func_74775_l("Level");
        NBTTagList sections = level.func_150295_c("Sections", 10);
        NBTTagList capabilityData = FluidloggedAPIFixableData.getOrCreateFluidCapabilityData(level);
        int blockX = level.func_74762_e("xPos") << 4;
        int blockZ = level.func_74762_e("zPos") << 4;
        for (int i = 0; i < sections.func_74745_c(); ++i) {
            NBTTagCompound section = sections.func_150305_b(i);
            byte[] blockIDs = section.func_74770_j("Blocks");
            NibbleArray extIDs = section.func_150297_b("Add", 7) ? new NibbleArray(section.func_74770_j("Add")) : new NibbleArray();
            NibbleArray metadataArray = new NibbleArray(section.func_74770_j("Data"));
            int blockY = section.func_74762_e("Y") << 4;
            boolean dirty = false;
            for (int pos = 0; pos < blockIDs.length; ++pos) {
                FluidMappingData mapping;
                int x = pos & 0xF;
                int y = pos >> 8 & 0xF;
                int z = pos >> 4 & 0xF;
                int blockID = extIDs.func_76582_a(x, y, z) << 8 | blockIDs[pos] & 0xFF;
                int blockMeta = metadataArray.func_76582_a(x, y, z);
                Block block = Block.func_149729_e((int)blockID);
                if (block.getRegistryName() == null || (mapping = (FluidMappingData)IFluidloggedDataMapper.MAPPERS.get((Object)block).stream().map(mapper -> mapper.remapFluidData(blockID, blockMeta)).filter(Objects::nonNull).findFirst().orElse(null)) == null) continue;
                dirty = true;
                if (mapping.meta != -1) {
                    metadataArray.func_76581_a(x, y, z, mapping.meta);
                }
                if (mapping.block != null) {
                    int newBlockID = Block.func_149682_b((Block)mapping.block);
                    blockIDs[pos] = (byte)newBlockID;
                    extIDs.func_76581_a(x, y, z, newBlockID >> 8 & 0xF);
                }
                if (!mapping.fluidState.isValid()) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74772_a("pos", posBuilder.func_181079_c(blockX | x, blockY | y, blockZ | z).func_177986_g());
                nbt.func_74778_a("id", String.valueOf(mapping.fluidState.getBlock().getRegistryName()));
                nbt.func_74768_a("meta", mapping.fluidState.getMetadata());
                capabilityData.func_74742_a((NBTBase)nbt);
            }
            if (!dirty) continue;
            section.func_74773_a("Blocks", blockIDs);
            section.func_74773_a("Data", metadataArray.func_177481_a());
            section.func_74773_a("Add", extIDs.func_177481_a());
        }
        return compound;
    }
}

