/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.datafix.modded;

import git.jbredwards.fluidlogged_api.api.datafix.FluidMappingData;
import git.jbredwards.fluidlogged_api.api.datafix.IFluidloggedDataMapper;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.blocks.BlockGrating;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum GalacticraftDataFixer implements IFluidloggedDataMapper
{
    INSTANCE;

    @Nullable
    private static Int2ObjectMap<FluidState> ID_FLUID_MAPPINGS;
    @Nullable
    private static Map<String, FluidState> NAME_FLUID_MAPPINGS;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        MAPPERS.put((Object)Blocks.field_150350_a, (Object)INSTANCE);
        MAPPERS.put((Object)GCBlocks.grating, (Object)INSTANCE);
        NAME_FLUID_MAPPINGS = BlockGrating.forgeBlocks.stream().collect(Collectors.toMap(g -> g.func_149739_a().substring(5), g -> FluidState.of(g.getLiquidBlock(GCFluids.fluidOil.getBlock().func_176223_P()))));
        NAME_FLUID_MAPPINGS.put("grating1", FluidState.of((Block)Blocks.field_150355_j));
        NAME_FLUID_MAPPINGS.put("grating2", FluidState.of((Block)Blocks.field_150353_l));
    }

    @SubscribeEvent
    public void remapBlocks(@Nonnull RegistryEvent.MissingMappings<Block> event) {
        event.getAllMappings().stream().filter(m -> m.key.func_110624_b().equals("galacticraftcore")).forEach(mapping -> {
            FluidState fluid = NAME_FLUID_MAPPINGS.get(mapping.key.func_110623_a());
            if (fluid != null && fluid.isValid()) {
                ID_FLUID_MAPPINGS.put(mapping.id, (Object)fluid);
                mapping.remap((IForgeRegistryEntry)GCBlocks.grating);
            }
        });
    }

    @Override
    @Nullable
    public FluidMappingData remapFluidData(int blockID, int blockMetadata) {
        if (blockID == 0) {
            return null;
        }
        FluidState fluid = (FluidState)((Object)ID_FLUID_MAPPINGS.get(blockID));
        return fluid == null ? null : new FluidMappingData(FluidloggedAPIConfig.nonSourceFluidlogging ? fluid.withLevel(blockMetadata) : fluid.toSource()).withBlock(GCBlocks.grating).withMetadata(0);
    }

    public static void init() {
        ID_FLUID_MAPPINGS = new Int2ObjectOpenHashMap();
    }

    public static void reset() {
        ID_FLUID_MAPPINGS = null;
    }
}

