/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.fluid.handler;

import com.google.common.collect.ImmutableMap;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.IFluidNeighborInfo;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.ISpecializedFluidNeighborInfo;
import java.util.Collection;
import java.util.Optional;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fml.common.FMLCommonHandler;

public final class FluidExtendedStateHandler {
    @Nonnull
    public static IBlockState getExtendedState(@Nonnull IBlockState renderState, @Nonnull ISpecializedFluidNeighborInfo neighborInfo, @Nonnull ToDoubleFunction<ISpecializedFluidNeighborInfo> flowDirection) {
        if (!(renderState instanceof IExtendedBlockState)) {
            return renderState;
        }
        FluidExtendedBlockState state = new FluidExtendedBlockState((IExtendedBlockState)renderState);
        float[][] heights = new float[4][4];
        float[][] corners = new float[2][2];
        heights[1][1] = FluidExtendedStateHandler.isConnectedVertical(neighborInfo, 1, 1) ? 1.0f : FluidExtendedStateHandler.getRenderLevel(neighborInfo, 1, 1, 1);
        if (heights[1][1] == 1.0f) {
            for (int i = 0; i < 2; ++i) {
                corners[i] = new float[]{1.0f, 1.0f};
            }
        } else {
            int ziH;
            int xiH;
            float f = heights[1][1];
            heights[2][1] = f;
            heights[1][2] = f;
            heights[2][2] = f;
            for (xiH = 0; xiH < 4; ++xiH) {
                for (ziH = 0; ziH < 4; ++ziH) {
                    if (xiH != 0 && xiH != 3 && ziH != 0 && ziH != 3) continue;
                    heights[xiH][ziH] = FluidExtendedStateHandler.getFluidHeightForRender(neighborInfo, xiH, ziH);
                }
            }
            for (xiH = 0; xiH < 4; xiH += 2) {
                for (ziH = 0; ziH < 4; ziH += 2) {
                    corners[xiH >> 1][ziH >> 1] = FluidExtendedStateHandler.getFluidHeightAverage(neighborInfo.getOrigin().getQuantaFraction(), heights[xiH][ziH], heights[xiH][ziH + 1], heights[xiH + 1][ziH], heights[xiH + 1][ziH + 1]);
                }
            }
        }
        boolean calcFlowDirection = false;
        if (FMLCommonHandler.instance().getSide().isClient() && MinecraftForgeClient.getRenderLayer() != null) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                state.shouldSideBeRenderedCache[side.func_176745_a()] = FluidExtendedStateHandler.shouldFluidSideBeRendered(neighborInfo, side);
            }
            if (neighborInfo.getOrigin().getFluid().getOverlay() != null) {
                for (int i = 0; i < 4; ++i) {
                    if (!state.shouldSideBeRenderedCache[EnumFacing.field_176754_o[i].func_176745_a()]) continue;
                    Vec3i direction = EnumFacing.field_176754_o[i].func_176730_m();
                    state.sideOverlays[i] = !neighborInfo.canFluidFlowI(direction.func_177958_n() + 1, 1, direction.func_177952_p() + 1, EnumFacing.field_176754_o[i].func_176734_d());
                }
            }
            if (heights[1][1] != 1.0f) {
                if (!neighborInfo.canFluidFlowI(1, 1, 1, neighborInfo.getOrigin().getUpDensityFace())) {
                    state.renderUnder = true;
                } else {
                    block7: for (int xi = 0; xi < 3; ++xi) {
                        for (int zi = 0; zi < 3; ++zi) {
                            if (!neighborInfo.canFluidFlowI(xi, 2, zi, neighborInfo.getOrigin().getDownDensityFace()) || neighborInfo.isCompatibleFluidI(xi, 2, zi)) continue;
                            state.renderUnder = true;
                            continue block7;
                        }
                    }
                }
            }
            if (state.shouldSideBeRenderedCache[neighborInfo.getOrigin().getUpDensityFace().func_176745_a()]) {
                if (corners[0][0] == 1.0f) {
                    corners[0][0] = 0.999f;
                }
                if (corners[0][1] == 1.0f) {
                    corners[0][1] = 0.999f;
                }
                if (corners[1][0] == 1.0f) {
                    corners[1][0] = 0.999f;
                }
                if (corners[1][1] == 1.0f) {
                    corners[1][1] = 0.999f;
                }
                calcFlowDirection = true;
            }
        }
        state.flowDirection = Float.valueOf(calcFlowDirection ? (float)flowDirection.applyAsDouble(neighborInfo) : -1000.0f);
        state.levelCorners[0] = Float.valueOf(corners[0][0]);
        state.levelCorners[1] = Float.valueOf(corners[0][1]);
        state.levelCorners[2] = Float.valueOf(corners[1][1]);
        state.levelCorners[3] = Float.valueOf(corners[1][0]);
        return state;
    }

    static float getFluidHeightForRender(@Nonnull ISpecializedFluidNeighborInfo neighborInfo, int xiH, int ziH) {
        float connection = FluidExtendedStateHandler.getHorizontalConnection(neighborInfo, xiH, 1, ziH);
        if (connection != -1.0f && FluidExtendedStateHandler.isConnectedVertical(neighborInfo, xiH > 1 ? xiH - 1 : xiH, ziH > 1 ? ziH - 1 : ziH) || FluidExtendedStateHandler.isConnectedVertical(neighborInfo, 1, 1) && FluidExtendedStateHandler.getHorizontalConnection(neighborInfo, xiH, 2, ziH) != -1.0f) {
            return 1.0f;
        }
        return connection;
    }

    static float getHorizontalConnection(@Nonnull ISpecializedFluidNeighborInfo neighborInfo, int xiH, int yi, int ziH) {
        int zi;
        EnumFacing xSide = xiH > 1 ? EnumFacing.EAST : EnumFacing.WEST;
        EnumFacing zSide = ziH > 1 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        int xi = xiH > 1 ? xiH - 1 : xiH;
        int n = zi = ziH > 1 ? ziH - 1 : ziH;
        if (zi == 1) {
            if (!neighborInfo.canFluidFlowI(1, yi, 1, xSide) || !FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xi, yi, zi, 1, xSide.func_176734_d())) {
                int zc = ziH - 1 << 1;
                if (!(neighborInfo.canFluidFlowI(1, yi, 1, zSide) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, 1, yi, zc, 1, zSide.func_176734_d()) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, 1, yi, zc, 1, xSide) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xi, yi, zc, 2, xSide.func_176734_d()) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xi, yi, zc, 2, zSide.func_176734_d()) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xi, yi, zi, 3, zSide))) {
                    return -1.0f;
                }
            }
            return neighborInfo.isCompatibleFluidI(xi, yi, zi) ? FluidExtendedStateHandler.getRenderLevel(neighborInfo, xi, yi, zi) : 0.0f;
        }
        if (xi == 1) {
            if (!neighborInfo.canFluidFlowI(1, yi, 1, zSide) || !FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xi, yi, zi, 1, zSide.func_176734_d())) {
                int xc = xiH - 1 << 1;
                if (!(neighborInfo.canFluidFlowI(1, yi, 1, xSide) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xc, yi, 1, 1, xSide.func_176734_d()) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xc, yi, 1, 1, zSide) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xc, yi, zi, 2, zSide.func_176734_d()) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xc, yi, zi, 2, xSide.func_176734_d()) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xi, yi, zi, 3, xSide))) {
                    return -1.0f;
                }
            }
            return neighborInfo.isCompatibleFluidI(xi, yi, zi) ? FluidExtendedStateHandler.getRenderLevel(neighborInfo, xi, yi, zi) : 0.0f;
        }
        return neighborInfo.canFluidFlowI(1, yi, 1, xSide) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xi, yi, 1, 1, xSide.func_176734_d()) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xi, yi, 1, 1, zSide) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xi, yi, zi, 2, zSide.func_176734_d()) || neighborInfo.canFluidFlowI(1, yi, 1, zSide) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, 1, yi, zi, 1, zSide.func_176734_d()) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, 1, yi, zi, 1, xSide) && FluidExtendedStateHandler.canFlowOrReplaceable(neighborInfo, xi, yi, zi, 2, xSide.func_176734_d()) ? (neighborInfo.isCompatibleFluidI(xi, yi, zi) ? FluidExtendedStateHandler.getRenderLevel(neighborInfo, xi, yi, zi) : 0.0f) : -1.0f;
    }

    static boolean canFlowOrReplaceable(@Nonnull ISpecializedFluidNeighborInfo neighborInfo, int xi, int yi, int zi, int fallbackDist, @Nonnull EnumFacing side) {
        FluidState dummyState = FluidExtendedStateHandler.findLargestConnected(neighborInfo, xi, yi, zi, fallbackDist);
        return dummyState == FluidState.EMPTY || neighborInfo.isReplaceableI(xi, yi, zi, dummyState, side, true, false) || neighborInfo.canFluidFlowI(xi, yi, zi, side) && (neighborInfo.isCompatibleFluidI(xi, yi, zi) || neighborInfo.isFluidloggableI(xi, yi, zi, dummyState, side, true, false));
    }

    @Nonnull
    static FluidState findLargestConnected(@Nonnull ISpecializedFluidNeighborInfo neighborInfo, int xi, int yi, int zi, int fallbackDist) {
        if (neighborInfo.isCompatibleFluidI(xi, yi, zi)) {
            return neighborInfo.getFluidStateI(xi, yi, zi);
        }
        World world = neighborInfo.getCache().getWorld();
        int flowCost = neighborInfo.getOrigin().getFlowCost(world);
        boolean isFinite = neighborInfo.getOrigin().getBlock() instanceof BlockFluidFinite;
        FluidState largest = FluidState.EMPTY;
        for (EnumFacing side : EnumFacing.field_176754_o) {
            if (!neighborInfo.canFluidFlowI(xi, yi, zi, side)) continue;
            int xo = side.func_82601_c() + xi;
            int zo = side.func_82599_e() + zi;
            if (xo < 0 || xo >= 3 || zo < 0 || zo >= 3 || xo != 1 && zo != 1 || !neighborInfo.isCompatibleFluidI(xo, yi, zo) || !neighborInfo.canFluidFlowI(xo, yi, zo, side.func_176734_d())) continue;
            FluidState fluidState = neighborInfo.getFluidStateI(xo, yi, zo);
            if (largest == FluidState.EMPTY || (isFinite ? largest.getLevel() < fluidState.getLevel() : largest.getWrappedLevel(world) > fluidState.getWrappedLevel(world))) {
                largest = fluidState;
            }
            if (!largest.isSource()) continue;
            return largest.addLevel(flowCost);
        }
        return largest == FluidState.EMPTY ? neighborInfo.getOrigin().addLevel(fallbackDist * flowCost) : largest.addLevel(flowCost);
    }

    static float getRenderLevel(@Nonnull IFluidNeighborInfo neighborInfo, int xi, int yi, int zi) {
        FluidState fluidState = neighborInfo.getFluidStateI(xi, yi, zi);
        if (fluidState.getBlock() instanceof BlockFluidBase) {
            return fluidState.getMetadata() == ((BlockFluidBase)fluidState.getBlock()).getMaxRenderHeightMeta() ? fluidState.getQuantaFraction() : fluidState.getHeight();
        }
        return fluidState.isSource() ? fluidState.getQuantaFraction() : fluidState.getHeight();
    }

    @Nonnull
    static FluidState addLevel(@Nonnull IFluidNeighborInfo neighborInfo, int levelToAdd) {
        FluidState origin;
        return origin.withLevel((origin = neighborInfo.getOrigin()).getBlock() instanceof BlockLiquid && origin.getLevel() >= 8 ? levelToAdd : Math.min(origin.getLevel() + levelToAdd, origin.getQuantaPerBlock() - 1));
    }

    static boolean isConnectedVertical(@Nonnull IFluidNeighborInfo neighborInfo, int xi, int zi) {
        return neighborInfo.isCompatibleFluidI(xi, 1, zi) && neighborInfo.isCompatibleFluidI(xi, 2, zi) && neighborInfo.canFluidFlowI(xi, 1, zi, neighborInfo.getOrigin().getUpDensityFace()) && neighborInfo.canFluidFlowI(xi, 2, zi, neighborInfo.getOrigin().getDownDensityFace());
    }

    static float getFluidHeightAverage(float quantaFraction, float ... heights) {
        float total = 0.0f;
        int count = 0;
        for (float height : heights) {
            if (height == 1.0f) {
                return 1.0f;
            }
            if (height >= quantaFraction) {
                total += height * 10.0f;
                count += 10;
            }
            if (!(height >= 0.0f)) continue;
            total += height;
            ++count;
        }
        return total / (float)count;
    }

    static boolean shouldFluidSideBeRendered(@Nonnull IFluidNeighborInfo neighborInfo, @Nonnull EnumFacing side) {
        if (!neighborInfo.canFluidFlowI(1, 1, 1, side)) {
            return true;
        }
        Vec3i vec = side.func_176730_m();
        int xi = vec.func_177958_n() + 1;
        int yi = vec.func_177956_o() * -neighborInfo.getOrigin().getDensityDir() + 1;
        int zi = vec.func_177952_p() + 1;
        IBlockState neighbor = neighborInfo.getBlockStateI(xi, yi, zi);
        if (FluidloggedUtils.isCompatibleFluid(neighborInfo.getOrigin().getFluid(), FluidloggedUtils.getFluidFromState(neighbor))) {
            return false;
        }
        if (vec.func_177956_o() != -neighborInfo.getOrigin().getDensityDir() && neighbor.doesSideBlockRendering((IBlockAccess)neighborInfo.getCache(), neighborInfo.getPosIB(xi, yi, zi), side.func_176734_d())) {
            return false;
        }
        return !neighborInfo.canFluidFlowI(xi, yi, zi, side.func_176734_d()) || !neighborInfo.isCompatibleFluidI(xi, yi, zi);
    }

    public static final class FluidExtendedBlockState
    extends BlockStateContainer.StateImplementation
    implements IExtendedBlockState {
        public Float flowDirection;
        public final Float[] levelCorners = new Float[4];
        public final Boolean[] sideOverlays = new Boolean[4];
        public final boolean[] shouldSideBeRenderedCache = new boolean[6];
        public boolean renderUnder;
        @Nonnull
        private final IExtendedBlockState parent;

        public FluidExtendedBlockState(@Nonnull IExtendedBlockState parentIn) {
            super(parentIn.func_177230_c(), parentIn.func_177228_b());
            this.parent = parentIn;
        }

        @Nonnull
        public <V> V getValue(@Nonnull IUnlistedProperty<V> property) {
            if (property == BlockFluidBase.LEVEL_CORNERS[0]) {
                return (V)this.levelCorners[0];
            }
            if (property == BlockFluidBase.LEVEL_CORNERS[1]) {
                return (V)this.levelCorners[1];
            }
            if (property == BlockFluidBase.LEVEL_CORNERS[2]) {
                return (V)this.levelCorners[2];
            }
            if (property == BlockFluidBase.LEVEL_CORNERS[3]) {
                return (V)this.levelCorners[3];
            }
            if (property == BlockFluidBase.FLOW_DIRECTION) {
                return (V)this.flowDirection;
            }
            if (property == BlockFluidBase.SIDE_OVERLAYS[0]) {
                return (V)this.sideOverlays[0];
            }
            if (property == BlockFluidBase.SIDE_OVERLAYS[1]) {
                return (V)this.sideOverlays[1];
            }
            if (property == BlockFluidBase.SIDE_OVERLAYS[2]) {
                return (V)this.sideOverlays[2];
            }
            if (property == BlockFluidBase.SIDE_OVERLAYS[3]) {
                return (V)this.sideOverlays[3];
            }
            return (V)this.parent.getValue(property);
        }

        @Nonnull
        public <V> IExtendedBlockState withProperty(@Nonnull IUnlistedProperty<V> property, @Nonnull V value) {
            if (property == BlockFluidBase.LEVEL_CORNERS[0]) {
                this.levelCorners[0] = (Float)value;
            } else if (property == BlockFluidBase.LEVEL_CORNERS[1]) {
                this.levelCorners[1] = (Float)value;
            } else if (property == BlockFluidBase.LEVEL_CORNERS[2]) {
                this.levelCorners[2] = (Float)value;
            } else if (property == BlockFluidBase.LEVEL_CORNERS[3]) {
                this.levelCorners[3] = (Float)value;
            } else if (property == BlockFluidBase.FLOW_DIRECTION) {
                this.flowDirection = (Float)value;
            } else if (property == BlockFluidBase.SIDE_OVERLAYS[0]) {
                this.sideOverlays[0] = (Boolean)value;
            } else if (property == BlockFluidBase.SIDE_OVERLAYS[1]) {
                this.sideOverlays[1] = (Boolean)value;
            } else if (property == BlockFluidBase.SIDE_OVERLAYS[2]) {
                this.sideOverlays[2] = (Boolean)value;
            } else if (property == BlockFluidBase.SIDE_OVERLAYS[3]) {
                this.sideOverlays[3] = (Boolean)value;
            } else {
                FluidExtendedBlockState newState = new FluidExtendedBlockState(this.parent.withProperty(property, value));
                newState.flowDirection = this.flowDirection;
                newState.renderUnder = this.renderUnder;
                System.arraycopy(this.levelCorners, 0, newState.levelCorners, 0, 4);
                System.arraycopy(this.sideOverlays, 0, newState.sideOverlays, 0, 4);
                System.arraycopy(this.shouldSideBeRenderedCache, 0, newState.shouldSideBeRenderedCache, 0, 6);
                return newState;
            }
            return this;
        }

        @Nonnull
        public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
            return this.parent.getUnlistedProperties();
        }

        @Nonnull
        public Collection<IUnlistedProperty<?>> getUnlistedNames() {
            return this.parent.getUnlistedNames();
        }

        @Nonnull
        public IBlockState getClean() {
            return this.parent.getClean();
        }
    }
}

