/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.commands;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import silly511.backups.BackupManager;
import silly511.backups.BackupsMod;
import silly511.backups.helpers.BackupHelper;
import silly511.backups.helpers.FormatHelper;
import silly511.backups.util.GzipInputStream;
import silly511.backups.util.GzippedRegionLoader;

public class RestoreCommand
extends CommandBase {
    public static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy/M/d-k:mm:ss");

    public String func_71517_b() {
        return "restore";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.backups.restore.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        int l = args.length;
        if (l == 1) {
            return RestoreCommand.func_71530_a((String[])args, (String[])new String[]{"blocks", "player"});
        }
        if (l > 1) {
            if (args[0].equals("blocks")) {
                if (l > 1 && l <= 7) {
                    return RestoreCommand.func_175771_a((String[])args, (int)(l > 4 ? 4 : 1), (BlockPos)pos);
                }
                if (l == 8) {
                    return RestoreCommand.getListOfBackups(args);
                }
            } else if (args[0].equals("player")) {
                if (l == 2) {
                    return RestoreCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
                }
                if (l == 3) {
                    return RestoreCommand.getListOfBackups(args);
                }
            }
        }
        return Collections.emptyList();
    }

    public static List<String> getListOfBackups(String[] args) {
        ZoneId timeZone = ZoneId.systemDefault();
        List list = BackupHelper.listAllBackups(BackupManager.getCurrentBackupsDir()).stream().map(backup -> backup.time.atZone(timeZone).format(dateFormat)).collect(Collectors.toList());
        return RestoreCommand.func_175762_a((String[])args, list);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("commands.backups.restore.usage", new Object[0]);
        }
        if (args[0].equals("blocks")) {
            this.restoreBlocks(sender, args);
        } else if (args[0].equals("player")) {
            this.restorePlayer(server, sender, args);
        } else {
            throw new WrongUsageException("commands.backups.restore.usage", new Object[0]);
        }
    }

    public void restoreBlocks(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 8) {
            throw new WrongUsageException("commands.backups.restore.area.usage", new Object[0]);
        }
        sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
        World world = sender.func_130014_f_();
        StructureBoundingBox box = new StructureBoundingBox((Vec3i)RestoreCommand.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false), (Vec3i)RestoreCommand.func_175757_a((ICommandSender)sender, (String[])args, (int)4, (boolean)false));
        int size = box.func_78883_b() * box.func_78882_c() * box.func_78880_d();
        BackupHelper.Backup backup = RestoreCommand.parseBackup(args[7]);
        if (size > 524288) {
            throw new CommandException("commands.clone.tooManyBlocks", new Object[]{size, 524288});
        }
        if (!world.func_175711_a(box)) {
            throw new CommandException("commands.clone.outOfWorld", new Object[0]);
        }
        String dimDir = sender.func_130014_f_().field_73011_w.getSaveFolder();
        GzippedRegionLoader loader = new GzippedRegionLoader(dimDir == null ? backup.dir.toFile() : backup.dir.resolve(dimDir).toFile());
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos(box.field_78897_a, box.field_78895_b, box.field_78896_c), (BlockPos)new BlockPos(box.field_78893_d, box.field_78894_e, box.field_78892_f))) {
            IBlockState state = world.func_180495_p(pos);
            if (!state.func_185913_b() && !state.func_185917_h()) {
                blocks.addFirst(pos);
                continue;
            }
            blocks.addLast(pos);
        }
        for (BlockPos pos : blocks) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IInventory) {
                ((IInventory)tileEntity).func_174888_l();
            }
            world.func_180501_a(pos, Blocks.field_180401_cv.func_176223_P(), 2);
        }
        int changedCount = 0;
        for (BlockPos pos : blocks) {
            if (!world.func_180501_a(pos, loader.getBlockState(pos), 2)) continue;
            ++changedCount;
        }
        for (BlockPos pos : blocks) {
            TileEntity tileEntity = world.func_175625_s(pos);
            NBTTagCompound nbt = loader.getTileEntityData(pos);
            if (tileEntity == null || nbt == null) continue;
            tileEntity.func_145839_a(nbt);
            tileEntity.func_70296_d();
        }
        for (BlockPos pos : blocks) {
            GzippedRegionLoader.TileTick tileTick = loader.getTileTick(pos);
            if (tileTick == null) continue;
            world.func_180497_b(pos, tileTick.block, tileTick.time, tileTick.priority);
        }
        sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, changedCount);
        RestoreCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.backups.restore.area.success", (Object[])new Object[]{changedCount, backup.time.atZone(ZoneId.systemDefault()).format(FormatHelper.dateTimeFormat)});
    }

    public void restorePlayer(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 3) {
            throw new WrongUsageException("commands.backups.restore.player.usage", new Object[0]);
        }
        EntityPlayerMP player = RestoreCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
        BackupHelper.Backup backup = RestoreCommand.parseBackup(args[2]);
        Path playerFile = backup.dir.resolve("playerdata").resolve(player.func_189512_bd() + ".dat.gz");
        NBTTagCompound tag = null;
        if (Files.exists(playerFile, new LinkOption[0])) {
            try (GzipInputStream in = new GzipInputStream(Files.newInputStream(playerFile, new OpenOption[0]));){
                tag = CompressedStreamTools.func_74796_a((InputStream)in);
            }
            catch (IOException ex) {
                BackupsMod.logger.error("Unable to restore player", (Throwable)ex);
            }
        }
        if (tag == null || !tag.func_150297_b("Inventory", 9)) {
            throw new CommandException("commands.backups.restore.error", new Object[0]);
        }
        player.field_71071_by.func_70443_b(tag.func_150295_c("Inventory", 10));
        player.field_71069_bz.func_75142_b();
        RestoreCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.backups.restore.player.success", (Object[])new Object[]{player.func_70005_c_(), backup.time.atZone(ZoneId.systemDefault()).format(FormatHelper.dateTimeFormat)});
    }

    public static BackupHelper.Backup parseBackup(String s) throws CommandException {
        List<BackupHelper.Backup> backups = BackupHelper.listAllBackups(BackupManager.getCurrentBackupsDir());
        try {
            int backupsAgo = Integer.parseInt(s);
            if (backupsAgo < 1) {
                throw new NumberInvalidException("commands.generic.num.tooSmall", new Object[]{backupsAgo, 1});
            }
            if (backupsAgo > backups.size()) {
                throw new CommandException("commands.backups.restore.notABackup", new Object[0]);
            }
            return backups.get(backupsAgo - 1);
        }
        catch (NumberFormatException ex) {
            try {
                long time = LocalDateTime.parse(s, dateFormat).atZone(ZoneId.systemDefault()).toEpochSecond();
                return backups.stream().filter(backup -> backup.time.getEpochSecond() == time).findFirst().orElseThrow(() -> new CommandException("commands.backups.restore.notABackup", new Object[0]));
            }
            catch (DateTimeParseException ex2) {
                throw new CommandException("commands.backups.restore.invalidDate", new Object[]{s});
            }
        }
    }
}

