/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.gui;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.I18n;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.lang3.SystemUtils;
import org.lwjgl.input.Keyboard;
import silly511.backups.BackupsMod;
import silly511.backups.Config;
import silly511.backups.gui.GuiLabelBackup;
import silly511.backups.gui.GuiRestoreTask;
import silly511.backups.helpers.BackupHelper;
import silly511.backups.helpers.FileHelper;
import silly511.backups.helpers.FormatHelper;
import silly511.backups.helpers.ImageHelper;
import silly511.backups.util.LoadFromBackupMap;

public class GuiRestoreBackup
extends GuiScreen {
    public static final ResourceLocation MISSING_ICON = new ResourceLocation("textures/misc/unknown_server.png");
    private GuiScreen parentScreen;
    private String worldName;
    private Path worldDir;
    private Path backupsDir;
    private String calculatingText;
    private String restoreTooltip;
    private String enterBackupTooltip;
    private BackupsList list;
    private GuiButton restoreButton;
    private GuiButton clearLabelButton;
    private GuiButton setLabelButton;
    private GuiButton enterButton;
    private GuiButton deleteButton;
    private int tooltipCounter;
    private static Class<?> winFileAttribsClass;
    private static Field winVolSerialNumberF;
    private static Field winFileIndexHighF;
    private static Field winFileIndexLowF;

    public GuiRestoreBackup(GuiScreen guiSelectWorld, WorldSummary worldSummary) {
        this.parentScreen = guiSelectWorld;
        this.worldName = worldSummary.func_75788_b();
        this.worldDir = Paths.get("saves", worldSummary.func_75786_a());
        this.backupsDir = Paths.get(Config.backupsDir, worldSummary.func_75786_a());
    }

    public void func_73866_w_() {
        this.calculatingText = I18n.func_135052_a((String)"gui.backups.calculating", (Object[])new Object[0]);
        this.restoreTooltip = I18n.func_135052_a((String)"gui.backups.restore.tooltip", (Object[])new Object[0]);
        this.enterBackupTooltip = I18n.func_135052_a((String)"gui.backups.enter.tooltip", (Object[])new Object[0]);
        this.list = new BackupsList(BackupHelper.listAllBackups(this.backupsDir));
        this.restoreButton = new GuiButton(0, this.field_146294_l / 2 - 154, this.field_146295_m - 52, 150, 20, I18n.func_135052_a((String)"gui.backups.restore", (Object[])new Object[0]));
        this.field_146292_n.add(this.restoreButton);
        this.clearLabelButton = new GuiButton(1, this.field_146294_l / 2 - 154, this.field_146295_m - 28, 72, 20, I18n.func_135052_a((String)"gui.backups.clearLabel", (Object[])new Object[0]));
        this.field_146292_n.add(this.clearLabelButton);
        this.setLabelButton = new GuiButton(2, this.field_146294_l / 2 - 76, this.field_146295_m - 28, 72, 20, I18n.func_135052_a((String)"gui.backups.setLabel", (Object[])new Object[0]));
        this.field_146292_n.add(this.setLabelButton);
        this.enterButton = new GuiButton(3, this.field_146294_l / 2 + 4, this.field_146295_m - 52, 150, 20, I18n.func_135052_a((String)"gui.backups.enter", (Object[])new Object[0]));
        this.field_146292_n.add(this.enterButton);
        this.deleteButton = new GuiButton(4, this.field_146294_l / 2 + 4, this.field_146295_m - 28, 72, 20, I18n.func_135052_a((String)"gui.backups.delete", (Object[])new Object[0]));
        this.field_146292_n.add(this.deleteButton);
        this.field_146292_n.add(new GuiButton(5, this.field_146294_l / 2 + 82, this.field_146295_m - 28, 72, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.restoreButton.field_146124_l = false;
        this.clearLabelButton.field_146124_l = false;
        this.setLabelButton.field_146124_l = false;
        this.enterButton.field_146124_l = false;
        this.deleteButton.field_146124_l = false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.list.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.backups.title", (Object[])new Object[0]), this.field_146294_l / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.list.totalDirSize, this.field_146294_l - 5 - this.field_146289_q.func_78256_a(this.list.totalDirSize), 20, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.tooltipCounter >= 10) {
            if (this.restoreButton.func_146115_a()) {
                this.func_146279_a(this.restoreTooltip, mouseX, mouseY);
            } else if (this.enterButton.func_146115_a()) {
                this.func_146279_a(this.enterBackupTooltip, mouseX, mouseY);
            }
        }
    }

    public void func_73876_c() {
        if (this.restoreButton.func_146115_a() || this.enterButton.func_146115_a()) {
            if (this.tooltipCounter < 20) {
                ++this.tooltipCounter;
            }
        } else {
            this.tooltipCounter = 0;
        }
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        BackupHelper.Backup backup = this.list.getSelected();
        if (button.field_146127_k == 0) {
            String time = backup.time.atZone(ZoneId.systemDefault()).format(FormatHelper.dateTimeFormat);
            String message1 = I18n.func_135052_a((String)"gui.backups.confirmRestore1", (Object[])new Object[]{this.worldName, time});
            String message2 = I18n.func_135052_a((String)"gui.backups.confirmRestore2", (Object[])new Object[0]);
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, message1, message2, I18n.func_135052_a((String)"gui.backups.restore", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), button.field_146127_k));
        } else if (button.field_146127_k == 1) {
            backup.setLabel(null);
            backup.writeBackup();
        } else if (button.field_146127_k == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiLabelBackup(this, backup));
        } else if (button.field_146127_k == 3) {
            Path tempWorldDir = Paths.get("tempWorlds", String.valueOf(new Random().nextInt()));
            this.field_146297_k.func_147108_a((GuiScreen)new GuiRestoreTask(status -> {
                status.accept("gui.backups.loadingBackup");
                BackupHelper.restoreBackup(backup.dir, tempWorldDir, Paths.get("temp", new String[0]), f -> f.endsWith(".mca"));
            }, () -> {
                Class<RegionFileCache> clazz = RegionFileCache.class;
                synchronized (RegionFileCache.class) {
                    RegionFileCache.func_76551_a();
                    RegionFileCache.field_76553_a = new LoadFromBackupMap(backup.dir, tempWorldDir);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    try {
                        this.field_146297_k.func_71371_a(".." + File.separator + tempWorldDir, this.worldName, null);
                    }
                    catch (Exception e) {
                        BackupsMod.logger.error("ffdsf", (Throwable)e);
                        this.field_146297_k.func_147108_a(null);
                    }
                    return;
                }
            }));
        } else if (button.field_146127_k == 4) {
            String message = I18n.func_135052_a((String)"gui.backups.confirmDelete", (Object[])new Object[]{this.list.selected.size()});
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, message, "", I18n.func_135052_a((String)"gui.backups.delete", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), button.field_146127_k));
        } else if (button.field_146127_k == 5) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        }
    }

    public void func_73878_a(boolean result, int id) {
        super.func_73878_a(result, id);
        try {
            BackupHelper.Backup backup = this.list.getSelected();
            if (!result) {
                this.field_146297_k.func_147108_a((GuiScreen)this);
            } else if (id == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiRestoreTask(this.parentScreen, status -> {
                    if (Files.isDirectory(this.worldDir, new LinkOption[0])) {
                        status.accept("gui.backups.makingBackup");
                        BackupHelper.backup(this.worldDir, this.backupsDir, BackupHelper.BackupReason.RESTORE, null);
                    }
                    status.accept("gui.backups.restoring");
                    BackupHelper.restoreBackup(backup.dir, this.worldDir, Paths.get("temp", new String[0]), null);
                    BackupHelper.setLastBackup(this.backupsDir, backup.dir);
                }));
            } else if (id == 4) {
                for (BackupsList.BackupsListEntry entry : this.list.selected) {
                    BackupHelper.deleteBackup(entry.backup);
                }
                this.field_146297_k.func_147108_a((GuiScreen)this);
            }
        }
        catch (IOException ex) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)ex, (String)"Handling button press");
            throw new ReportedException(crashReport);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.func_178039_p();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (GuiRestoreBackup.func_175278_g((int)keyCode)) {
            this.list.selectAll();
        }
        super.func_73869_a(typedChar, keyCode);
    }

    static {
        if (SystemUtils.IS_OS_WINDOWS) {
            Class<?> fileAttribsClass = null;
            try {
                fileAttribsClass = Class.forName("sun.nio.fs.WindowsFileAttributes");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (fileAttribsClass != null) {
                Field volSerialNumber = null;
                Field fileIndexHigh = null;
                Field fileIndexLow = null;
                boolean foundAll = false;
                try {
                    volSerialNumber = fileAttribsClass.getDeclaredField("volSerialNumber");
                    volSerialNumber.setAccessible(true);
                    fileIndexHigh = fileAttribsClass.getDeclaredField("fileIndexHigh");
                    fileIndexHigh.setAccessible(true);
                    fileIndexLow = fileAttribsClass.getDeclaredField("fileIndexLow");
                    fileIndexLow.setAccessible(true);
                    foundAll = true;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (foundAll) {
                    winFileAttribsClass = fileAttribsClass;
                    winVolSerialNumberF = volSerialNumber;
                    winFileIndexHighF = fileIndexHigh;
                    winFileIndexLowF = fileIndexLow;
                }
            }
        }
    }

    private static class WindowsFileKey {
        public int volSerialNumber;
        public int fileIndexHigh;
        public int fileIndexLow;

        private WindowsFileKey() {
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof WindowsFileKey)) {
                return false;
            }
            WindowsFileKey o = (WindowsFileKey)obj;
            return this.volSerialNumber == o.volSerialNumber && this.fileIndexHigh == o.fileIndexHigh && this.fileIndexLow == o.fileIndexLow;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fileIndexHigh;
            result = 31 * result + this.fileIndexLow;
            result = 31 * result + this.volSerialNumber;
            return result;
        }
    }

    private class BackupsList
    extends GuiSlot {
        public final List<BackupsListEntry> entries;
        public final Set<BackupsListEntry> selected;
        public volatile String totalDirSize;

        public BackupsList(List<BackupHelper.Backup> backups) {
            super(GuiRestoreBackup.this.field_146297_k, GuiRestoreBackup.this.field_146294_l, GuiRestoreBackup.this.field_146295_m, 32, GuiRestoreBackup.this.field_146295_m - 64, 31);
            this.entries = new ArrayList<BackupsListEntry>();
            this.selected = new HashSet<BackupsListEntry>();
            this.field_148160_j = 2;
            this.totalDirSize = GuiRestoreBackup.this.calculatingText;
            ZoneId timeZone = ZoneId.systemDefault();
            long currentDay = LocalDate.now().toEpochDay();
            LocalDate lastDate = LocalDate.MIN;
            for (BackupHelper.Backup backup : backups) {
                LocalDate date = backup.time.atZone(timeZone).toLocalDate();
                long fromNow = currentDay - date.toEpochDay();
                String header = null;
                if (!date.equals(lastDate)) {
                    if (fromNow >= 30L) {
                        if (date.getYear() != lastDate.getYear() || date.getMonth() != lastDate.getMonth()) {
                            header = I18n.func_135052_a((String)("backups.misc.month." + date.getMonth().toString().toLowerCase()), (Object[])new Object[0]) + ", " + date.getYear();
                            lastDate = date;
                        }
                    } else if (fromNow >= 3L && (date.toEpochDay() + 3L) / 7L != (lastDate.toEpochDay() + 3L) / 7L || fromNow < 3L) {
                        header = FormatHelper.relativeDateFormat(date);
                        lastDate = date;
                    }
                }
                this.entries.add(new BackupsListEntry(backup, header));
            }
            new BackupsSizeThread().start();
        }

        protected int func_148127_b() {
            return this.entries.size();
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
                this.selected.clear();
            }
            this.selected.add(this.entries.get(slotIndex));
            ((GuiRestoreBackup)GuiRestoreBackup.this).enterButton.field_146124_l = this.selected.size() == 1;
            ((GuiRestoreBackup)GuiRestoreBackup.this).setLabelButton.field_146124_l = ((GuiRestoreBackup)GuiRestoreBackup.this).enterButton.field_146124_l;
            ((GuiRestoreBackup)GuiRestoreBackup.this).clearLabelButton.field_146124_l = ((GuiRestoreBackup)GuiRestoreBackup.this).enterButton.field_146124_l;
            ((GuiRestoreBackup)GuiRestoreBackup.this).restoreButton.field_146124_l = ((GuiRestoreBackup)GuiRestoreBackup.this).enterButton.field_146124_l;
            boolean bl = ((GuiRestoreBackup)GuiRestoreBackup.this).deleteButton.field_146124_l = this.selected.size() > 0;
            if (isDoubleClick && ((GuiRestoreBackup)GuiRestoreBackup.this).enterButton.field_146124_l) {
                try {
                    GuiRestoreBackup.this.func_146284_a(GuiRestoreBackup.this.enterButton);
                }
                catch (Exception ex) {
                    CrashReport crashReport = CrashReport.func_85055_a((Throwable)ex, (String)"Handling button press");
                    throw new ReportedException(crashReport);
                }
            }
        }

        public void selectAll() {
            this.selected.addAll(this.entries);
        }

        protected boolean func_148131_a(int slotIndex) {
            return this.selected.contains(this.entries.get(slotIndex));
        }

        protected void func_148123_a() {
        }

        protected void func_192637_a(int entryID, int x, int y, int height, int mouseX, int mouseY, float partialTicks) {
            BackupsListEntry entry = this.entries.get(entryID);
            GuiRestoreBackup.this.field_146289_q.func_78276_b(entry.title, x + 27, y + 1, 0xFFFFFF);
            GuiRestoreBackup.this.field_146289_q.func_78276_b(entry.desc + entry.size + ")", x + 27, y + 12, 0x808080);
            if (entry.header != null) {
                int x2 = Math.max(x - 120, 5);
                GuiRestoreBackup.this.func_73730_a(x2, x + this.func_148139_c(), y - 4, -5658199);
                GuiRestoreBackup.this.field_146289_q.func_78276_b(entry.header, x2, y - 2, 0xA9A9A9);
            }
            this.field_148161_k.func_110434_K().func_110577_a(entry.iconLoc == null ? MISSING_ICON : entry.iconLoc);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)24, (int)24, (float)24.0f, (float)24.0f);
            GlStateManager.func_179084_k();
        }

        protected void func_192638_a(int x, int y, int mouseX, int mouseY, float partialTicks) {
            int size = this.func_148127_b();
            for (int i = 0; i < size; ++i) {
                int slotY = y + i * this.field_148149_f + this.field_148160_j;
                if (this.field_148166_t && this.func_148131_a(i)) {
                    int minX = this.field_148152_e + (this.field_148155_a / 2 - this.func_148139_c() / 2);
                    int maxX = this.field_148152_e + (this.field_148155_a / 2 + this.func_148139_c() / 2);
                    Gui.func_73734_a((int)minX, (int)slotY, (int)maxX, (int)(slotY + this.field_148149_f - 3), (int)-8355712);
                    Gui.func_73734_a((int)(minX + 1), (int)(slotY + 1), (int)(maxX - 1), (int)(slotY + this.field_148149_f - 4), (int)-16777216);
                }
                this.func_192637_a(i, x, slotY + 2, this.field_148149_f - 4, mouseX, mouseY, partialTicks);
            }
        }

        public BackupHelper.Backup getSelected() {
            return this.selected.isEmpty() ? null : this.selected.iterator().next().backup;
        }

        private class BackupsListEntry {
            public final BackupHelper.Backup backup;
            public final String header;
            public final String title;
            public final String desc;
            public volatile String size;
            public ResourceLocation iconLoc;

            public BackupsListEntry(BackupHelper.Backup backup, String header) {
                this.backup = backup;
                this.header = header;
                this.size = GuiRestoreBackup.this.calculatingText;
                String time = backup.time.atZone(ZoneId.systemDefault()).format(FormatHelper.dateTimeFormat);
                this.title = backup.getLabel() == null ? time : TextFormatting.UNDERLINE + backup.getLabel() + TextFormatting.RESET + "" + TextFormatting.GRAY + " (" + time + ")";
                String reason = I18n.func_135052_a((String)(backup.reason != null ? backup.reason.tranKey : "backups.reason.unknown"), (Object[])new Object[0]);
                this.desc = reason + ", " + backup.mcVersion + " (";
                ResourceLocation iconLoc = new ResourceLocation("backups", "backup/" + GuiRestoreBackup.this.worldDir.getFileName() + "/" + backup.dir.getFileName() + "/icon");
                Path iconFile = backup.dir.resolve("icon.png");
                BufferedImage image = null;
                try {
                    if (Files.isRegularFile(iconFile, new LinkOption[0])) {
                        image = ImageIO.read(iconFile.toFile());
                    } else {
                        NBTTagCompound tag;
                        Path metadataFile = backup.dir.resolve("backupMetadata.dat");
                        if (Files.isRegularFile(metadataFile, new LinkOption[0]) && (tag = CompressedStreamTools.func_74797_a((File)metadataFile.toFile())).func_74764_b("Icon")) {
                            image = ImageHelper.fromCompressedBytes(tag.func_74770_j("Icon"), 64, 64);
                        }
                    }
                }
                catch (IOException ex) {
                    BackupsMod.logger.error("Unable to load icon for backup " + backup.time, (Throwable)ex);
                }
                if (image != null) {
                    BackupsList.this.field_148161_k.func_110434_K().func_110579_a(iconLoc, (ITextureObject)new DynamicTexture(image));
                    this.iconLoc = iconLoc;
                }
            }
        }

        private class BackupsSizeThread
        extends Thread {
            public BackupsSizeThread() {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    HashSet<Object> fileKeys = new HashSet<Object>();
                    long total = 0L;
                    for (BackupsListEntry entry : Lists.reverse(BackupsList.this.entries)) {
                        long size = 0L;
                        for (Path path : FileHelper.listFilesDeep(entry.backup.dir, false)) {
                            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                            if (attr.isDirectory() || !fileKeys.add(this.getFileKey(attr))) continue;
                            size += attr.size();
                        }
                        entry.size = FormatHelper.shortenNumber(size, 1024L) + "Bs";
                        total += size;
                    }
                    BackupsList.this.totalDirSize = FormatHelper.shortenNumber(total, 1024L) + "Bs";
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public Object getFileKey(BasicFileAttributes attr) {
                if (SystemUtils.IS_OS_WINDOWS && winFileAttribsClass != null && winFileAttribsClass.isInstance(attr)) {
                    try {
                        WindowsFileKey key = new WindowsFileKey();
                        key.volSerialNumber = winVolSerialNumberF.getInt(attr);
                        key.fileIndexHigh = winFileIndexHighF.getInt(attr);
                        key.fileIndexLow = winFileIndexLowF.getInt(attr);
                        return key;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                return attr.fileKey();
            }
        }
    }
}

