/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.helpers;

import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import net.minecraft.client.resources.I18n;

public final class FormatHelper {
    public static final DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("M/d/yyyy h:mm:ss a");
    public static final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("h:mm:ss a");
    public static final DecimalFormat singleDecimal = new DecimalFormat("#.#");

    public static String shortenNumber(long number, long base) {
        long base2 = base * base;
        long base3 = base2 * base;
        long base4 = base3 * base;
        long base5 = base4 * base;
        long base6 = base5 * base;
        if (number >= base6) {
            return singleDecimal.format((double)number / (double)base6) + "E";
        }
        if (number >= base5) {
            return singleDecimal.format((double)number / (double)base5) + "P";
        }
        if (number >= base4) {
            return singleDecimal.format((double)number / (double)base4) + "T";
        }
        if (number >= base3) {
            return singleDecimal.format((double)number / (double)base3) + "G";
        }
        if (number >= base2) {
            return singleDecimal.format((double)number / (double)base2) + "M";
        }
        if (number >= base) {
            return singleDecimal.format((double)number / (double)base) + "K";
        }
        return String.valueOf(number);
    }

    public static String relativeDateFormat(LocalDate date) {
        LocalDate today = LocalDate.now(ZoneId.systemDefault());
        if (date.equals(today)) {
            return I18n.func_135052_a((String)"backups.misc.today", (Object[])new Object[0]);
        }
        if (date.equals(today.minusDays(1L))) {
            return I18n.func_135052_a((String)"backups.misc.yesterday", (Object[])new Object[0]);
        }
        if (today.toEpochDay() - date.toEpochDay() < 7L) {
            return I18n.func_135052_a((String)("backups.misc.weekday." + date.getDayOfWeek().toString().toLowerCase()), (Object[])new Object[0]);
        }
        return date.getDayOfMonth() + ", " + I18n.func_135052_a((String)("backups.misc.month." + date.getMonth().toString().toLowerCase()), (Object[])new Object[0]) + ", " + date.getYear();
    }

    public static String relativeTimeAgo(Instant time) {
        long sec = Instant.now().getEpochSecond() - time.getEpochSecond();
        LinkedList<String> list = new LinkedList<String>();
        long t = 0L;
        t = sec / 31536000L;
        if (t != 0L) {
            list.add(t + " year" + (t == 1L ? "" : "s"));
        }
        if ((t = sec % 31536000L / 86400L) != 0L) {
            list.add(t + " day" + (t == 1L ? "" : "s"));
        }
        if ((t = sec % 86400L / 3600L) != 0L) {
            list.add(t + " hour" + (t == 1L ? "" : "s"));
        }
        if ((t = sec % 3600L / 60L) != 0L) {
            list.add(t + " minute" + (t == 1L ? "" : "s"));
        }
        if ((t = sec % 60L) != 0L) {
            list.add(t + " second" + (t == 1L ? "" : "s"));
        }
        return String.join((CharSequence)", ", list);
    }

    public static String removeEnd(String str, String remove) {
        return str.endsWith(remove) ? str.substring(0, str.length() - remove.length()) : str;
    }
}

