/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.renderer.chunk;

import java.util.List;
import java.util.function.Supplier;
import meldexun.matrixutil.Matrix4f;
import meldexun.nothirium.api.renderer.IVBOPart;
import meldexun.nothirium.api.renderer.chunk.ChunkRenderPass;
import meldexun.nothirium.mc.config.NothiriumConfig;
import meldexun.nothirium.mc.renderer.chunk.ChunkRendererDynamicVbo;
import meldexun.nothirium.mc.renderer.chunk.RenderChunk;
import meldexun.nothirium.mc.util.FogUtil;
import meldexun.nothirium.mc.util.ResourceSupplier;
import meldexun.nothirium.opengl.DynamicVBO;
import meldexun.nothirium.util.ListUtil;
import meldexun.renderlib.util.GLShader;
import meldexun.renderlib.util.GLUtil;
import meldexun.renderlib.util.RenderUtil;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class ChunkRendererGL20
extends ChunkRendererDynamicVbo {
    private static final String A_POS = "a_Pos";
    private static final String A_COLOR = "a_Color";
    private static final String A_TEXCOORD = "a_TexCoord";
    private static final String A_LIGHTCOORD = "a_LightCoord";
    private static final String A_OFFSET = "a_Offset";
    private static final String U_BLOCKTEX = "u_BlockTex";
    private static final String U_LIGHTTEX = "u_LightTex";
    private static final String U_MATRIX = "u_ModelViewProjectionMatrix";
    private final GLShader shader = new GLShader.Builder().addShader(35633, (Supplier)new ResourceSupplier(new ResourceLocation("nothirium", "shaders/chunk_vert.glsl"))).addShader(35632, (Supplier)new ResourceSupplier(new ResourceLocation("nothirium", "shaders/chunk_frag.glsl"))).bindAttribute("a_Pos", 0).bindAttribute("a_Color", 1).bindAttribute("a_TexCoord", 2).bindAttribute("a_LightCoord", 3).bindAttribute("a_Offset", 4).build(p -> {
        GL20.glUniform1i((int)p.getUniform(U_BLOCKTEX), (int)0);
        GL20.glUniform1i((int)p.getUniform(U_LIGHTTEX), (int)1);
    });

    @Override
    public NothiriumConfig.RenderEngine getRenderEngine() {
        return NothiriumConfig.RenderEngine.GL20;
    }

    @Override
    public String name() {
        return "Nothirium GL 2.0";
    }

    @Override
    public void init(int renderDistance) {
    }

    @Override
    protected void renderChunks(ChunkRenderPass pass) {
        GLShader.push();
        this.shader.use();
        Matrix4f matrix = RenderUtil.getProjectionModelViewMatrix();
        GLUtil.setMatrix((int)this.shader.getUniform(U_MATRIX), (Matrix4f)matrix);
        FogUtil.setupFogFromGL(this.shader);
        GL15.glBindBuffer((int)34962, (int)((DynamicVBO)this.vbos.get(pass)).getVbo());
        this.setupClientState(pass);
        this.setupAttributePointers(pass);
        double cameraX = RenderUtil.getCameraEntityX();
        double cameraY = RenderUtil.getCameraEntityY();
        double cameraZ = RenderUtil.getCameraEntityZ();
        ListUtil.forEach((List)this.chunks.get(pass), pass == ChunkRenderPass.TRANSLUCENT, (renderChunk, i) -> this.draw((RenderChunk)renderChunk, pass, cameraX, cameraY, cameraZ));
        this.resetClientState(pass);
        GL15.glBindBuffer((int)34962, (int)0);
        GLShader.pop();
    }

    protected void setupClientState(ChunkRenderPass pass) {
        GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_POS));
        GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_COLOR));
        GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_TEXCOORD));
        GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_LIGHTCOORD));
    }

    protected void setupAttributePointers(ChunkRenderPass pass) {
        GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_POS), (int)3, (int)5126, (boolean)false, (int)28, (long)0L);
        GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_COLOR), (int)4, (int)5121, (boolean)true, (int)28, (long)12L);
        GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_TEXCOORD), (int)2, (int)5126, (boolean)false, (int)28, (long)16L);
        GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_LIGHTCOORD), (int)2, (int)5122, (boolean)false, (int)28, (long)24L);
    }

    protected void draw(RenderChunk renderChunk, ChunkRenderPass pass, double cameraX, double cameraY, double cameraZ) {
        GL20.glVertexAttrib3f((int)this.shader.getAttribute(A_OFFSET), (float)((float)((double)renderChunk.getX() - cameraX)), (float)((float)((double)renderChunk.getY() - cameraY)), (float)((float)((double)renderChunk.getZ() - cameraZ)));
        IVBOPart vboPart = renderChunk.getVBOPart(pass);
        GL11.glDrawArrays((int)7, (int)vboPart.getFirst(), (int)vboPart.getCount());
    }

    protected void resetClientState(ChunkRenderPass pass) {
        GL20.glDisableVertexAttribArray((int)this.shader.getAttribute(A_POS));
        GL20.glDisableVertexAttribArray((int)this.shader.getAttribute(A_COLOR));
        GL20.glDisableVertexAttribArray((int)this.shader.getAttribute(A_TEXCOORD));
        GL20.glDisableVertexAttribArray((int)this.shader.getAttribute(A_LIGHTCOORD));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.shader.dispose();
    }
}

