/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntComparators;
import java.util.BitSet;
import java.util.stream.IntStream;
import meldexun.memoryutil.MemoryAccess;
import meldexun.memoryutil.UnsafeBufferUtil;

public class VertexSortUtil {
    public static void sortVertexData(MemoryAccess vertexData, int vertexCount, int vertexSize, int primitiveSize, float dx, float dy, float dz) {
        if (vertexCount == 0) {
            return;
        }
        int[] primitiveOrder = VertexSortUtil.calculatePrimitiveOrder(vertexData, vertexCount, vertexSize, primitiveSize, dx, dy, dz);
        int bytesPerPrimitive = vertexSize * primitiveSize;
        UnsafeBufferUtil.tempBuffer((long)bytesPerPrimitive, tempBuffer -> {
            BitSet sortedPrimitivess = new BitSet();
            int i1 = sortedPrimitivess.nextClearBit(0);
            while (i1 < primitiveOrder.length) {
                int j1 = primitiveOrder[i1];
                if (j1 != i1) {
                    MemoryAccess.copyMemory((MemoryAccess)vertexData, (long)(j1 * bytesPerPrimitive), (MemoryAccess)tempBuffer, (long)0L, (long)bytesPerPrimitive);
                    int k1 = j1;
                    int l1 = primitiveOrder[j1];
                    while (k1 != i1) {
                        MemoryAccess.copyMemory((MemoryAccess)vertexData, (long)(l1 * bytesPerPrimitive), (MemoryAccess)vertexData, (long)(k1 * bytesPerPrimitive), (long)bytesPerPrimitive);
                        sortedPrimitivess.set(k1);
                        k1 = l1;
                        l1 = primitiveOrder[l1];
                    }
                    MemoryAccess.copyMemory((MemoryAccess)tempBuffer, (long)0L, (MemoryAccess)vertexData, (long)(i1 * bytesPerPrimitive), (long)bytesPerPrimitive);
                }
                sortedPrimitivess.set(i1);
                i1 = sortedPrimitivess.nextClearBit(i1 + 1);
            }
        });
    }

    private static int[] calculatePrimitiveOrder(MemoryAccess vertexData, int vertexCount, int vertexSize, int primitiveSize, float dx, float dy, float dz) {
        float[] primitiveSqrDistTo = VertexSortUtil.calculatePrimitiveSqrDistTo(vertexData, vertexCount, vertexSize, primitiveSize, dx, dy, dz);
        int[] primitiveOrder = IntStream.range(0, vertexCount / primitiveSize).toArray();
        IntArrays.mergeSort((int[])primitiveOrder, (IntComparator)IntComparators.oppositeComparator((IntComparator)VertexSortUtil.comparingFloat(i -> primitiveSqrDistTo[i])));
        return primitiveOrder;
    }

    private static float[] calculatePrimitiveSqrDistTo(MemoryAccess vertexData, int vertexCount, int vertexSize, int primitiveSize, float dx, float dy, float dz) {
        float[] primitiveSqrDistTo = new float[vertexCount / primitiveSize];
        for (int i = 0; i < vertexCount / primitiveSize; ++i) {
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            for (int j = 0; j < primitiveSize; ++j) {
                x += vertexData.getFloat((long)((i * primitiveSize + j) * vertexSize));
                y += vertexData.getFloat((long)((i * primitiveSize + j) * vertexSize + 4));
                z += vertexData.getFloat((long)((i * primitiveSize + j) * vertexSize + 8));
            }
            x /= (float)primitiveSize;
            y /= (float)primitiveSize;
            z /= (float)primitiveSize;
            primitiveSqrDistTo[i] = (x += dx) * x + (y += dy) * y + (z += dz) * z;
        }
        return primitiveSqrDistTo;
    }

    private static IntComp comparingFloat(Int2FloatFunc f) {
        return (x, y) -> Float.compare(f.apply(x), f.apply(y));
    }

    @FunctionalInterface
    private static interface Int2FloatFunc {
        public float apply(int var1);
    }

    @FunctionalInterface
    private static interface IntComp
    extends IntComparator {
        default public int compare(Integer o1, Integer o2) {
            return this.compare(o1, o2);
        }
    }
}

