/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util.cache;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import meldexun.nothirium.util.function.IntIntInt2ObjFunction;
import meldexun.nothirium.util.function.IntIntIntObj2ObjFunction;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.Validate;

public class Cache3D<V> {
    private final int startX;
    private final int startY;
    private final int startZ;
    private final int endX;
    private final int endY;
    private final int endZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final V defaultValue;
    private final V[] data;

    public Cache3D(int startX, int startY, int startZ, int endX, int endY, int endZ, V defaultValue, IntFunction<V[]> init) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
        this.sizeX = endX - startX + 1;
        this.sizeY = endY - startY + 1;
        this.sizeZ = endZ - startZ + 1;
        this.defaultValue = defaultValue;
        this.data = init.apply(this.sizeX * this.sizeY * this.sizeZ);
    }

    public Cache3D(int startX, int startY, int startZ, int endX, int endY, int endZ, V defaultValue, V[] data) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
        this.sizeX = endX - startX + 1;
        this.sizeY = endY - startY + 1;
        this.sizeZ = endZ - startZ + 1;
        this.defaultValue = defaultValue;
        this.data = data;
        Validate.isTrue((this.sizeX * this.sizeY * this.sizeZ == data.length ? 1 : 0) != 0);
    }

    private int index(BlockPos pos) {
        return this.index(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private int index(int x, int y, int z) {
        return ((x - this.startX) * this.sizeY + y - this.startY) * this.sizeZ + z - this.startZ;
    }

    public boolean inBounds(BlockPos pos) {
        return this.inBounds(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean inBounds(int x, int y, int z) {
        if (x < this.startX || x > this.endX) {
            return false;
        }
        if (y < this.startY || y > this.endY) {
            return false;
        }
        return z >= this.startZ && z <= this.endZ;
    }

    public void put(BlockPos pos, V v) {
        this.put(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), v);
    }

    public void put(int x, int y, int z, V v) {
        if (!this.inBounds(x, y, z)) {
            return;
        }
        this.data[this.index((int)x, (int)y, (int)z)] = v;
    }

    public V get(BlockPos pos) {
        return this.get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public V get(int x, int y, int z) {
        if (!this.inBounds(x, y, z)) {
            return this.defaultValue;
        }
        return this.data[this.index(x, y, z)];
    }

    public V computeIfAbsent(BlockPos pos, Function<BlockPos, V> mappingFunction) {
        if (!this.inBounds(pos)) {
            return this.defaultValue;
        }
        int index = this.index(pos);
        V v = this.data[index];
        if (v == null) {
            this.data[index] = v = mappingFunction.apply(pos);
        }
        return v;
    }

    public V computeIfAbsent(int x, int y, int z, IntIntInt2ObjFunction<V> mappingFunction) {
        if (!this.inBounds(x, y, z)) {
            return this.defaultValue;
        }
        int index = this.index(x, y, z);
        V v = this.data[index];
        if (v == null) {
            this.data[index] = v = mappingFunction.apply(x, y, z);
        }
        return v;
    }

    public V computeIfPresent(BlockPos pos, BiFunction<BlockPos, V, V> mappingFunction) {
        if (!this.inBounds(pos)) {
            return this.defaultValue;
        }
        int index = this.index(pos);
        V v = this.data[index];
        if (v != null) {
            this.data[index] = v = mappingFunction.apply(pos, v);
        }
        return v;
    }

    public V computeIfPresent(int x, int y, int z, IntIntIntObj2ObjFunction<V, V> mappingFunction) {
        if (!this.inBounds(x, y, z)) {
            return this.defaultValue;
        }
        int index = this.index(x, y, z);
        V v = this.data[index];
        if (v != null) {
            this.data[index] = v = mappingFunction.apply(x, y, z, v);
        }
        return v;
    }

    public V compute(BlockPos pos, BiFunction<BlockPos, V, V> mappingFunction) {
        if (!this.inBounds(pos)) {
            return this.defaultValue;
        }
        int index = this.index(pos);
        V v = mappingFunction.apply(pos, this.data[index]);
        this.data[index] = v;
        return v;
    }

    public V compute(int x, int y, int z, IntIntIntObj2ObjFunction<V, V> mappingFunction) {
        if (!this.inBounds(x, y, z)) {
            return this.defaultValue;
        }
        int index = this.index(x, y, z);
        V v = mappingFunction.apply(x, y, z, this.data[index]);
        this.data[index] = v;
        return v;
    }

    public V[] getData() {
        return this.data;
    }
}

