/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util.cache;

import java.util.function.IntFunction;
import meldexun.nothirium.util.function.IntIntIntInt2IntFunction;
import meldexun.nothirium.util.function.ObjInt2IntFunction;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.Validate;

public class IntCache3D {
    private final int startX;
    private final int startY;
    private final int startZ;
    private final int endX;
    private final int endY;
    private final int endZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int defaultValue;
    private final int[] data;

    public IntCache3D(int startX, int startY, int startZ, int endX, int endY, int endZ, int defaultValue, IntFunction<int[]> init) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
        this.sizeX = endX - startX + 1;
        this.sizeY = endY - startY + 1;
        this.sizeZ = endZ - startZ + 1;
        this.defaultValue = defaultValue;
        this.data = init.apply(this.sizeX * this.sizeY * this.sizeZ);
    }

    public IntCache3D(int startX, int startY, int startZ, int endX, int endY, int endZ, int defaultValue, int[] data) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
        this.sizeX = endX - startX + 1;
        this.sizeY = endY - startY + 1;
        this.sizeZ = endZ - startZ + 1;
        this.defaultValue = defaultValue;
        this.data = data;
        Validate.isTrue((this.sizeX * this.sizeY * this.sizeZ == data.length ? 1 : 0) != 0);
    }

    private int index(BlockPos pos) {
        return this.index(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private int index(int x, int y, int z) {
        return ((x - this.startX) * this.sizeY + y - this.startY) * this.sizeZ + z - this.startZ;
    }

    public boolean inBounds(BlockPos pos) {
        return this.inBounds(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean inBounds(int x, int y, int z) {
        if (x < this.startX || x > this.endX) {
            return false;
        }
        if (y < this.startY || y > this.endY) {
            return false;
        }
        return z >= this.startZ && z <= this.endZ;
    }

    public void put(BlockPos pos, int v) {
        this.put(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), v);
    }

    public void put(int x, int y, int z, int v) {
        if (!this.inBounds(x, y, z)) {
            return;
        }
        this.data[this.index((int)x, (int)y, (int)z)] = v;
    }

    public int get(BlockPos pos) {
        return this.get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public int get(int x, int y, int z) {
        if (!this.inBounds(x, y, z)) {
            return this.defaultValue;
        }
        return this.data[this.index(x, y, z)];
    }

    public int compute(BlockPos pos, ObjInt2IntFunction<BlockPos> mappingFunction) {
        int v;
        if (!this.inBounds(pos)) {
            return this.defaultValue;
        }
        int index = this.index(pos);
        this.data[index] = v = mappingFunction.apply(pos, this.data[index]);
        return v;
    }

    public int compute(int x, int y, int z, IntIntIntInt2IntFunction mappingFunction) {
        int v;
        if (!this.inBounds(x, y, z)) {
            return this.defaultValue;
        }
        int index = this.index(x, y, z);
        this.data[index] = v = mappingFunction.apply(x, y, z, this.data[index]);
        return v;
    }

    public int[] getData() {
        return this.data;
    }
}

