/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util.collection;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import meldexun.nothirium.util.collection.IMultiObject;
import meldexun.nothirium.util.function.IntBiConsumer;
import meldexun.nothirium.util.function.IntObjConsumer;

public class IntMultiObject
implements IMultiObject<Integer> {
    protected final int size;
    protected final int[] values;
    protected int index;
    private int value;

    public IntMultiObject(int size) {
        this.size = size;
        this.values = new int[size];
    }

    public IntMultiObject(int size, IntUnaryOperator mapper) {
        this(size);
        this.fill(mapper);
    }

    public IntMultiObject(int size, IntSupplier mapper) {
        this(size);
        this.fill(mapper);
    }

    @Override
    public void update() {
        this.index = (this.index + 1) % this.size;
        this.value = this.values[this.index];
    }

    @Override
    @Deprecated
    public Integer get() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Integer get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void set(Integer t) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void set(int index, Integer t) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Stream<Integer> stream() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void forEach(IntObjConsumer<Integer> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void forEach(Consumer<Integer> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void fill(IntFunction<Integer> mapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void fill(Supplier<Integer> mapper) {
        throw new UnsupportedOperationException();
    }

    public int getInt() {
        return this.value;
    }

    public int getInt(int index) {
        return this.values[index];
    }

    @Override
    public void set(int t) {
        this.values[this.index] = t;
        this.value = t;
    }

    @Override
    public void set(int index, int t) {
        this.values[index] = t;
        if (index == this.index) {
            this.value = t;
        }
    }

    public IntStream streamInt() {
        return Arrays.stream(this.values);
    }

    public void forEach(IntBiConsumer action) {
        for (int i = 0; i < this.values.length; ++i) {
            action.accept(i, this.values[i]);
        }
    }

    public void forEach(IntConsumer action) {
        for (int t : this.values) {
            action.accept(t);
        }
    }

    public void fill(IntUnaryOperator mapper) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = mapper.applyAsInt(i);
        }
    }

    public void fill(IntSupplier mapper) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = mapper.getAsInt();
        }
    }
}

