/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.railcraft.patcher;

import info.tritusk.modpack.railcraft.patcher.ModContainer;
import mods.railcraft.common.items.firestone.FirestoneTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AlternativeFirestoneTicker {
    private static final Logger LOGGER = LogManager.getLogger(AlternativeFirestoneTicker.class);

    @SubscribeEvent
    public static void on(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != Side.SERVER) {
            return;
        }
        EntityPlayer player = event.player;
        if ((player.field_70170_p.func_82737_E() + (long)player.func_145782_y()) % 4L != 0L) {
            return;
        }
        if (player.field_71070_bA == player.field_71069_bz) {
            for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                FirestoneTools.trySpawnFire((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (ItemStack)itemStack, (EntityPlayer)player);
            }
            for (ItemStack itemStack : player.field_71071_by.field_70460_b) {
                FirestoneTools.trySpawnFire((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (ItemStack)itemStack, (EntityPlayer)player);
            }
            for (ItemStack itemStack : player.field_71071_by.field_184439_c) {
                FirestoneTools.trySpawnFire((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (ItemStack)itemStack, (EntityPlayer)player);
            }
        }
    }

    public static void intercept(EventBus bus, Object originalEventListener) {
        if (ModContainer.useAlternativeFirestoneTicker) {
            LOGGER.info("Registering alternative firestone ticker. Old listener: {}", originalEventListener);
            bus.register(AlternativeFirestoneTicker.class);
        } else {
            LOGGER.info("Use original firestone ticker.");
            bus.register(originalEventListener);
        }
    }
}

