/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.railcraft.patcher;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import info.tritusk.modpack.railcraft.patcher.Recipes;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mods.railcraft.api.charge.IChargeBlock;
import mods.railcraft.common.util.charge.ChargeNetwork;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;

public class ModContainer
extends DummyModContainer {
    public static boolean useAlternativeFirestoneTicker = true;
    public static boolean disableFluidTextureFix = true;
    public static boolean useAlternativeFluidTextureFix = true;

    public ModContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "railway_depot_worker";
        meta.name = "Railway Depot Worker";
        meta.description = "Coremod to fix issues found in Railcraft. Railcraft dev for 1.12.2 is in hiatus, so...";
        meta.version = "1.4.0";
        meta.authorList = Collections.singletonList("3TUSK");
        meta.requiredMods = Collections.singleton(VersionParser.parseVersionReference((String)"railcraft@(,12.1.0-beta-9)"));
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public Set<ArtifactVersion> getRequirements() {
        return new HashSet<ArtifactVersion>(this.getMetadata().requiredMods);
    }

    @Subscribe
    public void construct(FMLConstructionEvent event) {
        File cfgFile = new File(Loader.instance().getConfigDir(), "railway_depot_worker.cfg");
        Configuration config = new Configuration(cfgFile);
        config.load();
        Property prop = config.get("general", "useAlternativeFirestoneTicker", true);
        prop.setRequiresMcRestart(true);
        useAlternativeFirestoneTicker = prop.getBoolean();
        prop = config.get("general", "disableFluidTextureFix", true, "It seems that Railcraft was trying to \"fix\" fluids from other mods that forgot to register the texture into atlas. \nHowever, this is known to break some unusual fluid textures, most notably Molten Demon Metal from ExtraUtils2 when Tinkers Construct is also installed. \nThis option lets you to control whether you want this \"fix\" or not.");
        prop.setRequiresMcRestart(true);
        disableFluidTextureFix = prop.getBoolean();
        prop = config.get("general", "useAlternativeFluidTextureFix", true, "If Fluid Texture Fix is used, set this to true will use an alternative version of the fix, which is compatible with ExtraUtils2.");
        prop.setRequiresMcRestart(true);
        useAlternativeFluidTextureFix = prop.getBoolean();
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        Recipes.addExtraRecipes();
    }

    @Subscribe
    public void completed(FMLLoadCompleteEvent event) {
        Map theMap = (Map)ChargeNetwork.CONNECTION_MAPS.get(IChargeBlock.ConnectType.BLOCK);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos altKey = new BlockPos(facing.func_176730_m());
            if (theMap.containsKey(altKey)) continue;
            theMap.put(altKey, theMap.get(facing.func_176730_m()));
        }
    }

    @Subscribe
    public void onServerStarted(FMLServerStartedEvent event) {
        for (Integer i : DimensionManager.getStaticDimensionIDs()) {
            File dimDir;
            WorldServer theWorld = DimensionManager.getWorld((int)i);
            if (theWorld != null) continue;
            File saveDir = DimensionManager.getCurrentSaveRootDirectory();
            String dimDirName = DimensionManager.createProviderFor((int)i).getSaveFolder();
            if (dimDirName == null || !ForgeChunkManager.savedWorldHasForcedChunkTickets((File)(dimDir = new File(saveDir, dimDirName)))) continue;
            DimensionManager.initDimension((int)i);
        }
    }
}

