/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.railcraft.patcher;

import info.tritusk.modpack.railcraft.patcher.IC2EmitterLogicPatcher;
import java.util.function.BiFunction;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class Xformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName == null) {
            return basicClass;
        }
        switch (transformedName) {
            case "mods.railcraft.common.plugins.jei.rolling.RollingMachineRecipeCategory": {
                return Xformer.tryFixRollingRecipeDisplayInJEI(basicClass);
            }
            case "mods.railcraft.common.blocks.TileRailcraft": {
                return Xformer.tryPatchingTileRailcraft(basicClass);
            }
            case "mods.railcraft.common.blocks.machine.worldspike.TileWorldspike": {
                return this.tryExpandStackSizeLimitInWorldSpike(basicClass);
            }
            case "mods.railcraft.common.blocks.structures.StructurePattern": {
                return Xformer.tryFixStructurePatternCheck(basicClass);
            }
            case "mods.railcraft.common.blocks.logic.IC2EmitterLogic": {
                return Xformer.tryFixIC2EmitterLogic(basicClass);
            }
            case "mods.railcraft.common.blocks.machine.manipulator.TileRFLoader": 
            case "mods.railcraft.common.blocks.machine.manipulator.TileRFUnloader": {
                return Xformer.tryReenableRFManipulatorGUI(basicClass);
            }
            case "mods.railcraft.common.carts.EntityCartHopper": {
                return this.tryFixHopperCartDupe(basicClass);
            }
            case "mods.railcraft.common.carts.MinecartHooks": {
                return this.tryFixCartInvDuplication(basicClass);
            }
            case "mods.railcraft.common.carts.RailcraftCarts": {
                return this.tryFixCargoCartDismantleRecipe(basicClass);
            }
            case "mods.railcraft.common.gui.containers.RailcraftContainer": {
                return this.tryPatchRailcraftContainer(basicClass);
            }
            case "mods.railcraft.client.core.ClientProxy": {
                return this.tryFixFluidTextureWithThirdPartyMods(basicClass);
            }
            case "mods.railcraft.common.gui.containers.ContainerWorldspike": {
                return this.tryExpandStackSizeLimitInWorldSpikeGUI(basicClass);
            }
            case "mods.railcraft.client.gui.GuiAnvil": {
                return Xformer.tryFixAnvilScreen(basicClass);
            }
            case "mods.railcraft.client.gui.GuiTrackDelayedLocking": 
            case "mods.railcraft.client.gui.GuiTrackEmbarking": 
            case "mods.railcraft.client.gui.GuiTrackLauncher": 
            case "mods.railcraft.client.gui.GuiTrackPriming": {
                return this.tryUseI18nForTrackGui(basicClass);
            }
            case "mods.railcraft.client.gui.GuiTrackActivator": {
                return this.tryMakingActivatorTrackGUIBetter(basicClass);
            }
            case "mods.railcraft.client.gui.GuiTrackRouting": {
                return this.tryFixGuiRouting(basicClass);
            }
            case "mods.railcraft.client.gui.GuiManipulatorCartRF": {
                return this.tryDisableInvTitle(basicClass);
            }
            case "mods.railcraft.common.modules.ModuleMagic$1": {
                return this.tryReplaceFirestoneTicker(basicClass);
            }
        }
        return basicClass;
    }

    private byte[] tryExpandStackSizeLimitInWorldSpikeGUI(byte[] basicClass) {
        return Xformer.patch(basicClass, "<init>", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 182 && "setStackLimit".equals(name)) {
                    opcode = 184;
                    owner = "info/tritusk/modpack/railcraft/patcher/hooks/WorldSpikeHook";
                    name = "setInvStackLimit0";
                    desc = "(Lmods/railcraft/common/gui/slots/SlotIngredientMap;I)Lmods/railcraft/common/gui/slots/SlotIngredientMap;";
                    itf = false;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        });
    }

    private byte[] tryFixCargoCartDismantleRecipe(byte[] basicClass) {
        return Xformer.patch(basicClass, "<clinit>", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){
            private final String TRAPPED_CHEST;
            private boolean foundTrappedChest;
            {
                this.TRAPPED_CHEST = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName("net/minecraft/init/Blocks", "field_150447_bR", "Lnet/minecraft/block/Block;");
                this.foundTrappedChest = false;
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (this.TRAPPED_CHEST.equals(name)) {
                    this.foundTrappedChest = true;
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if ("from".equals(name) && this.foundTrappedChest) {
                    opcode = 184;
                    owner = "info/tritusk/modpack/railcraft/patcher/Recipes";
                    name = "cargoCartDismantleRemainder";
                    desc = "(Lnet/minecraft/block/Block;)Ljava/util/function/Supplier;";
                    this.foundTrappedChest = false;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        });
    }

    private byte[] tryFixFluidTextureWithThirdPartyMods(byte[] basicClass) {
        return Xformer.patch(basicClass, "initializeClient", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){
            private int registerRefCount;
            {
                this.registerRefCount = 0;
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if ("net/minecraftforge/fml/common/eventhandler/EventBus".equals(owner) && "register".equals(name) && ++this.registerRefCount == 3) {
                    opcode = 184;
                    owner = "info/tritusk/modpack/railcraft/patcher/hooks/FluidModelRendererHook";
                    name = "intercept";
                    desc = "(Lnet/minecraftforge/fml/common/eventhandler/EventBus;Ljava/lang/Object;)V";
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        });
    }

    private byte[] tryFixHopperCartDupe(byte[] basicClass) {
        return Xformer.patch(basicClass, "transferAndNeedsCooldown", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){

            public void visitInsn(int opcode) {
                if (opcode == 87) {
                    super.visitVarInsn(25, 1);
                    super.visitMethodInsn(184, "info/tritusk/modpack/railcraft/patcher/hooks/HopperCartHooks", "handleItemRemainder", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/item/EntityItem;)V", false);
                    return;
                }
                super.visitInsn(opcode);
            }
        });
    }

    private byte[] tryReplaceFirestoneTicker(byte[] basicClass) {
        return Xformer.patch(basicClass, "preInit", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if ("net/minecraftforge/fml/common/eventhandler/EventBus".equals(owner) && "register".equals(name)) {
                    opcode = 184;
                    owner = "info/tritusk/modpack/railcraft/patcher/AlternativeFirestoneTicker";
                    name = "intercept";
                    desc = "(Lnet/minecraftforge/fml/common/eventhandler/EventBus;Ljava/lang/Object;)V";
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        });
    }

    private byte[] tryFixCartInvDuplication(byte[] basicClass) {
        return Xformer.patch(basicClass, "onMinecartSpawn", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){
            final String entitySetDead;
            final String entitySetDropLoot;
            {
                this.entitySetDead = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft/entity/Entity", "func_70106_y", "()V");
                this.entitySetDropLoot = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft.entity/Entity", "func_184174_b", "(Z)V");
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 182 && this.entitySetDead.equals(name)) {
                    super.visitInsn(89);
                    super.visitInsn(3);
                    super.visitMethodInsn(182, "net/minecraft/entity/Entity", this.entitySetDropLoot, "(Z)V", false);
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        });
    }

    private static byte[] tryReenableRFManipulatorGUI(byte[] basicClass) {
        return Xformer.patch(basicClass, "openGui", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){
            final String teWorldHolder = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName("net/minecraft/tileentity/TileEntity", "field_145850_b", "Lnet/minecraft/world/world;");
            private boolean openGuiCall = false;

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if ("mods/railcraft/common/gui/GuiHandler".equals(owner) && "openGui".equals(name)) {
                    this.openGuiCall = true;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }

            public void visitInsn(int opcode) {
                if (opcode == 172 && !this.openGuiCall) {
                    super.visitFieldInsn(178, "mods/railcraft/common/gui/EnumGui", "MANIPULATOR_RF", "Lmods/railcraft/common/gui/EnumGui;");
                    super.visitVarInsn(25, 1);
                    super.visitVarInsn(25, 0);
                    super.visitFieldInsn(180, "mods/railcraft/common/blocks/machine/manipulator/TileRFManipulator", this.teWorldHolder, "Lnet/minecraft/world/World;");
                    super.visitVarInsn(25, 0);
                    super.visitMethodInsn(182, "mods/railcraft/common/blocks/machine/manipulator/TileRFManipulator", "getX", "()I", false);
                    super.visitVarInsn(25, 0);
                    super.visitMethodInsn(182, "mods/railcraft/common/blocks/machine/manipulator/TileRFManipulator", "getY", "()I", false);
                    super.visitVarInsn(25, 0);
                    super.visitMethodInsn(182, "mods/railcraft/common/blocks/machine/manipulator/TileRFManipulator", "getZ", "()I", false);
                    super.visitMethodInsn(184, "mods/railcraft/common/gui/GuiHandler", "openGui", "(Lmods/railcraft/common/gui/EnumGui;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;III)V", false);
                }
                super.visitInsn(opcode);
            }
        });
    }

    private static byte[] tryFixIC2EmitterLogic(byte[] basicClass) {
        ClassWriter writer = new ClassWriter(0);
        new ClassReader(basicClass).accept((ClassVisitor)new IC2EmitterLogicPatcher(327680, (ClassVisitor)writer), 0);
        return writer.toByteArray();
    }

    private static byte[] tryFixStructurePatternCheck(byte[] basicClass) {
        return Xformer.patch(basicClass, "getPatternMarker", "(Lnet/minecraft/util/math/BlockPos;)C", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){
            private boolean foundFix = false;

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 182 && "getPatternMarker".equals(name) && !this.foundFix) {
                    opcode = 184;
                    owner = "info/tritusk/modpack/railcraft/patcher/StructurePatternHook";
                    name = "getPatternMarker0";
                    desc = "(Lmods/railcraft/common/blocks/structures/StructurePattern;III)C";
                    itf = false;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }

            public void visitIntInsn(int opcode, int operand) {
                if (opcode == 16 && operand == 79) {
                    this.foundFix = true;
                }
                super.visitIntInsn(opcode, operand);
            }
        });
    }

    private static byte[] tryFixAnvilScreen(byte[] basicClass) {
        String targetMethodName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft/client/gui/inventory/GuiContainer", "func_73863_a", "(IIF)V");
        return Xformer.patch(basicClass, targetMethodName, (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){
            final String tooltipMethod = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft/client/gui/inventory/GuiContainer", "func_191948_b", "(II)V");
            private boolean foundFix = false;

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (name.equals(this.tooltipMethod)) {
                    this.foundFix = true;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }

            public void visitIntInsn(int opcode, int operand) {
                if (opcode == 17 && operand == 2896 && !this.foundFix) {
                    super.visitVarInsn(25, 0);
                    super.visitIntInsn(21, 1);
                    super.visitIntInsn(21, 2);
                    super.visitMethodInsn(182, "net/minecraft/client/gui/inventory/GuiContainer", this.tooltipMethod, "(II)V", false);
                }
                super.visitIntInsn(opcode, operand);
            }
        });
    }

    private byte[] tryMakingActivatorTrackGUIBetter(byte[] basicClass) {
        String targetMethodName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft/client/gui/inventory/GuiContainer", "func_146979_b", "(II)V");
        return Xformer.patch(basicClass, targetMethodName, (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 184 && "drawStringCenteredAtPos".equals(name)) {
                    super.visitInsn(87);
                    super.visitInsn(87);
                    super.visitIntInsn(16, 44);
                    super.visitIntInsn(16, 28);
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        });
    }

    private byte[] tryDisableInvTitle(byte[] basicClass) {
        return Xformer.patch(basicClass, "<init>", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){

            public void visitInsn(int opcode) {
                if (opcode == 177) {
                    super.visitVarInsn(25, 0);
                    super.visitInsn(3);
                    super.visitFieldInsn(181, "mods/railcraft/client/gui/GuiManipulatorCartRF", "drawInvTitle", "Z");
                }
                super.visitInsn(opcode);
            }
        });
    }

    private byte[] tryPatchRailcraftContainer(byte[] basicClass) {
        return Xformer.patch(basicClass, "addPlayerSlots", "(Lnet/minecraft/entity/player/InventoryPlayer;I)V", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){

            public void visitCode() {
                Label nullCheckPass = new Label();
                super.visitVarInsn(25, 1);
                super.visitJumpInsn(199, nullCheckPass);
                super.visitInsn(177);
                super.visitFrame(1, 0, new Object[0], 1, new Object[]{"Lnet/minecraft/entity/player/InventoryPlayer;"});
                super.visitLabel(nullCheckPass);
                super.visitCode();
            }
        });
    }

    private byte[] tryFixGuiRouting(byte[] basicClass) {
        return Xformer.patch(basicClass, "<init>", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 183 && "mods/railcraft/client/gui/GuiTitled".equals(owner)) {
                    super.visitVarInsn(25, 1);
                    super.visitFieldInsn(180, "mods/railcraft/common/gui/containers/ContainerTrackRouting", "kit", "Lmods/railcraft/common/blocks/tracks/outfitted/kits/TrackKitRailcraft;");
                    super.visitTypeInsn(192, "mods/railcraft/common/blocks/tracks/outfitted/kits/TrackKitRouting");
                    super.visitMethodInsn(182, "mods/railcraft/common/blocks/tracks/outfitted/kits/TrackKitRouting", "getTrackKit", "()Lmods/railcraft/api/tracks/TrackKit;", false);
                    super.visitMethodInsn(184, "mods/railcraft/common/plugins/forge/LocalizationPlugin", "localize", "(Lmods/railcraft/api/tracks/TrackKit;)Lnet/minecraft/util/text/ITextComponent;", false);
                    desc = "(Lnet/minecraft/world/IWorldNameable;Lmods/railcraft/common/gui/containers/RailcraftContainer;Ljava/lang/String;Lnet/minecraft/util/text/ITextComponent;)V";
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        });
    }

    private byte[] tryUseI18nForTrackGui(byte[] basicClass) {
        return Xformer.patch(basicClass, "<init>", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){
            final String targetMethodName;
            {
                this.targetMethodName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft/world/IWorldNameable", "func_70005_c_", "()Ljava/lang/String;");
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 182 && this.targetMethodName.equals(name)) {
                    opcode = 184;
                    owner = "info/tritusk/modpack/railcraft/patcher/I18nHook";
                    name = "translateOutfittedTrackName";
                    desc = "(Lmods/railcraft/common/blocks/tracks/outfitted/TileTrackOutfitted;)Ljava/lang/String;";
                    itf = false;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        });
    }

    private byte[] tryExpandStackSizeLimitInWorldSpike(byte[] basicClass) {
        return Xformer.patch(basicClass, "<init>", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 182 && "setInventoryStackLimit".equals(name)) {
                    opcode = 184;
                    owner = "info/tritusk/modpack/railcraft/patcher/hooks/WorldSpikeHook";
                    name = "setInvStackLimit0";
                    desc = "(Lmods/railcraft/common/util/inventory/InventoryAdvanced;I)Lmods/railcraft/common/util/inventory/InventoryAdvanced;";
                    itf = false;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        });
    }

    private static byte[] tryPatchingTileRailcraft(byte[] basicClass) {
        return Xformer.patch(basicClass, "markBlockForUpdate", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){

            public void visitCode() {
                super.visitInsn(177);
                super.visitFrame(3, 0, new Object[0], 0, new Object[0]);
            }
        });
    }

    private static byte[] tryFixRollingRecipeDisplayInJEI(byte[] basicClass) {
        return Xformer.patch(basicClass, "setRecipe", (api, mv) -> new MethodVisitor((int)api, (MethodVisitor)mv){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 185 && "setInputs".equals(name)) {
                    super.visitVarInsn(25, 2);
                    opcode = 184;
                    owner = "info/tritusk/modpack/railcraft/patcher/JEIHook";
                    name = "setInputs0";
                    desc = "(Lmezz/jei/api/gui/ICraftingGridHelper;Lmezz/jei/api/gui/IGuiItemStackGroup;Ljava/util/List;Lmezz/jei/api/recipe/IRecipeWrapper;)V";
                    itf = false;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        });
    }

    private static byte[] patch(byte[] basicClass, final String methodToPatch, final BiFunction<Integer, MethodVisitor, MethodVisitor> patcher) {
        ClassWriter writer = new ClassWriter(1);
        new ClassReader(basicClass).accept(new ClassVisitor(327680, (ClassVisitor)writer){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (name.equals(methodToPatch)) {
                    mv = (MethodVisitor)patcher.apply(this.api, mv);
                }
                return mv;
            }
        }, 0);
        return writer.toByteArray();
    }

    private static byte[] patch(byte[] basicClass, final String methodToPatch, final String targetMethodDesc, final BiFunction<Integer, MethodVisitor, MethodVisitor> patcher) {
        ClassWriter writer = new ClassWriter(1);
        new ClassReader(basicClass).accept(new ClassVisitor(327680, (ClassVisitor)writer){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (name.equals(methodToPatch) && desc.equals(targetMethodDesc)) {
                    mv = (MethodVisitor)patcher.apply(this.api, mv);
                }
                return mv;
            }
        }, 0);
        return writer.toByteArray();
    }
}

