/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.railcraft.patcher.hooks;

import info.tritusk.modpack.railcraft.patcher.ModContainer;
import mods.railcraft.client.render.models.resource.FluidModelRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FluidModelRendererHook {
    private static final Logger LOGGER = LogManager.getLogger(FluidModelRendererHook.class);

    public static void intercept(EventBus bus, Object originalListener) {
        if (ModContainer.disableFluidTextureFix) {
            if (originalListener == FluidModelRenderer.INSTANCE) {
                LOGGER.debug("Disable the presumed fluid texture fix.");
                return;
            }
            LOGGER.error("Wrong listener captured! Expected FluidModelRenderer.INSTANCE, got {}. The toggle will likely not working as expected. Please report this error.", originalListener);
        }
        bus.register(ModContainer.useAlternativeFluidTextureFix ? AltLoadTextureHook.class : originalListener);
    }

    public static final class AltLoadTextureHook {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void on(TextureStitchEvent.Pre event) {
            TextureMap textureMap = event.getMap();
            for (Fluid f : FluidRegistry.getRegisteredFluids().values()) {
                ResourceLocation stillTex;
                ResourceLocation flowingTex = f.getFlowing();
                if (flowingTex != null && textureMap.getTextureExtry(flowingTex.toString()) == null) {
                    textureMap.func_174942_a(flowingTex);
                }
                if ((stillTex = f.getStill()) == null || textureMap.getTextureExtry(stillTex.toString()) != null) continue;
                textureMap.func_174942_a(stillTex);
            }
        }
    }
}

