/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.network.message.MoCMessageExplode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntityOgre
extends MoCEntityMob {
    public int attackCounterLeft;
    public int attackCounterRight;
    public int smashCounter;
    public int armToAnimate;
    public int attackCounter;
    private int movingHead;

    public MoCEntityOgre(World world) {
        super(world);
        this.func_70105_a(1.8f, 3.05f);
        this.field_70728_aV = 12;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIOgreAttack(this, 1.25, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AIOgreTarget<EntityPlayer>(this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(3, new AIOgreTarget<EntityIronGolem>(this, EntityIronGolem.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(2) + 1);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (super.func_70097_a(damagesource, i)) {
            Entity entity = damagesource.func_76346_g();
            if (entity != null && this.func_184215_y(entity)) {
                return true;
            }
            if (entity != this && this.field_70170_p.func_175659_aa().func_151525_a() > 0 && entity instanceof EntityLivingBase) {
                this.func_70624_b((EntityLivingBase)entity);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return this.func_70013_c() < 0.5f && super.shouldAttackPlayers();
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_OGRE_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCSoundEvents.ENTITY_OGRE_HURT;
    }

    protected SoundEvent func_184639_G() {
        return MoCSoundEvents.ENTITY_OGRE_AMBIENT;
    }

    public boolean isFireStarter() {
        return false;
    }

    public float getDestroyForce() {
        return MoCreatures.proxy.ogreStrength;
    }

    public int getAttackRange() {
        return MoCreatures.proxy.ogreAttackRange;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.smashCounter > 0 && ++this.smashCounter > 10) {
                this.smashCounter = 0;
                this.performDestroyBlastAttack();
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageExplode(this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            }
            if (this.func_70638_az() != null && this.field_70146_Z.nextInt(40) == 0 && this.smashCounter == 0 && this.attackCounter == 0) {
                this.startDestroyBlast();
            }
        }
        if (this.attackCounter > 0) {
            this.attackCounter = this.armToAnimate == 3 ? ++this.attackCounter : (this.attackCounter += 2);
            if (this.attackCounter > 10) {
                this.attackCounter = 0;
                this.armToAnimate = 0;
            }
        }
        super.func_70636_d();
    }

    protected void startDestroyBlast() {
        this.smashCounter = 1;
        MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
    }

    public void performDestroyBlastAttack() {
        if (this.field_70725_aQ > 0) {
            return;
        }
        MoCTools.destroyBlast((Entity)this, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, this.getDestroyForce(), this.isFireStarter());
    }

    protected void startArmSwingAttack() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.smashCounter != 0) {
                return;
            }
            boolean leftArmW = (this.getType() == 2 || this.getType() == 4 || this.getType() == 6) && this.field_70146_Z.nextInt(2) == 0;
            this.attackCounter = 1;
            if (leftArmW) {
                this.armToAnimate = 1;
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            } else {
                this.armToAnimate = 2;
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 2), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            }
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType != 0) {
            this.attackCounter = 1;
            this.armToAnimate = animationType;
        }
    }

    public int getMovingHead() {
        if (this.getType() == 1) {
            return 1;
        }
        if (this.field_70146_Z.nextInt(60) == 0) {
            this.movingHead = this.field_70146_Z.nextInt(2) + 2;
        }
        return this.movingHead;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.startArmSwingAttack();
        return super.func_70652_k(entityIn);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.91f;
    }

    static class AIOgreTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIOgreTarget(MoCEntityOgre ogre, Class<T> classTarget, boolean checkSight) {
            super((EntityCreature)ogre, classTarget, checkSight);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f < 0.5f && super.func_75250_a();
        }
    }

    static class AIOgreAttack
    extends EntityAIAttackMelee {
        public AIOgreAttack(MoCEntityOgre ogre, double speed, boolean useLongMemory) {
            super((EntityCreature)ogre, speed, useLongMemory);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }
    }
}

