/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIHunt;
import drzhark.mocreatures.entity.ai.EntityAIPanicMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntitySnake
extends MoCEntityTameableAnimal {
    public float bodyswing;
    private float fTongue;
    private float fMouth;
    private boolean isBiting;
    private float fRattle;
    private boolean isPissed;
    private int hissCounter;
    private int movInt;
    private boolean isNearPlayer;

    public MoCEntitySnake(World world) {
        super(world);
        this.func_70105_a(1.4f, 0.5f);
        this.bodyswing = 2.0f;
        this.movInt = this.field_70146_Z.nextInt(10);
        this.setAge(50 + this.field_70146_Z.nextInt(50));
        this.field_70728_aV = 3;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanicMoC((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeFromPlayer((EntityCreature)this, 0.8, 4.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderMoC2((EntityCreature)this, 0.8, 30));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new EntityAIHunt<EntityPlayer>((EntityCreature)this, EntityPlayer.class, false));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        if (this.field_70170_p.field_73011_w.getDimension() == MoCreatures.proxy.wyvernDimension) {
            this.func_110163_bv();
        }
        return super.func_180482_a(difficulty, par1EntityLivingData);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(8) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("snake_wolf.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("snake_orange.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("snake_green_bright.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("snake_coral.png");
            }
            case 6: {
                return MoCreatures.proxy.getModelTexture("snake_cobra.png");
            }
            case 7: {
                return MoCreatures.proxy.getModelTexture("snake_rattle.png");
            }
            case 8: {
                return MoCreatures.proxy.getModelTexture("snake_python.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("snake_green_dark.png");
    }

    protected int func_70693_a(EntityPlayer player) {
        return this.field_70728_aV;
    }

    public void func_180430_e(float f, float f1) {
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    protected void func_70664_aZ() {
        if (this.func_70090_H()) {
            super.func_70664_aZ();
        }
    }

    public boolean pickedUp() {
        return this.func_184187_bx() != null;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        if (!this.getIsTamed()) {
            return false;
        }
        if (this.func_184187_bx() == null) {
            if (this.startRidingPlayer(player)) {
                this.field_70177_z = player.field_70177_z;
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean isNotScared() {
        return this.getType() > 2 && this.getAge() > 50;
    }

    public boolean isClimbing() {
        return this.func_70617_f_() && this.field_70181_x > (double)0.01f;
    }

    public boolean isResting() {
        return !this.getNearPlayer() && this.field_70122_E && this.field_70159_w < 0.01 && this.field_70159_w > -0.01 && this.field_70179_y < 0.01 && this.field_70179_y > -0.01;
    }

    public boolean getNearPlayer() {
        return this.isNearPlayer || this.isBiting();
    }

    public void setNearPlayer(boolean flag) {
        this.isNearPlayer = flag;
    }

    public int getMovInt() {
        return this.movInt;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    public double func_70033_W() {
        if (this.func_184187_bx() instanceof EntityPlayer) {
            return 0.1f;
        }
        return super.func_70033_W();
    }

    public float getSizeF() {
        float factor = 1.0f;
        if (this.getType() == 1 || this.getType() == 2) {
            factor = 0.8f;
        } else if (this.getType() == 5) {
            factor = 0.6f;
        }
        if (this.getType() == 6) {
            factor = 1.1f;
        }
        if (this.getType() == 7) {
            factor = 0.9f;
        }
        if (this.getType() == 8) {
            factor = 1.5f;
        }
        return (float)this.getAge() * 0.01f * factor;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            int chance;
            if (this.getfTongue() != 0.0f) {
                this.setfTongue(this.getfTongue() + 0.2f);
                if (this.getfTongue() > 8.0f) {
                    this.setfTongue(0.0f);
                }
            }
            if (this.getfMouth() != 0.0f && this.hissCounter == 0) {
                this.setfMouth(this.getfMouth() + 0.1f);
                if (this.getfMouth() > 0.5f) {
                    this.setfMouth(0.0f);
                }
            }
            if (this.getType() == 7 && this.getfRattle() != 0.0f) {
                this.setfRattle(this.getfRattle() + 0.2f);
                if (this.getfRattle() == 1.0f) {
                    MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SNAKE_RATTLE);
                }
                if (this.getfRattle() > 8.0f) {
                    this.setfRattle(0.0f);
                }
            }
            if (this.field_70146_Z.nextInt(50) == 0 && this.getfTongue() == 0.0f) {
                this.setfTongue(0.1f);
            }
            if (this.field_70146_Z.nextInt(100) == 0 && this.getfMouth() == 0.0f) {
                this.setfMouth(0.1f);
            }
            if (this.getType() == 7 && this.field_70146_Z.nextInt(chance = this.getNearPlayer() ? 30 : 100) == 0) {
                this.setfRattle(0.1f);
            }
            if (!this.isResting() && !this.pickedUp() && this.field_70146_Z.nextInt(50) == 0) {
                this.movInt = this.field_70146_Z.nextInt(10);
            }
            if (this.isBiting()) {
                this.bodyswing -= 0.5f;
                this.setfMouth(0.3f);
                if (this.bodyswing < 0.0f) {
                    MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SNAKE_ATTACK);
                    this.bodyswing = 2.5f;
                    this.setfMouth(0.0f);
                    this.setBiting(false);
                }
            }
        }
        if (this.pickedUp()) {
            this.movInt = 0;
        }
        if (this.isResting()) {
            this.field_70761_aq = this.field_70177_z = this.field_70126_B;
            this.field_70760_ar = this.field_70177_z;
        }
        if (!this.field_70122_E && this.func_184187_bx() != null) {
            this.field_70177_z = this.func_184187_bx().field_70177_z;
        }
        if (this.field_70170_p.func_175659_aa().func_151525_a() > 0 && this.getNearPlayer() && !this.getIsTamed() && this.isNotScared()) {
            ++this.hissCounter;
            if (this.hissCounter % 25 == 0) {
                this.setfMouth(0.3f);
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SNAKE_ANGRY);
            }
            if (this.hissCounter % 35 == 0) {
                this.setfMouth(0.0f);
            }
            if (this.hissCounter > 100 && this.field_70146_Z.nextInt(50) == 0) {
                this.setPissed(true);
                this.hissCounter = 0;
            }
        }
        if (this.hissCounter > 500) {
            this.hissCounter = 0;
        }
    }

    public float getfTongue() {
        return this.fTongue;
    }

    public void setfTongue(float fTongue) {
        this.fTongue = fTongue;
    }

    public float getfMouth() {
        return this.fMouth;
    }

    public void setfMouth(float fMouth) {
        this.fMouth = fMouth;
    }

    public float getfRattle() {
        return this.fRattle;
    }

    public void setfRattle(float fRattle) {
        this.fRattle = fRattle;
    }

    @Override
    public void func_70636_d() {
        EntityPlayer entityplayer1;
        super.func_70636_d();
        if (this.func_70638_az() != null && this.field_70146_Z.nextInt(300) == 0) {
            this.func_70624_b(null);
        }
        if ((entityplayer1 = this.field_70170_p.func_72890_a((Entity)this, 12.0)) != null) {
            double distP = MoCTools.getSqDistanceTo((Entity)entityplayer1, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.isNotScared()) {
                this.setNearPlayer(distP < 5.0);
            } else {
                this.setNearPlayer(false);
            }
        } else {
            this.setNearPlayer(false);
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if ((this.getType() < 3 || this.getIsTamed()) && entityIn instanceof EntityPlayer) {
            return false;
        }
        if (entityIn instanceof EntityPlayer && !this.shouldAttackPlayers()) {
            return false;
        }
        this.setBiting(true);
        return super.func_70652_k(entityIn);
    }

    @Override
    public void performAnimation(int i) {
        this.setBiting(true);
    }

    public boolean isBiting() {
        return this.isBiting;
    }

    public void setBiting(boolean flag) {
        if (flag && !this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.isBiting = flag;
    }

    public boolean isPissed() {
        return this.isPissed;
    }

    public void setPissed(boolean isPissed) {
        this.isPissed = isPissed;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.getType() < 3) {
            return super.func_70097_a(damagesource, i);
        }
        if (super.func_70097_a(damagesource, i)) {
            Entity entity = damagesource.func_76346_g();
            if (entity != null && this.func_184215_y(entity)) {
                return true;
            }
            if (entity != this && entity instanceof EntityLivingBase && super.shouldAttackPlayers()) {
                this.setPissed(true);
                this.func_70624_b((EntityLivingBase)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public void dropLegacyEgg() {
        if (this.getAge() > 60) {
            int j = this.field_70146_Z.nextInt(3);
            this.func_70099_a(new ItemStack((Item)MoCItems.mocegg, j, this.getType() + 20), 0.0f);
        }
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return !(entity instanceof MoCEntitySnake) && (double)entity.field_70131_O < 0.5 && (double)entity.field_70130_N < 0.5;
    }

    protected void func_180429_a(BlockPos pos, Block par4) {
        if (this.func_70055_a(Material.field_151586_h)) {
            MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SNAKE_SWIM);
        }
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_SNAKE_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCSoundEvents.ENTITY_SNAKE_HURT;
    }

    protected SoundEvent func_184639_G() {
        return MoCSoundEvents.ENTITY_SNAKE_AMBIENT;
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos((double)MathHelper.func_76128_c((double)this.field_70165_t), (double)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), this.field_70161_v);
        try {
            Biome currentbiome = MoCTools.biomeKind(this.field_70170_p, pos);
            int l = this.field_70146_Z.nextInt(10);
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                return false;
            }
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
                if (l < 5) {
                    this.setType(7);
                } else {
                    this.setType(2);
                }
            }
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
                if (l < 3) {
                    this.setType(1);
                } else if (l < 5) {
                    this.setType(5);
                } else {
                    this.setType(2);
                }
            }
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
                if (l < 4) {
                    this.setType(8);
                } else if (l < 8) {
                    this.setType(2);
                } else {
                    this.setType(7);
                }
            }
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
                if (l < 5) {
                    this.setType(1);
                } else {
                    this.setType(2);
                }
            }
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                if (l < 5) {
                    this.setType(8);
                } else if (l < 7) {
                    this.setType(6);
                } else {
                    this.setType(1);
                }
            }
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                if (l < 3) {
                    this.setType(4);
                } else if (l < 5) {
                    this.setType(3);
                } else if (l < 7) {
                    this.setType(6);
                } else if (l < 9) {
                    this.setType(8);
                } else {
                    this.setType(1);
                }
            }
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)) {
                this.setType(1);
            }
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)MoCEntities.WYVERN_LAIR)) {
                if (l < 3) {
                    this.setType(4);
                } else if (l < 5) {
                    this.setType(3);
                } else if (l < 7) {
                    this.setType(2);
                } else {
                    this.setType(1);
                }
            }
            if (this.getType() == 7 && (!BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA))) {
                this.setType(2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public int nameYOffset() {
        return -30;
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == MoCItems.ratRaw;
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean isReadyToHunt() {
        return this.getIsAdult() && !this.isMovementCeased();
    }

    protected void func_174815_a(EntityLivingBase entityLivingBaseIn, Entity entityIn) {
        if (this.isVenomous()) {
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 150, 2));
        }
        super.func_174815_a(entityLivingBaseIn, entityIn);
    }

    private boolean isVenomous() {
        return this.getType() == 3 || this.getType() == 4 || this.getType() == 5 || this.getType() == 6 || this.getType() == 7 || this.getType() == 9;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return this.isPissed() && super.shouldAttackPlayers();
    }

    public int func_70627_aG() {
        return 400;
    }

    @Override
    public boolean isAmphibian() {
        return true;
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    @Override
    protected double maxDivingDepth() {
        return (double)this.getAge() / 100.0;
    }
}

