/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import com.google.common.collect.Sets;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityFilchLizard
extends MoCEntityAnimal {
    protected ItemStack[] stealItems;

    public MoCEntityFilchLizard(World worldIn) {
        super(worldIn);
        this.field_82174_bp[0] = 0.0f;
        this.field_82174_bp[1] = 0.0f;
        this.func_70105_a(0.6f, 0.5f);
        this.field_70728_aV = 3;
    }

    protected void func_184651_r() {
        this.stealItems = this.getCustomLootItems((Entity)this, this.getStealLootTable(), new ItemStack(Items.field_151042_j));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIGrabItemFromFloor((EntityCreature)this, 1.2, Sets.newHashSet((Object[])this.stealItems), true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIStealFromPlayer((EntityCreature)this, 0.8, Sets.newHashSet((Object[])this.stealItems), true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAvoidWhenNasty((EntityCreature)this, EntityPlayer.class, 16.0f, 1.0, 1.33));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("lizard_filch_sand.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("lizard_filch_sand_red.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("lizard_filch_sand_silver.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("lizard_filch.png");
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos((double)MathHelper.func_76128_c((double)this.field_70165_t), (double)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), this.field_70161_v);
        Biome biome = MoCTools.biomeKind(this.field_70170_p, pos);
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            this.setType(2);
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
            this.setType(3);
        } else if (this.field_71093_bK == MoCreatures.proxy.wyvernDimension) {
            this.setType(4);
        } else {
            this.setType(1);
        }
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_184614_ca().func_190926_b()) {
            this.func_70105_a(0.6f, 0.75f);
        } else {
            this.func_70105_a(0.6f, 0.3f);
        }
    }

    protected int func_70693_a(EntityPlayer player) {
        return this.field_70728_aV;
    }

    @Nullable
    protected ResourceLocation getSpawnLootTable() {
        return MoCLootTables.FILCH_LIZARD_SPAWN;
    }

    @Nullable
    protected ResourceLocation getStealLootTable() {
        return MoCLootTables.FILCH_LIZARD_STEAL;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70146_Z.nextInt(100 / MoCreatures.proxy.filchLizardSpawnItemChance) == 0) {
            while (this.func_184614_ca().func_190926_b() && !this.func_130014_f_().field_72995_K) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.getCustomLootItem((Entity)this, this.getSpawnLootTable(), new ItemStack(Items.field_151042_j)));
            }
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public void dropItemStack(ItemStack itemIn, float offsetY) {
        this.func_70099_a(itemIn, offsetY);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        ItemStack stack;
        if (par1DamageSource.func_76346_g() != null) {
            this.func_130011_c(par1DamageSource.func_76346_g());
        }
        if (!(stack = this.func_184614_ca()).func_190926_b() && !this.func_130014_f_().field_72995_K) {
            ItemStack newStack = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
            this.dropItemStack(newStack, 1.0f);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Nullable
    public ItemStack getCustomLootItem(Entity entityIn, ResourceLocation resourceLootTable, ItemStack defaultItem) {
        LootContext.Builder lootContextBuilder;
        LootTable loottable;
        Iterator iterator;
        if (resourceLootTable != null && (iterator = (loottable = entityIn.field_70170_p.func_184146_ak().func_186521_a(resourceLootTable)).func_186462_a(entityIn.func_130014_f_().field_73012_v, (lootContextBuilder = new LootContext.Builder((WorldServer)entityIn.field_70170_p).func_186472_a(entityIn)).func_186471_a()).iterator()).hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            return itemstack;
        }
        return defaultItem;
    }

    @Nullable
    public ItemStack[] getCustomLootItems(Entity entityIn, ResourceLocation resourceLootTable, ItemStack defaultItem) {
        ItemStack[] arrayOfItems = null;
        if (resourceLootTable != null) {
            LootTable loottable = entityIn.field_70170_p.func_184146_ak().func_186521_a(resourceLootTable);
            LootContext.Builder lootContextBuilder = new LootContext.Builder((WorldServer)entityIn.field_70170_p).func_186472_a(entityIn);
            List listOfItems = loottable.func_186462_a(entityIn.func_130014_f_().field_73012_v, lootContextBuilder.func_186471_a());
            arrayOfItems = new ItemStack[listOfItems.size()];
            int i = 0;
            Iterator iterator = listOfItems.iterator();
            while (iterator.hasNext()) {
                ItemStack itemstack;
                arrayOfItems[i] = itemstack = (ItemStack)iterator.next();
                ++i;
            }
        }
        if (arrayOfItems == null) {
            arrayOfItems = new ItemStack[]{defaultItem};
        }
        return arrayOfItems;
    }

    protected SoundEvent func_184615_bR() {
        return MoCreatures.proxy.legacyFilchLizardSounds ? SoundEvents.field_187661_by : MoCSoundEvents.ENTITY_FILCH_LIZARD_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCreatures.proxy.legacyFilchLizardSounds ? SoundEvents.field_187543_bD : MoCSoundEvents.ENTITY_FILCH_LIZARD_HISS;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return MoCLootTables.FILCH_LIZARD;
    }

    public class EntityAIStealFromPlayer
    extends EntityAIBase {
        private final EntityCreature temptedEntity;
        private final double speed;
        private final Set<ItemStack> temptItem;
        private final boolean canGetScared;
        private double targetX;
        private double targetY;
        private double targetZ;
        private double pitch;
        private double yaw;
        private EntityPlayer temptingPlayer;
        private boolean isRunning;
        private int stealDelay = 0;

        public EntityAIStealFromPlayer(EntityCreature temptedEntityIn, double speedIn, Set<ItemStack> temptItemIn, boolean canGetScared) {
            this.temptedEntity = temptedEntityIn;
            this.speed = speedIn;
            this.temptItem = temptItemIn;
            this.canGetScared = canGetScared;
            if (!(temptedEntityIn.func_70661_as() instanceof PathNavigateGround)) {
                throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
            }
        }

        public boolean func_75250_a() {
            if (this.temptedEntity.func_110144_aD() != null && this.canGetScared && this.stealDelay <= 0) {
                this.func_75251_c();
                return false;
            }
            if (!this.temptedEntity.func_184614_ca().func_190926_b()) {
                return false;
            }
            this.temptingPlayer = this.temptedEntity.func_130014_f_().func_72890_a((Entity)this.temptedEntity, 10.0);
            if (this.stealDelay > 0) {
                --this.stealDelay;
                if (this.stealDelay == 0) {
                    this.temptedEntity.func_130011_c(null);
                }
                return false;
            }
            if (this.temptingPlayer != null) {
                for (int i = 0; i < this.temptingPlayer.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack item = this.temptingPlayer.field_71071_by.func_70301_a(i);
                    if (item.func_190926_b() || !this.isTempting(item)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean isTempting(ItemStack stack) {
            if (!stack.func_190926_b()) {
                for (ItemStack item : this.temptItem) {
                    if (item == null || item.func_77973_b() != stack.func_77973_b() || item.func_77960_j() != stack.func_77960_j()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75249_e() {
            this.targetX = this.temptingPlayer.field_70165_t;
            this.targetY = this.temptingPlayer.field_70163_u;
            this.targetZ = this.temptingPlayer.field_70161_v;
            this.isRunning = true;
        }

        public void func_75251_c() {
            this.temptingPlayer = null;
            this.temptedEntity.func_70661_as().func_75499_g();
            this.isRunning = false;
            if (this.canGetScared) {
                this.stealDelay = 100;
            }
        }

        public void func_75246_d() {
            this.temptedEntity.func_70671_ap().func_75651_a((Entity)this.temptingPlayer, (float)(this.temptedEntity.func_184649_cE() + 20), (float)this.temptedEntity.func_70646_bf());
            if (this.temptingPlayer.field_71075_bZ.field_75098_d) {
                return;
            }
            if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 3.25) {
                this.temptedEntity.func_70661_as().func_75499_g();
                for (int i = 0; i < this.temptingPlayer.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack item = this.temptingPlayer.field_71071_by.func_70301_a(i);
                    if (item.func_190926_b()) continue;
                    for (ItemStack itemstack : this.temptItem) {
                        if (itemstack == null || itemstack.func_190926_b() || itemstack.func_77973_b() != item.func_77973_b() || itemstack.func_77960_j() != item.func_77960_j()) continue;
                        MoCTools.playCustomSound((Entity)this.temptedEntity, SoundEvents.field_187638_cR);
                        ItemStack loot = item.func_77946_l();
                        this.temptedEntity.func_184201_a(EntityEquipmentSlot.MAINHAND, loot);
                        item.func_190918_g(1);
                        return;
                    }
                }
            } else {
                this.temptedEntity.func_70661_as().func_75497_a((Entity)this.temptingPlayer, this.speed);
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    static class EntityAIGrabItemFromFloor
    extends EntityAIBase {
        private final EntityCreature temptedEntity;
        private final double speed;
        private final Set<ItemStack> temptItem;
        private final boolean canGetScared;
        private double targetX;
        private double targetY;
        private double targetZ;
        private double pitch;
        private double yaw;
        private EntityItem temptingItem;
        private boolean isRunning;
        private int stealDelay = 0;

        public EntityAIGrabItemFromFloor(EntityCreature temptedEntityIn, double speedIn, Set<ItemStack> temptItemIn, boolean canGetScared) {
            this.temptedEntity = temptedEntityIn;
            this.speed = speedIn;
            this.temptItem = temptItemIn;
            this.canGetScared = canGetScared;
            if (!(temptedEntityIn.func_70661_as() instanceof PathNavigateGround)) {
                throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
            }
        }

        public boolean func_75250_a() {
            if (this.temptedEntity.func_110144_aD() != null && this.canGetScared && this.stealDelay <= 0) {
                this.func_75251_c();
                return false;
            }
            if (!this.temptedEntity.func_184614_ca().func_190926_b()) {
                return false;
            }
            List list = this.temptedEntity.func_130014_f_().func_72839_b((Entity)this.temptedEntity, this.temptedEntity.func_174813_aQ().func_72314_b(6.0, 4.0, 6.0));
            if (this.stealDelay > 0) {
                --this.stealDelay;
                if (this.stealDelay == 0) {
                    this.temptedEntity.func_130011_c(null);
                }
                return false;
            }
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityItem item;
                    ItemStack stack;
                    if (!(entity instanceof EntityItem) || (stack = (item = (EntityItem)entity).func_92059_d()).func_190926_b() || !this.isTempting(stack)) continue;
                    this.temptingItem = item;
                    return true;
                }
            }
            return false;
        }

        protected boolean isTempting(ItemStack stack) {
            if (!stack.func_190926_b()) {
                for (ItemStack item : this.temptItem) {
                    if (item == null || item.func_77973_b() != stack.func_77973_b() || item.func_77960_j() != stack.func_77960_j()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75249_e() {
            this.targetX = this.temptingItem.field_70165_t;
            this.targetY = this.temptingItem.field_70163_u;
            this.targetZ = this.temptingItem.field_70161_v;
            this.isRunning = true;
        }

        public void func_75251_c() {
            this.temptingItem = null;
            this.temptedEntity.func_70661_as().func_75499_g();
            this.isRunning = false;
            if (this.canGetScared) {
                this.stealDelay = 50;
            }
        }

        public void func_75246_d() {
            this.temptedEntity.func_70671_ap().func_75651_a((Entity)this.temptingItem, (float)(this.temptedEntity.func_184649_cE() + 20), (float)this.temptedEntity.func_70646_bf());
            if (this.temptedEntity.func_70068_e((Entity)this.temptingItem) < 1.0) {
                this.temptedEntity.func_70661_as().func_75499_g();
                ItemStack loot = this.temptingItem.func_92059_d().func_77946_l();
                this.temptingItem.func_70106_y();
                this.temptedEntity.func_184201_a(EntityEquipmentSlot.MAINHAND, loot);
            } else {
                this.temptedEntity.func_70661_as().func_75497_a((Entity)this.temptingItem, this.speed);
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    static class AIAvoidWhenNasty
    extends EntityAIAvoidEntity<MoCEntityFilchLizard> {
        public AIAvoidWhenNasty(EntityCreature theEntityIn, Class classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
            super(theEntityIn, classToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn);
        }

        public boolean func_75250_a() {
            return !this.field_75380_a.func_184614_ca().func_190926_b() && super.func_75250_a();
        }
    }
}

