/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import com.mojang.authlib.GameProfile;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.inventory.MoCAnimalChest;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.item.MoCItemRecord;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.network.message.MoCMessageHeart;
import drzhark.mocreatures.network.message.MoCMessageVanish;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemSaddle;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntityHorse
extends MoCEntityTameableAnimal {
    private static final DataParameter<Boolean> RIDEABLE = EntityDataManager.func_187226_a(MoCEntityHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHESTED = EntityDataManager.func_187226_a(MoCEntityHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(MoCEntityHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BRED = EntityDataManager.func_187226_a(MoCEntityHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ARMOR_TYPE = EntityDataManager.func_187226_a(MoCEntityHorse.class, (DataSerializer)DataSerializers.field_187192_b);
    public int shuffleCounter;
    public int wingFlapCounter;
    public MoCAnimalChest localChest;
    public boolean eatenPumpkin;
    public ItemStack localStack;
    public int mouthCounter;
    public int standCounter;
    public int tailCounter;
    public int vanishCounter;
    public int sprintCounter;
    public int transformType;
    public int transformCounter;
    protected EntityAIWanderMoC2 wander;
    private int gestationTime;
    private int countEating;
    private int textCounter;
    private int fCounter;
    private float transFloat = 0.2f;
    private boolean hasReproduced;
    private int nightmareInt;

    public MoCEntityHorse(World world) {
        super(world);
        this.func_70105_a(1.3964844f, 1.6f);
        this.gestationTime = 0;
        this.eatenPumpkin = false;
        this.nightmareInt = 0;
        this.field_70178_ae = false;
        this.setAge(50);
        this.setIsChested(false);
        this.field_70138_W = 1.0f;
        if (!this.field_70170_p.field_72995_K) {
            this.setAdult(this.field_70146_Z.nextInt(5) != 0);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowAdult((EntityLiving)this, 1.0));
        this.wander = new EntityAIWanderMoC2((EntityCreature)this, 1.0, 80);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.wander);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RIDEABLE, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(SITTING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(CHESTED, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(BRED, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(ARMOR_TYPE, (Object)0);
    }

    @Override
    public int getArmorType() {
        return (Integer)this.field_70180_af.func_187225_a(ARMOR_TYPE);
    }

    @Override
    public void setArmorType(int i) {
        this.field_70180_af.func_187227_b(ARMOR_TYPE, (Object)i);
    }

    public boolean getIsChested() {
        return (Boolean)this.field_70180_af.func_187225_a(CHESTED);
    }

    public void setIsChested(boolean flag) {
        this.field_70180_af.func_187227_b(CHESTED, (Object)flag);
    }

    @Override
    public boolean getIsSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public boolean getHasBred() {
        return (Boolean)this.field_70180_af.func_187225_a(BRED);
    }

    public void setBred(boolean flag) {
        this.field_70180_af.func_187227_b(BRED, (Object)flag);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.field_70180_af.func_187225_a(RIDEABLE);
    }

    @Override
    public void setRideable(boolean flag) {
        this.field_70180_af.func_187227_b(RIDEABLE, (Object)flag);
    }

    public void setSitting(boolean flag) {
        this.field_70180_af.func_187227_b(SITTING, (Object)flag);
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        Entity entity = damagesource.func_76346_g();
        if (this.func_184207_aI() && entity == this.func_184187_bx()) {
            return false;
        }
        if (entity instanceof EntityWolf) {
            EntityCreature entitycreature = (EntityCreature)entity;
            entitycreature.func_70624_b(null);
            return false;
        }
        if ((i -= (float)(this.getArmorType() + 2)) < 0.0f) {
            i = 0.0f;
        }
        return super.func_70097_a(damagesource, i);
    }

    public boolean func_70067_L() {
        return !this.func_184207_aI();
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos((double)MathHelper.func_76128_c((double)this.field_70165_t), (double)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), this.field_70161_v);
        Biome currentbiome = MoCTools.biomeKind(this.field_70170_p, pos);
        try {
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
                this.setType(60);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public float colorFX(int sColor, int typeInt) {
        switch (typeInt) {
            case 23: 
            case 24: 
            case 25: {
                if (sColor == 1) {
                    return 0.234375f;
                }
                if (sColor == 2) {
                    return 0.69921875f;
                }
                return 0.4375f;
            }
            case 40: {
                if (sColor == 1) {
                    return 0.54296875f;
                }
                if (sColor == 2) {
                    return 0.0f;
                }
                return 0.0f;
            }
            case 48: {
                if (sColor == 1) {
                    return 0.69921875f;
                }
                if (sColor == 2) {
                    return 0.625f;
                }
                return 0.0859375f;
            }
            case 49: {
                if (sColor == 1) {
                    return 0.57421875f;
                }
                if (sColor == 2) {
                    return 0.3515625f;
                }
                return 0.76171875f;
            }
            case 51: {
                if (sColor == 1) {
                    return 0.1171875f;
                }
                if (sColor == 2) {
                    return 0.5625f;
                }
                return 0.99609375f;
            }
            case 52: {
                if (sColor == 1) {
                    return 0.99609375f;
                }
                if (sColor == 2) {
                    return 0.41015625f;
                }
                return 0.703125f;
            }
            case 53: {
                if (sColor == 1) {
                    return 0.734375f;
                }
                if (sColor == 2) {
                    return 0.9296875f;
                }
                return 0.40625f;
            }
            case 54: {
                if (sColor == 1) {
                    return 0.4296875f;
                }
                if (sColor == 2) {
                    return 0.48046875f;
                }
                return 0.54296875f;
            }
            case 55: {
                if (sColor == 1) {
                    return 0.7578125f;
                }
                if (sColor == 2) {
                    return 0.11328125f;
                }
                return 0.1328125f;
            }
            case 56: {
                if (sColor == 1) {
                    return 0.24609375f;
                }
                if (sColor == 2) {
                    return 0.17578125f;
                }
                return 0.99609375f;
            }
            case 57: {
                if (sColor == 1) {
                    return 0.26953125f;
                }
                if (sColor == 2) {
                    return 0.5703125f;
                }
                return 0.56640625f;
            }
            case 58: {
                if (sColor == 1) {
                    return 0.3515625f;
                }
                if (sColor == 2) {
                    return 0.53125f;
                }
                return 0.16796875f;
            }
            case 59: {
                if (sColor == 1) {
                    return 0.8515625f;
                }
                if (sColor == 2) {
                    return 0.15625f;
                }
                return 0.0f;
            }
        }
        if (sColor == 1) {
            return 0.99609375f;
        }
        if (sColor == 2) {
            return 0.921875f;
        }
        return 0.54296875f;
    }

    public void dissapearHorse() {
        this.field_70128_L = true;
    }

    private void drinkingHorse() {
        this.openMouth();
        MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_DRINK);
    }

    @Override
    public void dropArmor() {
        ItemStack armorStack;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int armorType = this.getArmorType();
        if (armorType != 0) {
            MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_ARMOR_OFF);
        }
        switch (armorType) {
            case 1: {
                armorStack = new ItemStack(Items.field_151138_bX, 1);
                break;
            }
            case 2: {
                armorStack = new ItemStack(Items.field_151136_bY, 1);
                break;
            }
            case 3: {
                armorStack = new ItemStack(Items.field_151125_bZ, 1);
                break;
            }
            case 4: {
                armorStack = new ItemStack((Item)MoCItems.horsearmorcrystal, 1);
                break;
            }
            default: {
                return;
            }
        }
        EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, armorStack);
        entityItem.func_174869_p();
        this.field_70170_p.func_72838_d((Entity)entityItem);
        this.setArmorType(0);
    }

    public void dropBags() {
        if (!this.isBagger() || !this.getIsChested() || this.field_70170_p.field_72995_K) {
            return;
        }
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack((Block)Blocks.field_150486_ae, 1));
        float f3 = 0.05f;
        entityitem.field_70159_w = (float)this.field_70170_p.field_73012_v.nextGaussian() * f3;
        entityitem.field_70181_x = (float)this.field_70170_p.field_73012_v.nextGaussian() * f3 + 0.2f;
        entityitem.field_70179_y = (float)this.field_70170_p.field_73012_v.nextGaussian() * f3;
        this.field_70170_p.func_72838_d((Entity)entityitem);
        this.setIsChested(false);
    }

    private void eatingHorse() {
        this.openMouth();
        MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_EAT);
    }

    public void func_180430_e(float f, float f1) {
        if (this.isFlyer() || this.isFloater()) {
            return;
        }
        float i = (float)(Math.ceil(f - 3.0f) / 2.0);
        if (!this.field_70170_p.field_72995_K && i > 0.0f) {
            if (this.getType() >= 10) {
                i /= 2.0f;
            }
            if (i > 1.0f) {
                this.func_70097_a(DamageSource.field_76379_h, i);
            }
            if (this.func_184207_aI() && i > 1.0f) {
                for (Entity entity : this.func_184182_bu()) {
                    entity.func_70097_a(DamageSource.field_76379_h, i);
                }
            }
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v));
            Block block = iblockstate.func_177230_c();
            if (iblockstate.func_185904_a() != Material.field_151579_a && !this.func_174814_R()) {
                SoundType soundtype = block.getSoundType(iblockstate, this.field_70170_p, new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v), (Entity)this);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundtype.func_185844_d(), this.func_184176_by(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    public int getInventorySize() {
        if (this.getType() == 40) {
            return 18;
        }
        if (this.getType() > 64) {
            return 27;
        }
        return 9;
    }

    @Override
    public double getCustomJump() {
        double horseJump = 0.35;
        if (this.getType() < 6) {
            horseJump = 0.35;
        } else if (this.getType() > 5 && this.getType() < 11) {
            horseJump = 0.4;
        } else if (this.getType() > 10 && this.getType() < 16) {
            horseJump = 0.45;
        } else if (this.getType() > 15 && this.getType() < 21) {
            horseJump = 0.5;
        } else if (this.getType() > 20 && this.getType() < 26) {
            horseJump = 0.45;
        } else if (this.getType() > 25 && this.getType() < 30) {
            horseJump = 0.5;
        } else if (this.getType() >= 30 && this.getType() < 40) {
            horseJump = 0.55;
        } else if (this.getType() >= 40 && this.getType() < 60) {
            horseJump = 0.6;
        } else if (this.getType() >= 60) {
            horseJump = 0.4;
        }
        return horseJump;
    }

    @Override
    public double getCustomSpeed() {
        double horseSpeed = 0.8;
        if (this.getType() < 6) {
            horseSpeed = 0.9;
        } else if (this.getType() > 5 && this.getType() < 11) {
            horseSpeed = 1.0;
        } else if (this.getType() > 10 && this.getType() < 16) {
            horseSpeed = 1.1;
        } else if (this.getType() > 15 && this.getType() < 21) {
            horseSpeed = 1.2;
        } else if (this.getType() > 20 && this.getType() < 26) {
            horseSpeed = 0.8;
        } else if (this.getType() > 25 && this.getType() < 30) {
            horseSpeed = 1.0;
        } else if (this.getType() > 30 && this.getType() < 40) {
            horseSpeed = 1.2;
        } else if (this.getType() >= 40 && this.getType() < 60) {
            horseSpeed = 1.3;
        } else if (this.getType() == 60 || this.getType() == 61) {
            horseSpeed = 1.1;
        } else if (this.getType() == 65) {
            horseSpeed = 0.7;
        } else if (this.getType() > 65) {
            horseSpeed = 0.9;
        }
        if (this.sprintCounter > 0 && this.sprintCounter < 150) {
            horseSpeed *= 1.5;
        }
        if (this.sprintCounter > 150) {
            horseSpeed *= 0.5;
        }
        return horseSpeed;
    }

    protected SoundEvent func_184615_bR() {
        this.openMouth();
        if (this.isUndead()) {
            return MoCSoundEvents.ENTITY_HORSE_DEATH_UNDEAD;
        }
        if (this.getIsGhost()) {
            return MoCSoundEvents.ENTITY_HORSE_DEATH_GHOST;
        }
        if (this.getType() == 60 || this.getType() == 61) {
            return MoCSoundEvents.ENTITY_HORSE_HURT_ZEBRA;
        }
        if (this.getType() > 64 && this.getType() < 68) {
            return SoundEvents.field_187586_ay;
        }
        return MoCSoundEvents.ENTITY_HORSE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (!blockIn.func_176223_P().func_185904_a().func_76224_d()) {
            SoundType soundtype = blockIn.func_185467_w();
            if (this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
                soundtype = Blocks.field_150431_aC.func_185467_w();
            } else if (soundtype == SoundType.field_185848_a) {
                this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            } else {
                this.func_184185_a(SoundEvents.field_187729_cv, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            }
        }
    }

    @Override
    public boolean renderName() {
        if (this.getIsGhost() && this.getAge() < 10) {
            return false;
        }
        return super.renderName();
    }

    protected Item func_146068_u() {
        boolean flag;
        boolean bl = flag = this.field_70146_Z.nextInt(100) < MoCreatures.proxy.rareItemDropChance;
        if (flag && (this.getType() == 36 || this.getType() > 49 && this.getType() < 60)) {
            return MoCItems.unicornhorn;
        }
        if (this.getType() == 39 || this.getType() == 40) {
            return Items.field_151008_G;
        }
        if (this.getType() == 38 && flag && this.field_70170_p.field_73011_w.func_177500_n()) {
            return MoCItems.heartfire;
        }
        if (this.getType() == 32 && flag) {
            return MoCItems.heartdarkness;
        }
        if (this.getType() == 26) {
            return Items.field_151103_aS;
        }
        if (this.getType() == 23 || this.getType() == 24 || this.getType() == 25) {
            if (flag) {
                return MoCItems.heartundead;
            }
            return Items.field_151078_bh;
        }
        if (this.getType() == 21 || this.getType() == 22) {
            return Items.field_151073_bk;
        }
        return Items.field_151116_aA;
    }

    public boolean getHasReproduced() {
        return this.hasReproduced;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        this.openMouth();
        if (this.isFlyer() && !this.func_184207_aI()) {
            this.wingFlap();
        } else if (this.field_70146_Z.nextInt(3) == 0) {
            this.stand();
        }
        if (this.isUndead()) {
            return MoCSoundEvents.ENTITY_HORSE_HURT_UNDEAD;
        }
        if (this.getIsGhost()) {
            return MoCSoundEvents.ENTITY_HORSE_HURT_GHOST;
        }
        if (this.getType() == 60 || this.getType() == 61) {
            return MoCSoundEvents.ENTITY_HORSE_HURT_ZEBRA;
        }
        if (this.getType() > 64 && this.getType() < 68) {
            return SoundEvents.field_187588_az;
        }
        return MoCSoundEvents.ENTITY_HORSE_HURT;
    }

    protected SoundEvent func_184639_G() {
        this.openMouth();
        if (this.field_70146_Z.nextInt(10) == 0 && !this.isMovementCeased()) {
            this.stand();
        }
        if (this.isUndead()) {
            return MoCSoundEvents.ENTITY_HORSE_AMBIENT_UNDEAD;
        }
        if (this.getIsGhost()) {
            return MoCSoundEvents.ENTITY_HORSE_AMBIENT_GHOST;
        }
        if (this.getType() == 60 || this.getType() == 61) {
            return MoCSoundEvents.ENTITY_HORSE_AMBIENT_ZEBRA;
        }
        if (this.getType() > 64 && this.getType() < 68) {
            return SoundEvents.field_187580_av;
        }
        return MoCSoundEvents.ENTITY_HORSE_AMBIENT;
    }

    @Override
    protected SoundEvent getAngrySound() {
        this.openMouth();
        this.stand();
        if (this.isUndead()) {
            return MoCSoundEvents.ENTITY_HORSE_ANGRY_UNDEAD;
        }
        if (this.getIsGhost()) {
            return MoCSoundEvents.ENTITY_HORSE_ANGRY_GHOST;
        }
        if (this.getType() == 60 || this.getType() == 61) {
            return MoCSoundEvents.ENTITY_HORSE_HURT_ZEBRA;
        }
        if (this.getType() > 64 && this.getType() < 68) {
            return SoundEvents.field_187582_aw;
        }
        return SoundEvents.field_187699_cl;
    }

    public float calculateMaxHealth() {
        int maximumHealth = 30;
        if (this.getType() < 6) {
            maximumHealth = 25;
        } else if (this.getType() > 5 && this.getType() < 11) {
            maximumHealth = 30;
        } else if (this.getType() > 10 && this.getType() < 16) {
            maximumHealth = 35;
        } else if (this.getType() > 15 && this.getType() < 21) {
            maximumHealth = 40;
        } else if (this.getType() > 20 && this.getType() < 26) {
            maximumHealth = 35;
        } else if (this.getType() > 25 && this.getType() < 30) {
            maximumHealth = 35;
        } else if (this.getType() >= 30 && this.getType() < 40) {
            maximumHealth = 50;
        } else if (this.getType() == 40) {
            maximumHealth = 50;
        } else if (this.getType() > 40 && this.getType() < 60) {
            maximumHealth = 40;
        } else if (this.getType() >= 60) {
            maximumHealth = 30;
        }
        return maximumHealth;
    }

    @Override
    public int getMaxTemper() {
        if (this.getType() == 60) {
            return 200;
        }
        return 100;
    }

    public int getNightmareInt() {
        return this.nightmareInt;
    }

    public void setNightmareInt(int i) {
        this.nightmareInt = i;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public int func_70627_aG() {
        return 400;
    }

    @Override
    public ResourceLocation getTexture() {
        String tempTexture;
        switch (this.getType()) {
            case 1: {
                tempTexture = "horsewhite.png";
                break;
            }
            case 2: {
                tempTexture = "horsecreamy.png";
                break;
            }
            case 3: {
                tempTexture = "horsebrown.png";
                break;
            }
            case 4: {
                tempTexture = "horsedarkbrown.png";
                break;
            }
            case 5: {
                tempTexture = "horseblack.png";
                break;
            }
            case 6: {
                tempTexture = "horsebrightcreamy.png";
                break;
            }
            case 7: {
                tempTexture = "horsespeckled.png";
                break;
            }
            case 8: {
                tempTexture = "horsepalebrown.png";
                break;
            }
            case 9: {
                tempTexture = "horsegrey.png";
                break;
            }
            case 11: {
                tempTexture = "horsepinto.png";
                break;
            }
            case 12: {
                tempTexture = "horsebrightpinto.png";
                break;
            }
            case 13: {
                tempTexture = "horsepalespeckles.png";
                break;
            }
            case 16: {
                tempTexture = "horsespotted.png";
                break;
            }
            case 17: {
                tempTexture = "horsecow.png";
                break;
            }
            case 21: {
                tempTexture = "horseghost.png";
                break;
            }
            case 22: {
                tempTexture = "horseghostb.png";
                break;
            }
            case 23: {
                tempTexture = "horseundead.png";
                break;
            }
            case 24: {
                tempTexture = "horseundeadunicorn.png";
                break;
            }
            case 25: {
                tempTexture = "horseundeadpegasus.png";
                break;
            }
            case 26: {
                tempTexture = "horseskeleton.png";
                break;
            }
            case 27: {
                tempTexture = "horseunicornskeleton.png";
                break;
            }
            case 28: {
                tempTexture = "horsepegasusskeleton.png";
                break;
            }
            case 32: {
                tempTexture = "horsebat.png";
                break;
            }
            case 36: {
                tempTexture = "horseunicorn.png";
                break;
            }
            case 38: {
                tempTexture = "horsenightmare.png";
                break;
            }
            case 39: {
                tempTexture = "horsepegasus.png";
                break;
            }
            case 40: {
                tempTexture = "horsedarkpegasus.png";
                break;
            }
            case 48: {
                tempTexture = "horsefairyyellow.png";
                break;
            }
            case 49: {
                tempTexture = "horsefairypurple.png";
                break;
            }
            case 50: {
                tempTexture = "horsefairywhite.png";
                break;
            }
            case 51: {
                tempTexture = "horsefairyblue.png";
                break;
            }
            case 52: {
                tempTexture = "horsefairypink.png";
                break;
            }
            case 53: {
                tempTexture = "horsefairylightgreen.png";
                break;
            }
            case 54: {
                tempTexture = "horsefairyblack.png";
                break;
            }
            case 55: {
                tempTexture = "horsefairyred.png";
                break;
            }
            case 56: {
                tempTexture = "horsefairydarkblue.png";
                break;
            }
            case 57: {
                tempTexture = "horsefairycyan.png";
                break;
            }
            case 58: {
                tempTexture = "horsefairygreen.png";
                break;
            }
            case 59: {
                tempTexture = "horsefairyorange.png";
                break;
            }
            case 60: {
                tempTexture = "horsezebra.png";
                break;
            }
            case 61: {
                tempTexture = "horsezorse.png";
                break;
            }
            case 65: {
                tempTexture = "horsedonkey.png";
                break;
            }
            case 66: {
                tempTexture = "horsemule.png";
                break;
            }
            case 67: {
                tempTexture = "horsezonky.png";
                break;
            }
            default: {
                tempTexture = "horsebug.png";
            }
        }
        if ((this.isArmored() || this.isMagicHorse()) && this.getArmorType() > 0) {
            String armorTex = "";
            if (this.getArmorType() == 1) {
                armorTex = "metal.png";
            }
            if (this.getArmorType() == 2) {
                armorTex = "gold.png";
            }
            if (this.getArmorType() == 3) {
                armorTex = "diamond.png";
            }
            if (this.getArmorType() == 4) {
                armorTex = "crystaline.png";
            }
            return MoCreatures.proxy.getModelTexture(tempTexture.replace(".png", armorTex));
        }
        if (this.isUndead() && this.getType() < 26) {
            String baseTex = "horseundead";
            int max = 79;
            if (this.getType() == 25) {
                baseTex = "horseundeadpegasus";
            }
            if (this.getType() == 24) {
                baseTex = "horseundeadunicorn";
                max = 69;
            }
            String iteratorTex = "1";
            if (MoCreatures.proxy.getAnimateTextures()) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    ++this.textCounter;
                }
                if (this.textCounter < 10) {
                    this.textCounter = 10;
                }
                if (this.textCounter > max) {
                    this.textCounter = 10;
                }
                iteratorTex = String.valueOf(this.textCounter);
                iteratorTex = iteratorTex.substring(0, 1);
            }
            String decayTex = String.valueOf(this.getAge() / 100);
            decayTex = decayTex.substring(0, 1);
            return MoCreatures.proxy.getModelTexture(baseTex + decayTex + iteratorTex + ".png");
        }
        if (!MoCreatures.proxy.getAnimateTextures()) {
            return MoCreatures.proxy.getModelTexture(tempTexture);
        }
        if (this.isNightmare()) {
            this.field_70146_Z.nextInt(1);
            ++this.textCounter;
            if (this.textCounter < 10) {
                this.textCounter = 10;
            }
            if (this.textCounter > 59) {
                this.textCounter = 10;
            }
            String NTA = "horsenightmare";
            String NTB = String.valueOf(this.textCounter);
            NTB = NTB.substring(0, 1);
            String NTC = ".png";
            return MoCreatures.proxy.getModelTexture(NTA + NTB + NTC);
        }
        if (this.transformCounter != 0 && this.transformType != 0) {
            String newText;
            switch (this.transformType) {
                case 24: {
                    newText = "horseundeadunicorn.png";
                    break;
                }
                case 25: {
                    newText = "horseundeadpegasus.png";
                    break;
                }
                case 32: {
                    newText = "horsebat.png";
                    break;
                }
                case 36: {
                    newText = "horseunicorn.png";
                    break;
                }
                case 38: {
                    newText = "horsenightmare1.png";
                    break;
                }
                case 39: {
                    newText = "horsepegasus.png";
                    break;
                }
                case 40: {
                    newText = "horseblackpegasus.png";
                    break;
                }
                case 48: {
                    newText = "horsefairyyellow.png";
                    break;
                }
                case 49: {
                    newText = "horsefairypurple.png";
                    break;
                }
                case 50: {
                    newText = "horsefairywhite.png";
                    break;
                }
                case 51: {
                    newText = "horsefairyblue.png";
                    break;
                }
                case 52: {
                    newText = "horsefairypink.png";
                    break;
                }
                case 53: {
                    newText = "horsefairylightgreen.png";
                    break;
                }
                case 54: {
                    newText = "horsefairyblack.png";
                    break;
                }
                case 55: {
                    newText = "horsefairyred.png";
                    break;
                }
                case 56: {
                    newText = "horsefairydarkblue.png";
                    break;
                }
                case 57: {
                    newText = "horsefairycyan.png";
                    break;
                }
                case 58: {
                    newText = "horsefairygreen.png";
                    break;
                }
                case 59: {
                    newText = "horsefairyorange.png";
                    break;
                }
                default: {
                    newText = "horseundead.png";
                }
            }
            if (this.transformCounter > 75 && this.transformCounter % 4 == 0) {
                return MoCreatures.proxy.getModelTexture(newText);
            }
        }
        return MoCreatures.proxy.getModelTexture(tempTexture);
    }

    public byte getVanishC() {
        return (byte)this.vanishCounter;
    }

    public void setVanishC(byte i) {
        this.vanishCounter = i;
    }

    private int horseGenetics(int typeA, int typeB) {
        boolean flag = MoCreatures.proxy.easyHorseBreeding;
        if (typeA == typeB) {
            return typeA;
        }
        if (typeA == 60 && typeB < 21 || typeB == 60 && typeA < 21) {
            return 61;
        }
        if (typeA == 65 && typeB < 21 || typeB == 65 && typeA < 21) {
            return 66;
        }
        if (typeA == 60 && typeB == 65 || typeB == 60 && typeA == 65) {
            return 67;
        }
        if (typeA > 20 && typeB < 21 || typeB > 20 && typeA < 21) {
            return Math.min(typeA, typeB);
        }
        if (typeA == 36 && typeB == 39 || typeB == 36 && typeA == 39) {
            return 50;
        }
        if (typeA == 36 && typeB == 40 || typeB == 36 && typeA == 40) {
            return 54;
        }
        if (typeA > 20) {
            return this.field_70146_Z.nextInt(5) + 1;
        }
        if (!flag) {
            int chanceInt = this.field_70146_Z.nextInt(4) + 1;
            if (chanceInt == 1) {
                return typeA;
            }
            if (chanceInt == 2) {
                return typeB;
            }
        }
        if (typeA == 1 && typeB == 2 || typeA == 2 && typeB == 1) {
            return 6;
        }
        if (typeA == 1 && typeB == 3 || typeA == 3 && typeB == 1) {
            return 2;
        }
        if (typeA == 1 && typeB == 4 || typeA == 4 && typeB == 1) {
            return 7;
        }
        if (typeA == 1 && typeB == 5 || typeA == 5 && typeB == 1) {
            return 9;
        }
        if (typeA == 1 && typeB == 7 || typeA == 7 && typeB == 1) {
            return 12;
        }
        if (typeA == 1 && typeB == 8 || typeA == 8 && typeB == 1) {
            return 7;
        }
        if (typeA == 1 && typeB == 9 || typeA == 9 && typeB == 1) {
            return 13;
        }
        if (typeA == 1 && typeB == 11 || typeA == 11 && typeB == 1) {
            return 12;
        }
        if (typeA == 1 && typeB == 12 || typeA == 12 && typeB == 1) {
            return 13;
        }
        if (typeA == 1 && typeB == 17 || typeA == 17 && typeB == 1) {
            return 16;
        }
        if (typeA == 2 && typeB == 4 || typeA == 4 && typeB == 2) {
            return 3;
        }
        if (typeA == 2 && typeB == 5 || typeA == 5 && typeB == 2) {
            return 4;
        }
        if (typeA == 2 && typeB == 7 || typeA == 7 && typeB == 2) {
            return 8;
        }
        if (typeA == 2 && typeB == 8 || typeA == 8 && typeB == 2) {
            return 3;
        }
        if (typeA == 2 && typeB == 12 || typeA == 12 && typeB == 2) {
            return 6;
        }
        if (typeA == 2 && typeB == 16 || typeA == 16 && typeB == 2) {
            return 13;
        }
        if (typeA == 2 && typeB == 17 || typeA == 17 && typeB == 2) {
            return 12;
        }
        if (typeA == 3 && typeB == 4 || typeA == 4 && typeB == 3) {
            return 8;
        }
        if (typeA == 3 && typeB == 5 || typeA == 5 && typeB == 3) {
            return 8;
        }
        if (typeA == 3 && typeB == 6 || typeA == 6 && typeB == 3) {
            return 2;
        }
        if (typeA == 3 && typeB == 7 || typeA == 7 && typeB == 3) {
            return 11;
        }
        if (typeA == 3 && typeB == 9 || typeA == 9 && typeB == 3) {
            return 8;
        }
        if (typeA == 3 && typeB == 12 || typeA == 12 && typeB == 3) {
            return 11;
        }
        if (typeA == 3 && typeB == 16 || typeA == 16 && typeB == 3) {
            return 11;
        }
        if (typeA == 3 && typeB == 17 || typeA == 17 && typeB == 3) {
            return 11;
        }
        if (typeA == 4 && typeB == 6 || typeA == 6 && typeB == 4) {
            return 3;
        }
        if (typeA == 4 && typeB == 7 || typeA == 7 && typeB == 4) {
            return 8;
        }
        if (typeA == 4 && typeB == 9 || typeA == 9 && typeB == 4) {
            return 7;
        }
        if (typeA == 4 && typeB == 11 || typeA == 11 && typeB == 4) {
            return 7;
        }
        if (typeA == 4 && typeB == 12 || typeA == 12 && typeB == 4) {
            return 7;
        }
        if (typeA == 4 && typeB == 13 || typeA == 13 && typeB == 4) {
            return 7;
        }
        if (typeA == 4 && typeB == 16 || typeA == 16 && typeB == 4) {
            return 13;
        }
        if (typeA == 4 && typeB == 17 || typeA == 17 && typeB == 4) {
            return 5;
        }
        if (typeA == 5 && typeB == 6 || typeA == 6 && typeB == 5) {
            return 4;
        }
        if (typeA == 5 && typeB == 7 || typeA == 7 && typeB == 5) {
            return 4;
        }
        if (typeA == 5 && typeB == 8 || typeA == 8 && typeB == 5) {
            return 4;
        }
        if (typeA == 5 && typeB == 11 || typeA == 11 && typeB == 5) {
            return 17;
        }
        if (typeA == 5 && typeB == 12 || typeA == 12 && typeB == 5) {
            return 13;
        }
        if (typeA == 5 && typeB == 13 || typeA == 13 && typeB == 5) {
            return 16;
        }
        if (typeA == 5 && typeB == 16 || typeA == 16 && typeB == 5) {
            return 17;
        }
        if (typeA == 6 && typeB == 8 || typeA == 8 && typeB == 6) {
            return 2;
        }
        if (typeA == 6 && typeB == 17 || typeA == 17 && typeB == 6) {
            return 7;
        }
        if (typeA == 7 && typeB == 16 || typeA == 16 && typeB == 7) {
            return 13;
        }
        if (typeA == 8 && typeB == 11 || typeA == 11 && typeB == 8) {
            return 7;
        }
        if (typeA == 8 && typeB == 12 || typeA == 12 && typeB == 8) {
            return 7;
        }
        if (typeA == 8 && typeB == 13 || typeA == 13 && typeB == 8) {
            return 7;
        }
        if (typeA == 8 && typeB == 16 || typeA == 16 && typeB == 8) {
            return 7;
        }
        if (typeA == 8 && typeB == 17 || typeA == 17 && typeB == 8) {
            return 7;
        }
        if (typeA == 9 && typeB == 16 || typeA == 16 && typeB == 9) {
            return 13;
        }
        if (typeA == 11 && typeB == 16 || typeA == 16 && typeB == 11) {
            return 13;
        }
        if (typeA == 11 && typeB == 17 || typeA == 17 && typeB == 11) {
            return 7;
        }
        if (typeA == 12 && typeB == 16 || typeA == 16 && typeB == 12) {
            return 13;
        }
        if (typeA == 13 && typeB == 17 || typeA == 17 && typeB == 13) {
            return 9;
        }
        return typeA;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        if (this.getType() == 60 && !this.getIsTamed() && this.isZebraRunning()) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && !this.getIsRideable() && stack.func_77973_b() instanceof ItemSaddle) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.setRideable(true);
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == Items.field_151138_bX && this.isArmored()) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON);
            }
            this.dropArmor();
            this.setArmorType(1);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == Items.field_151136_bY && this.isArmored()) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON);
            }
            this.dropArmor();
            this.setArmorType(2);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == Items.field_151125_bZ && this.isArmored()) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON);
            }
            this.dropArmor();
            this.setArmorType(3);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == MoCItems.horsearmorcrystal && this.isMagicHorse()) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON);
            }
            this.dropArmor();
            this.setArmorType(4);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == MoCItems.essenceundead) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (this.isUndead() || this.getIsGhost()) {
                this.func_70606_j(this.func_110138_aP());
            }
            if (this.getType() == 39 || this.getType() == 32 || this.getType() == 40) {
                this.transform(25);
            } else if (this.getType() == 36 || this.getType() > 47 && this.getType() < 60) {
                this.transform(24);
            } else if (this.getType() < 21 || this.getType() == 60 || this.getType() == 61) {
                this.transform(23);
            }
            this.drinkingHorse();
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == MoCItems.essencefire) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (this.isNightmare()) {
                if (this.getIsAdult() && this.func_110143_aJ() == this.func_110138_aP()) {
                    this.eatenPumpkin = true;
                }
                this.func_70606_j(this.func_110138_aP());
            }
            if (this.getType() == 61) {
                this.transform(38);
            }
            this.drinkingHorse();
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == MoCItems.essencedarkness) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (this.getType() == 32) {
                if (this.getIsAdult() && this.func_110143_aJ() == this.func_110138_aP()) {
                    this.eatenPumpkin = true;
                }
                this.func_70606_j(this.func_110138_aP());
            }
            if (this.getType() == 61) {
                this.transform(32);
            }
            if (this.getType() == 39) {
                this.transform(40);
            }
            this.drinkingHorse();
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == MoCItems.essencelight) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (this.isMagicHorse()) {
                if (this.getIsAdult() && this.func_110143_aJ() == this.func_110138_aP()) {
                    this.eatenPumpkin = true;
                }
                this.func_70606_j(this.func_110138_aP());
            }
            if (this.isNightmare()) {
                this.transform(36);
            }
            if (this.getType() == 32 && this.field_70163_u > 128.0) {
                this.transform(39);
            }
            if (this.isUndead() && this.getIsAdult() && !this.field_70170_p.field_72995_K) {
                this.setAge(10);
                if (this.getType() >= 26) {
                    this.setType(this.getType() - 3);
                }
            }
            this.drinkingHorse();
            return true;
        }
        if (!stack.func_190926_b() && this.isAmuletHorse() && this.getIsTamed()) {
            if ((this.getType() == 26 || this.getType() == 27 || this.getType() == 28) && stack.func_77973_b() == MoCItems.amuletbone) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
                this.vanishHorse();
                return true;
            }
            if (this.getType() > 47 && this.getType() < 60 && stack.func_77973_b() == MoCItems.amuletfairy) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
                this.vanishHorse();
                return true;
            }
            if ((this.getType() == 39 || this.getType() == 40) && stack.func_77973_b() == MoCItems.amuletpegasus) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
                this.vanishHorse();
                return true;
            }
            if ((this.getType() == 21 || this.getType() == 22) && stack.func_77973_b() == MoCItems.amuletghost) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
                this.vanishHorse();
                return true;
            }
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151100_aR && this.getType() == 50) {
            int colorInt = stack.func_77952_i();
            switch (colorInt) {
                case 14: {
                    this.transform(59);
                    break;
                }
                case 13: {
                    break;
                }
                case 12: {
                    this.transform(51);
                    break;
                }
                case 11: {
                    this.transform(48);
                    break;
                }
                case 10: {
                    this.transform(53);
                    break;
                }
                case 9: {
                    this.transform(52);
                    break;
                }
                case 8: {
                    break;
                }
                case 7: {
                    break;
                }
                case 6: {
                    this.transform(57);
                    break;
                }
                case 5: {
                    this.transform(49);
                    break;
                }
                case 4: {
                    this.transform(56);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    this.transform(58);
                    break;
                }
                case 1: {
                    this.transform(55);
                    break;
                }
                case 0: {
                    this.transform(54);
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.eatingHorse();
            return true;
        }
        if (!stack.func_190926_b() && this.getType() == 60 && stack.func_77973_b() instanceof ItemRecord && MoCreatures.proxy.easterEggs) {
            player.func_184611_a(hand, ItemStack.field_190927_a);
            if (!this.field_70170_p.field_72995_K) {
                EntityItem entityitem1 = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack((Item)MoCItems.recordshuffle, 1));
                entityitem1.func_174867_a(20);
                this.field_70170_p.func_72838_d((Entity)entityitem1);
            }
            this.eatingHorse();
            return true;
        }
        if (!(stack.func_190926_b() || stack.func_77973_b() != Items.field_151015_O || this.isMagicHorse() || this.isUndead())) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.setTemper(this.getTemper() + 25);
                if (this.getTemper() > this.getMaxTemper()) {
                    this.setTemper(this.getMaxTemper() - 5);
                }
            }
            if (this.func_110143_aJ() + 5.0f > this.func_110138_aP()) {
                this.func_70606_j(this.func_110138_aP());
            }
            this.eatingHorse();
            if (!this.getIsAdult() && this.getAge() < this.getMaxAge()) {
                this.setAge(this.getAge() + 1);
            }
            return true;
        }
        if (!(stack.func_190926_b() || stack.func_77973_b() != MoCItems.sugarlump || this.isMagicHorse() || this.isUndead())) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.setTemper(this.getTemper() + 25);
                if (this.getTemper() > this.getMaxTemper()) {
                    this.setTemper(this.getMaxTemper() - 5);
                }
            }
            if (this.func_110143_aJ() + 10.0f > this.func_110138_aP()) {
                this.func_70606_j(this.func_110138_aP());
            }
            this.eatingHorse();
            if (!this.getIsAdult() && this.getAge() < this.getMaxAge()) {
                this.setAge(this.getAge() + 2);
            }
            return true;
        }
        if (!(stack.func_190926_b() || stack.func_77973_b() != Items.field_151025_P || this.isMagicHorse() || this.isUndead())) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.setTemper(this.getTemper() + 100);
                if (this.getTemper() > this.getMaxTemper()) {
                    this.setTemper(this.getMaxTemper() - 5);
                }
            }
            if (this.func_110143_aJ() + 20.0f > this.func_110138_aP()) {
                this.func_70606_j(this.func_110138_aP());
            }
            this.eatingHorse();
            if (!this.getIsAdult() && this.getAge() < this.getMaxAge()) {
                this.setAge(this.getAge() + 3);
            }
            return true;
        }
        if (!(stack.func_190926_b() || stack.func_77973_b() != Items.field_151034_e && stack.func_77973_b() != Items.field_151153_ao || this.isMagicHorse() || this.isUndead())) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                MoCTools.tameWithName(player, this);
            }
            this.func_70606_j(this.func_110138_aP());
            this.eatingHorse();
            if (!this.getIsAdult() && this.getAge() < this.getMaxAge() && !this.field_70170_p.field_72995_K) {
                this.setAge(this.getAge() + 1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && this.isBagger()) {
            if (this.getIsChested()) {
                return false;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.setIsChested(true);
            MoCTools.playCustomSound((Entity)this, SoundEvents.field_187665_Y);
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150407_cf)) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.setSitting(true);
            this.eatingHorse();
            if (!this.isMagicHorse() && !this.isUndead()) {
                this.func_70606_j(this.func_110138_aP());
            }
            return true;
        }
        if (this.getIsChested() && player.func_70093_af()) {
            if (this.localChest == null) {
                this.localChest = new MoCAnimalChest("HorseChest", this.getInventorySize());
            }
            if (!this.field_70170_p.field_72995_K) {
                player.func_71007_a((IInventory)this.localChest);
            }
            return true;
        }
        if (!(stack.func_190926_b() || stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150423_aK) && stack.func_77973_b() != Items.field_151009_A && stack.func_77973_b() != Items.field_151105_aU && stack.func_77973_b() != Items.field_151150_bK)) {
            if (!this.getIsAdult() || this.isMagicHorse() || this.isUndead()) {
                return false;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (stack.func_77973_b() == Items.field_151009_A) {
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151054_z));
                } else {
                    player.field_71071_by.func_70441_a(new ItemStack(Items.field_151054_z));
                }
            } else if (stack.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            this.eatenPumpkin = true;
            this.func_70606_j(this.func_110138_aP());
            this.eatingHorse();
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == MoCItems.whip && this.getIsTamed() && !this.func_184207_aI()) {
            this.setSitting(!this.getIsSitting());
            this.setIsJumping(false);
            this.func_70661_as().func_75499_g();
            this.func_70624_b(null);
            return true;
        }
        if (this.getIsRideable() && this.getIsAdult() && !this.func_184207_aI()) {
            if (!this.field_70170_p.field_72995_K && player.func_184220_m((Entity)this)) {
                player.field_70177_z = this.field_70177_z;
                player.field_70125_A = this.field_70125_A;
                this.setSitting(false);
                this.gestationTime = 0;
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean isAmuletHorse() {
        return this.getType() == 21 || this.getType() == 22 || this.getType() == 26 || this.getType() == 27 || this.getType() == 28 || this.getType() == 39 || this.getType() == 40 || this.getType() > 47 && this.getType() < 60;
    }

    public boolean isArmored() {
        return this.getType() < 21;
    }

    public boolean isBagger() {
        return this.getType() == 66 || this.getType() == 65 || this.getType() == 67 || this.getType() == 39 || this.getType() == 40 || this.getType() == 25 || this.getType() == 28 || this.getType() > 44 && this.getType() < 60;
    }

    public boolean isFloater() {
        return this.getType() == 36 || this.getType() == 27 || this.getType() == 24 || this.getType() == 22;
    }

    @Override
    public boolean isFlyer() {
        return this.getType() == 39 || this.getType() == 40 || this.getType() > 44 && this.getType() < 60 || this.getType() == 32 || this.getType() == 21 || this.getType() == 25 || this.getType() == 28;
    }

    @Override
    public boolean getIsGhost() {
        return this.getType() == 21 || this.getType() == 22;
    }

    public boolean isMagicHorse() {
        return this.getType() == 39 || this.getType() == 36 || this.getType() == 32 || this.getType() == 40 || this.getType() > 44 && this.getType() < 60 || this.getType() == 21 || this.getType() == 22;
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsSitting() || this.func_184207_aI() || this.standCounter != 0 || this.shuffleCounter != 0 || this.getVanishC() != 0;
    }

    public boolean isNightmare() {
        return this.getType() == 38;
    }

    public boolean isPureBreed() {
        return this.getType() > 10 && this.getType() < 21;
    }

    public boolean isUndead() {
        return this.getType() > 22 && this.getType() < 29;
    }

    public boolean isUnicorned() {
        return this.getType() == 36 || this.getType() >= 45 && this.getType() < 60 || this.getType() == 27 || this.getType() == 24;
    }

    public boolean isZebraRunning() {
        boolean flag = false;
        EntityPlayer ep1 = this.field_70170_p.func_72890_a((Entity)this, 8.0);
        if (ep1 != null) {
            MoCEntityHorse playerHorse;
            flag = true;
            if (ep1.func_184187_bx() instanceof MoCEntityHorse && ((playerHorse = (MoCEntityHorse)ep1.func_184187_bx()).getType() == 16 || playerHorse.getType() == 17 || playerHorse.getType() == 60 || playerHorse.getType() == 61)) {
                flag = false;
            }
        }
        if (flag) {
            MoCTools.runLikeHell((EntityLiving)this, (Entity)ep1);
        }
        return flag;
    }

    public void LavaFX() {
        MoCreatures.proxy.LavaFX((Entity)this);
    }

    public void MaterializeFX() {
        MoCreatures.proxy.MaterializeFX(this);
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    @Override
    public int nameYOffset() {
        if (this.getIsAdult()) {
            return -80;
        }
        return -5 - this.getAge();
    }

    private boolean nearMusicBox() {
        MoCItemRecord shuffleRecord;
        Item record;
        if (this.field_70170_p.field_72995_K || !MoCreatures.proxy.easterEggs) {
            return false;
        }
        boolean flag = false;
        BlockJukebox.TileEntityJukebox jukebox = MoCTools.nearJukeBoxRecord((Entity)this, 6.0);
        if (jukebox != null && (record = jukebox.func_145856_a().func_77973_b()) == (shuffleRecord = MoCItems.recordshuffle)) {
            flag = true;
            if (this.shuffleCounter > 1000) {
                this.shuffleCounter = 0;
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 102), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                flag = false;
            }
        }
        return flag;
    }

    public void nightmareEffect() {
        if (!MoCTools.mobGriefing(this.field_70170_p)) {
            this.setNightmareInt(this.getNightmareInt() - 1);
            return;
        }
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(i, j, k);
        IBlockState blockstate = this.field_70170_p.func_180495_p(pos.func_177982_a(-1, 0, -1));
        BlockEvent.BreakEvent event = null;
        if (!this.field_70170_p.field_72995_K) {
            try {
                event = new BlockEvent.BreakEvent(this.field_70170_p, pos, blockstate, (EntityPlayer)FakePlayerFactory.get((WorldServer)DimensionManager.getWorld((int)this.field_70170_p.field_73011_w.func_186058_p().func_186068_a()), (GameProfile)MoCreatures.MOCFAKEPLAYER));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (event != null && !event.isCanceled()) {
            this.field_70170_p.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 3);
            EntityPlayer entityplayer = (EntityPlayer)this.func_184187_bx();
            if (entityplayer != null && entityplayer.func_70027_ad()) {
                entityplayer.func_70066_B();
            }
            this.setNightmareInt(this.getNightmareInt() - 1);
        }
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(10) == 0 && this.getType() == 23 || this.getType() == 24 || this.getType() == 25) {
                MoCTools.spawnMaggots(this.field_70170_p, (Entity)this);
            }
            if (this.getIsTamed() && (this.isMagicHorse() || this.isPureBreed()) && !this.getIsGhost() && this.field_70146_Z.nextInt(4) == 0) {
                MoCEntityHorse entityhorse1 = new MoCEntityHorse(this.field_70170_p);
                entityhorse1.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityhorse1);
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_MAGIC_ENCHANTED);
                entityhorse1.setOwnerId(this.func_184753_b());
                entityhorse1.setTamed(true);
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 24.0);
                if (entityplayer != null) {
                    MoCTools.tameWithName(entityplayer, entityhorse1);
                }
                entityhorse1.setAdult(false);
                entityhorse1.setAge(1);
                int l = 22;
                if (this.isFlyer()) {
                    l = 21;
                }
                entityhorse1.setType(l);
            }
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0 && (this.isFlyer() || this.isFloater())) {
            this.field_70181_x *= 0.6;
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        if (this.getType() == 38 && this.field_70146_Z.nextInt(50) == 0 && this.field_70170_p.field_72995_K) {
            this.LavaFX();
        }
        if (this.getType() == 36 && this.isOnAir() && this.field_70170_p.field_72995_K) {
            this.StarFX();
        }
        if (!this.field_70170_p.field_72995_K && this.isFlyer() && this.isOnAir()) {
            float myFlyingSpeed = MoCTools.getMyMovementSpeed((Entity)this);
            int wingFlapFreq = (int)(25.0f - myFlyingSpeed * 10.0f);
            if (!this.func_184207_aI() || wingFlapFreq < 5) {
                wingFlapFreq = 5;
            }
            if (this.field_70146_Z.nextInt(wingFlapFreq) == 0) {
                this.wingFlap();
            }
        }
        if (this.isFlyer()) {
            if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
                this.wingFlapCounter = 0;
            }
            if (this.wingFlapCounter != 0 && this.wingFlapCounter % 5 == 0 && this.field_70170_p.field_72995_K) {
                this.StarFX();
            }
            if (this.wingFlapCounter == 5 && !this.field_70170_p.field_72995_K) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_FLAP);
            }
        }
        if (this.isUndead() && this.getType() < 26 && this.getIsAdult() && this.field_70146_Z.nextInt(20) == 0) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(16) == 0) {
                    this.setAge(this.getAge() + 1);
                }
                if (this.getAge() >= 399) {
                    this.setType(this.getType() + 3);
                }
            } else {
                this.UndeadFX();
            }
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getType() == 60 && this.getIsTamed() && this.field_70146_Z.nextInt(50) == 0 && this.nearMusicBox() && this.shuffleCounter == 0) {
                this.shuffleCounter = 1;
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 101), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            }
            if (this.field_70146_Z.nextInt(300) == 0 && this.field_70725_aQ == 0) {
                this.func_70606_j(this.func_110143_aJ() + 1.0f);
                if (this.func_110143_aJ() > this.func_110138_aP()) {
                    this.func_70606_j(this.func_110138_aP());
                }
            }
            if (!this.getIsSitting() && !this.getIsTamed() && this.field_70146_Z.nextInt(300) == 0) {
                this.setSitting(true);
            }
            if (this.getIsSitting() && ++this.countEating > 50 && !this.getIsTamed()) {
                this.countEating = 0;
                this.setSitting(false);
            }
            if (this.getType() == 38 && this.func_184207_aI() && this.getNightmareInt() > 0 && this.field_70146_Z.nextInt(2) == 0) {
                this.nightmareEffect();
            }
            if (this.sprintCounter > 0 && this.sprintCounter < 150 && this.isUnicorned() && this.func_184207_aI()) {
                MoCTools.buckleMobs((EntityLiving)this, 2.0, this.field_70170_p);
                MoCTools.playCustomSound((Entity)this, SoundEvents.field_187699_cl);
            }
            if (this.isFlyer() && !this.getIsTamed() && this.field_70146_Z.nextInt(100) == 0 && !this.isMovementCeased() && !this.getIsSitting()) {
                this.wingFlap();
            }
            if (!this.readyForParenting(this)) {
                return;
            }
            int i = 0;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(8.0, 3.0, 8.0));
            for (Entity entity : list) {
                if (!(entity instanceof MoCEntityHorse) && !(entity instanceof EntityHorse)) continue;
                ++i;
            }
            if (i > 1) {
                return;
            }
            List list1 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0));
            for (Entity horsemate : list1) {
                int l;
                int horsemateType;
                boolean flag = horsemate instanceof EntityHorse;
                if (!(horsemate instanceof MoCEntityHorse) && !flag || horsemate == this) continue;
                if (!flag && !this.readyForParenting((MoCEntityHorse)horsemate)) {
                    return;
                }
                if (this.field_70146_Z.nextInt(100) == 0) {
                    ++this.gestationTime;
                }
                if (this.gestationTime % 3 == 0) {
                    MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageHeart(this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                }
                if (this.gestationTime <= 50) continue;
                MoCEntityHorse baby = new MoCEntityHorse(this.field_70170_p);
                baby.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)baby);
                MoCTools.playCustomSound((Entity)this, SoundEvents.field_187665_Y);
                this.eatenPumpkin = false;
                this.gestationTime = 0;
                if (flag) {
                    horsemateType = this.translateVanillaHorseType((AbstractHorse)((EntityHorse)horsemate));
                    if (horsemateType == -1) {
                        return;
                    }
                } else {
                    horsemateType = ((MoCEntityHorse)horsemate).getType();
                    ((MoCEntityHorse)horsemate).eatenPumpkin = false;
                    ((MoCEntityHorse)horsemate).gestationTime = 0;
                }
                if ((l = this.horseGenetics(this.getType(), horsemateType)) == 50 || l == 54) {
                    MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_MAGIC_ENCHANTED);
                    if (!flag) {
                        ((MoCEntityHorse)horsemate).dissapearHorse();
                    }
                    this.dissapearHorse();
                }
                baby.setOwnerId(this.func_184753_b());
                baby.setTamed(true);
                baby.setAdult(false);
                UUID ownerId = this.func_184753_b();
                EntityPlayer entityplayer = null;
                if (ownerId != null) {
                    entityplayer = this.field_70170_p.func_152378_a(this.func_184753_b());
                }
                if (entityplayer != null) {
                    MoCTools.tameWithName(entityplayer, baby);
                }
                baby.setType(l);
                break;
            }
        }
    }

    private int translateVanillaHorseType(AbstractHorse horse) {
        if (horse instanceof EntityDonkey) {
            return 65;
        }
        if (horse instanceof EntityHorse) {
            switch ((byte)((EntityHorse)horse).func_110202_bQ()) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 9;
                }
                case 6: {
                    return 4;
                }
            }
            return 3;
        }
        return -1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.shuffleCounter > 0) {
            ++this.shuffleCounter;
            if (this.field_70170_p.field_72995_K && this.shuffleCounter % 20 == 0) {
                double var2 = this.field_70146_Z.nextGaussian() * 0.5;
                double var4 = this.field_70146_Z.nextGaussian() * -0.1;
                double var6 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.NOTE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, var2, var4, var6, new int[0]);
            }
            if (!this.field_70170_p.field_72995_K && !this.nearMusicBox()) {
                this.shuffleCounter = 0;
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 102), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            }
        }
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
        }
        if (this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.getVanishC() > 0) {
            this.setVanishC((byte)(this.getVanishC() + 1));
            if (this.getVanishC() < 15 && this.field_70170_p.field_72995_K) {
                this.VanishFX();
            }
            if (this.getVanishC() > 100) {
                this.setVanishC((byte)101);
                MoCTools.dropHorseAmulet(this);
                this.dissapearHorse();
            }
            if (this.getVanishC() == 1) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_MAGIC_CREEPY);
            }
            if (this.getVanishC() == 70) {
                this.stand();
            }
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter < 150 && this.sprintCounter % 2 == 0 && this.field_70170_p.field_72995_K) {
                this.StarFX();
            }
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        if (this.transformCounter > 0) {
            if (this.transformCounter == 40) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_MAGIC_CONVERSION);
            }
            if (++this.transformCounter > 100) {
                this.transformCounter = 0;
                if (this.transformType != 0) {
                    this.dropArmor();
                    this.setType(this.transformType);
                }
            }
        }
        if (this.getIsGhost() && this.getAge() < 10 && this.field_70146_Z.nextInt(7) == 0) {
            this.setAge(this.getAge() + 1);
        }
        if (this.getIsGhost() && this.getAge() == 9) {
            this.setAge(100);
            this.setAdult(true);
        }
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    public boolean readyForParenting(MoCEntityHorse entityhorse) {
        int i = entityhorse.getType();
        return !entityhorse.func_184207_aI() && entityhorse.func_184187_bx() == null && entityhorse.getIsTamed() && entityhorse.eatenPumpkin && entityhorse.getIsAdult() && !entityhorse.isUndead() && !entityhorse.getIsGhost() && i != 61 && i < 66;
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            int j;
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.setAdult(false);
            }
            if ((j = this.field_70146_Z.nextInt(100)) <= 32) {
                this.setType(6);
            } else if (j <= 65) {
                this.setType(7);
            } else if (j <= 98) {
                this.setType(8);
            } else {
                this.setType(60);
            }
        }
    }

    public void setReproduced(boolean var1) {
        this.hasReproduced = var1;
    }

    private void stand() {
        if (!this.func_184207_aI() && !this.isOnAir()) {
            this.standCounter = 1;
        }
    }

    public void StarFX() {
        MoCreatures.proxy.StarFX(this);
    }

    public float tFloat() {
        if (++this.fCounter > 60) {
            this.fCounter = 0;
            this.transFloat = this.field_70146_Z.nextFloat() * 0.3f + 0.3f;
        }
        if (this.getIsGhost() && this.getAge() < 10) {
            this.transFloat = 0.0f;
        }
        return this.transFloat;
    }

    public void transform(int tType) {
        if (!this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), tType), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.transformType = tType;
        if (!this.func_184207_aI() && this.transformType != 0) {
            this.dropArmor();
            this.transformCounter = 1;
        }
    }

    public void UndeadFX() {
        MoCreatures.proxy.UndeadFX((Entity)this);
    }

    public void VanishFX() {
        MoCreatures.proxy.VanishFX(this);
    }

    public void vanishHorse() {
        this.func_70661_as().func_75499_g();
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        if (this.isBagger()) {
            MoCTools.dropInventory((Entity)this, this.localChest);
            this.dropBags();
        }
        if (!this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageVanish(this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            this.setVanishC((byte)1);
        }
        MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_MAGIC_CREEPY);
    }

    @Override
    public void dropMyStuff() {
        this.dropArmor();
        MoCTools.dropSaddle(this, this.field_70170_p);
        if (this.isBagger()) {
            MoCTools.dropInventory((Entity)this, this.localChest);
            this.dropBags();
        }
    }

    public void wingFlap() {
        if (this.isFlyer() && this.wingFlapCounter == 0) {
            this.wingFlapCounter = 1;
            if (!this.field_70170_p.field_72995_K) {
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Saddle", this.getIsRideable());
        nbttagcompound.func_74757_a("EatingHaystack", this.getIsSitting());
        nbttagcompound.func_74757_a("ChestedHorse", this.getIsChested());
        nbttagcompound.func_74757_a("HasReproduced", this.getHasReproduced());
        nbttagcompound.func_74757_a("Bred", this.getHasBred());
        nbttagcompound.func_74768_a("ArmorType", this.getArmorType());
        if (this.getIsChested() && this.localChest != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.localChest.func_70302_i_(); ++i) {
                this.localStack = this.localChest.func_70301_a(i);
                if (this.localStack.func_190926_b()) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                this.localStack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setRideable(nbttagcompound.func_74767_n("Saddle"));
        this.setSitting(nbttagcompound.func_74767_n("EatingHaystack"));
        this.setBred(nbttagcompound.func_74767_n("Bred"));
        this.setIsChested(nbttagcompound.func_74767_n("ChestedHorse"));
        this.setReproduced(nbttagcompound.func_74767_n("HasReproduced"));
        this.setArmorType((byte)nbttagcompound.func_74762_e("ArmorType"));
        if (this.getIsChested()) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
            this.localChest = new MoCAnimalChest("HorseChest", this.getInventorySize());
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
                if (j >= this.localChest.func_70302_i_()) continue;
                this.localChest.func_70299_a(j, new ItemStack(nbttagcompound1));
            }
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType >= 23 && animationType < 60) {
            this.transformType = animationType;
            this.transformCounter = 1;
        }
        if (animationType == 3) {
            this.wingFlapCounter = 1;
        }
        if (animationType == 101) {
            this.shuffleCounter = 1;
        }
        if (animationType == 102) {
            this.shuffleCounter = 0;
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        if (this.isUndead()) {
            return EnumCreatureAttribute.UNDEAD;
        }
        return super.func_70668_bt();
    }

    @Override
    protected boolean canBeTrappedInNet() {
        return this.getIsTamed() && !this.isAmuletHorse();
    }

    @Override
    public void setType(int i) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.calculateMaxHealth());
        this.func_70606_j(this.func_110138_aP());
        if (this.getType() == 38 || this.getType() == 40) {
            this.field_70178_ae = true;
        }
        super.setType(i);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        if (this.getType() == 38 || this.getType() == 40) {
            this.field_70178_ae = true;
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public void func_184232_k(Entity passenger) {
        double dist = (double)this.getSizeFactor() * 0.25;
        double newPosX = this.field_70165_t + dist * Math.sin(this.field_70761_aq / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.cos(this.field_70761_aq / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
    }

    @Override
    public void makeEntityJump() {
        this.wingFlap();
        super.makeEntityJump();
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.9f;
    }
}

