/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class MoCEntityTurtle
extends MoCEntityTameableAnimal {
    private static final DataParameter<Boolean> IS_UPSIDE_DOWN = EntityDataManager.func_187226_a(MoCEntityTurtle.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_HIDING = EntityDataManager.func_187226_a(MoCEntityTurtle.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final float TURTLE_ARMOR = 4.0f;
    private boolean isSwinging;
    private boolean twistright;
    private int flopcounter;

    public MoCEntityTurtle(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.425f);
        this.setAdult(true);
        this.setAge(90);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowOwnerPlayer((EntityLiving)this, 0.8, 2.0f, 10.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderMoC2((EntityCreature)this, 0.8, 50));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_UPSIDE_DOWN, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(IS_HIDING, (Object)Boolean.FALSE);
    }

    @Override
    public ResourceLocation getTexture() {
        String tempText = "turtle.png";
        if (MoCreatures.proxy.easterEggs) {
            if (this.getPetName().equals("Donatello") || this.getPetName().equals("donatello")) {
                tempText = "turtle_donatello.png";
            }
            if (this.getPetName().equals("Leonardo") || this.getPetName().equals("leonardo")) {
                tempText = "turtle_leonardo.png";
            }
            if (this.getPetName().equals("raphael") || this.getPetName().equals("Raphael")) {
                tempText = "turtle_raphael.png";
            }
            if (this.getPetName().equals("Michelangelo") || this.getPetName().equals("michelangelo")) {
                tempText = "turtle_michelangelo.png";
            }
        }
        return MoCreatures.proxy.getModelTexture(tempText);
    }

    public boolean getIsHiding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HIDING);
    }

    public void setIsHiding(boolean flag) {
        this.field_70180_af.func_187227_b(IS_HIDING, (Object)flag);
    }

    public boolean getIsUpsideDown() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_UPSIDE_DOWN);
    }

    public void setIsUpsideDown(boolean flag) {
        this.flopcounter = 0;
        this.field_70733_aJ = 0.0f;
        this.field_70180_af.func_187227_b(IS_UPSIDE_DOWN, (Object)flag);
    }

    public double func_70033_W() {
        if (this.func_184187_bx() instanceof EntityPlayer) {
            if (this.func_184187_bx().func_70093_af()) {
                return -0.25 + (300.0 - (double)this.getAge()) / 500.0;
            }
            return (300.0 - (double)this.getAge()) / 500.0;
        }
        return super.func_70033_W();
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        if (this.getIsTamed()) {
            if (this.getIsUpsideDown()) {
                this.flipflop(false);
                return true;
            }
            if (this.func_184187_bx() == null && this.startRidingPlayer(player)) {
                this.field_70177_z = player.field_70177_z;
            }
            return true;
        }
        this.flipflop(!this.getIsUpsideDown());
        return super.func_184645_a(player, hand);
    }

    protected void func_70664_aZ() {
        if (this.func_70055_a(Material.field_151586_h)) {
            this.field_70181_x = 0.3;
            if (this.func_70051_ag()) {
                float f = this.field_70177_z * 0.01745329f;
                this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
                this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
            }
            this.field_70160_al = true;
        }
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!(this.field_70170_p.field_72995_K || this.getIsUpsideDown() || this.getIsTamed())) {
            EntityLivingBase entityliving = this.getBoogey(4.0);
            if (entityliving != null && this.func_70685_l((Entity)entityliving)) {
                if (!this.getIsHiding() && !this.func_70090_H()) {
                    MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_TURTLE_HISS);
                    this.setIsHiding(true);
                }
                this.func_70661_as().func_75499_g();
            } else {
                EntityItem entityitem;
                this.setIsHiding(false);
                if (!this.func_70781_l() && this.field_70146_Z.nextInt(50) == 0 && (entityitem = this.getClosestItem((Entity)this, 10.0, Items.field_151127_ba, Items.field_151120_aE)) != null) {
                    float f = entityitem.func_70032_d((Entity)this);
                    if (f > 2.0f) {
                        this.setPathToEntity((Entity)entityitem, f);
                    }
                    if (f < 2.0f && this.field_70725_aQ == 0) {
                        entityitem.func_70106_y();
                        EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 24.0);
                        if (entityplayer != null) {
                            MoCTools.tameWithName(entityplayer, this);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        Entity entity = damagesource.func_76346_g();
        if (this.func_184187_bx() != null) {
            return false;
        }
        if (entity == null) {
            return super.func_70097_a(damagesource, i);
        }
        if (this.getIsHiding()) {
            float dmg = Math.max(i - 4.0f, 0.5f);
            boolean flag = super.func_70097_a(damagesource, dmg);
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.flipflop(true);
            }
            return flag;
        }
        boolean flag = super.func_70097_a(damagesource, i);
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.flipflop(true);
        }
        return flag;
    }

    public void flipflop(boolean flip) {
        this.setIsUpsideDown(flip);
        this.setIsHiding(false);
        this.func_70661_as().func_75499_g();
    }

    @Override
    public boolean entitiesToIgnore(Entity entity) {
        return entity instanceof MoCEntityTurtle || entity.field_70131_O <= this.field_70131_O && entity.field_70130_N <= this.field_70130_N || super.entitiesToIgnore(entity);
    }

    public void func_70071_h_() {
        EntityPlayer entityplayer;
        super.func_70071_h_();
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer && (entityplayer = (EntityPlayer)this.func_184187_bx()) != null) {
            this.field_70177_z = entityplayer.field_70177_z;
        }
        if (this.getIsTamed() && this.getAge() < 300 && this.field_70146_Z.nextInt(900) == 0) {
            this.setAge(this.getAge() + 1);
        }
        if (this.getIsUpsideDown() && this.func_70090_H()) {
            this.setIsUpsideDown(false);
        }
        if (this.getIsUpsideDown() && this.func_184187_bx() == null && this.field_70146_Z.nextInt(20) == 0) {
            this.setSwinging(true);
            ++this.flopcounter;
        }
        if (this.getIsSwinging()) {
            boolean flag;
            this.field_70733_aJ += 0.2f;
            boolean bl = flag = this.flopcounter > this.field_70146_Z.nextInt(3) + 8;
            if (this.field_70733_aJ > 2.0f && (!flag || this.field_70146_Z.nextInt(20) == 0)) {
                this.setSwinging(false);
                this.field_70733_aJ = 0.0f;
                if (this.field_70146_Z.nextInt(2) == 0) {
                    this.twistright = !this.twistright;
                }
            } else if (this.field_70733_aJ > 9.0f) {
                this.setSwinging(false);
                MoCTools.playCustomSound((Entity)this, SoundEvents.field_187665_Y);
                this.setIsUpsideDown(false);
            }
        }
    }

    public boolean getIsSwinging() {
        return this.isSwinging;
    }

    public void setSwinging(boolean flag) {
        this.isSwinging = flag;
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsUpsideDown() || this.getIsHiding();
    }

    public int getFlipDirection() {
        if (this.twistright) {
            return 1;
        }
        return -1;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setIsUpsideDown(nbttagcompound.func_74767_n("UpsideDown"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("UpsideDown", this.getIsUpsideDown());
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCSoundEvents.ENTITY_GENERIC_CLANG;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_TURTLE_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (!this.getIsAdult()) {
            return null;
        }
        return MoCLootTables.TURTLE;
    }

    public boolean isTMNT() {
        return this.getPetName().equals("Donatello") || this.getPetName().equals("donatello") || this.getPetName().equals("Leonardo") || this.getPetName().equals("leonardo") || this.getPetName().equals("Rafael") || this.getPetName().equals("rafael") || this.getPetName().equals("raphael") || this.getPetName().equals("Raphael") || this.getPetName().equals("Michelangelo") || this.getPetName().equals("michelangelo") || this.getPetName().equals("Michaelangelo") || this.getPetName().equals("michaelangelo");
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() == Items.field_151120_aE || stack.func_77973_b() == Items.field_151127_ba);
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public int nameYOffset() {
        return -10 - this.getAge() / 5;
    }

    @Override
    public boolean isAmphibian() {
        return true;
    }

    public float func_70689_ay() {
        if (this.func_70090_H()) {
            return 0.08f;
        }
        return 0.12f;
    }

    @Override
    protected double minDivingDepth() {
        return ((double)this.getAge() + 8.0) / 340.0;
    }

    @Override
    protected double maxDivingDepth() {
        return (double)this.getAge() / 100.0;
    }

    @Override
    public int getMaxAge() {
        return 120;
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.525f;
    }

    @Override
    public boolean isReadyToFollowOwnerPlayer() {
        return !this.isMovementCeased();
    }
}

