/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.tameable;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class MoCPetData {
    private final UUID ownerUniqueId;
    private final BitSet idMap = new BitSet(1024);
    private final Set<Integer> usedPetIds = new HashSet<Integer>();
    private NBTTagCompound ownerData = new NBTTagCompound();
    private NBTTagList tamedList = new NBTTagList();

    public MoCPetData(IMoCTameable pet) {
        this.ownerData.func_74782_a("TamedList", (NBTBase)this.tamedList);
        this.ownerUniqueId = MoCreatures.isServer() ? pet.getOwnerId() : Minecraft.func_71410_x().field_71439_g.func_110124_au();
    }

    public MoCPetData(NBTTagCompound nbt, UUID owner) {
        this.ownerData = nbt;
        this.tamedList = nbt.func_150295_c("TamedList", 10);
        this.ownerUniqueId = owner;
        this.loadPetDataMap(nbt.func_74775_l("PetIdData"));
    }

    public int addPet(IMoCTameable pet) {
        BlockPos coords = new BlockPos(((Entity)pet).field_70176_ah, ((Entity)pet).field_70162_ai, ((Entity)pet).field_70164_aj);
        NBTTagCompound petNBT = MoCTools.getEntityData((Entity)pet);
        if (this.tamedList != null) {
            int id = this.getNextFreePetId();
            petNBT.func_74768_a("PetId", id);
            NBTTagCompound petData = petNBT.func_74737_b();
            petData.func_74768_a("ChunkX", coords.func_177958_n());
            petData.func_74768_a("ChunkY", coords.func_177956_o());
            petData.func_74768_a("ChunkZ", coords.func_177952_p());
            petData.func_74768_a("Dimension", ((Entity)pet).field_70170_p.field_73011_w.func_186058_p().func_186068_a());
            this.tamedList.func_74742_a((NBTBase)petData);
            this.ownerData.func_74782_a("PetIdData", (NBTBase)this.savePetDataMap());
            return id;
        }
        return -1;
    }

    public boolean removePet(int id) {
        for (int i = this.tamedList.func_74745_c() - 1; i >= 0; --i) {
            NBTTagCompound nbt = this.tamedList.func_150305_b(i);
            if (!nbt.func_74764_b("PetId") || nbt.func_74762_e("PetId") != id) continue;
            this.tamedList.func_74744_a(i);
            this.usedPetIds.remove(id);
            this.idMap.clear(id);
            if (this.usedPetIds.isEmpty()) {
                this.idMap.clear();
            }
            this.ownerData.func_74782_a("PetIdData", (NBTBase)this.savePetDataMap());
            return true;
        }
        return false;
    }

    public NBTTagCompound getPetData(int id) {
        if (this.tamedList != null) {
            for (int i = 0; i < this.tamedList.func_74745_c(); ++i) {
                NBTTagCompound nbt = this.tamedList.func_150305_b(i);
                if (!nbt.func_74764_b("PetId") || nbt.func_74762_e("PetId") != id) continue;
                return nbt;
            }
        }
        return null;
    }

    public NBTTagCompound getOwnerRootNBT() {
        return this.ownerData;
    }

    public NBTTagList getTamedList() {
        return this.tamedList;
    }

    public String getOwner() {
        if (this.ownerData != null) {
            return this.ownerData.func_74779_i("Owner");
        }
        return null;
    }

    public boolean getInAmulet(int petId) {
        NBTTagCompound petData = this.getPetData(petId);
        if (petData != null) {
            return petData.func_74767_n("InAmulet");
        }
        return false;
    }

    public void setInAmulet(int petId, boolean flag) {
        NBTTagCompound petData = this.getPetData(petId);
        if (petData != null) {
            petData.func_74757_a("InAmulet", flag);
        }
    }

    public int getNextFreePetId() {
        int next = 0;
        while (this.usedPetIds.contains(next = this.idMap.nextClearBit(next))) {
            this.idMap.set(next);
        }
        this.usedPetIds.add(next);
        return next;
    }

    public NBTTagCompound savePetDataMap() {
        int[] data = new int[(this.idMap.length() + 32 - 1) / 32];
        NBTTagCompound dataMap = new NBTTagCompound();
        for (int i = 0; i < data.length; ++i) {
            int val = 0;
            for (int j = 0; j < 32; ++j) {
                val |= this.idMap.get(i * 32 + j) ? 1 << j : 0;
            }
            data[i] = val;
        }
        dataMap.func_74783_a("PetIdArray", data);
        return dataMap;
    }

    public void loadPetDataMap(NBTTagCompound compoundTag) {
        if (compoundTag == null) {
            this.idMap.clear();
        } else {
            int[] intArray = compoundTag.func_74759_k("PetIdArray");
            for (int i = 0; i < intArray.length; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.idMap.set(i * 32 + j, (intArray[i] & 1 << j) != 0);
                }
            }
            int next = 0;
            while (!this.usedPetIds.contains(next = this.idMap.nextClearBit(next))) {
                this.usedPetIds.add(next);
            }
        }
    }
}

