/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.event;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.init.MoCEntities;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MoCEventHooksTerrain {
    public static List<Biome.SpawnListEntry> creatureList = new ArrayList<Biome.SpawnListEntry>();
    public static List<Biome.SpawnListEntry> waterCreatureList = new ArrayList<Biome.SpawnListEntry>();
    public static Object2ObjectOpenHashMap<Biome, List<Biome.SpawnListEntry>> creatureSpawnMap = new Object2ObjectOpenHashMap();
    public static Object2ObjectOpenHashMap<Biome, List<Biome.SpawnListEntry>> waterCreatureSpawnMap = new Object2ObjectOpenHashMap();

    public static void buildWorldGenSpawnLists() {
        for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
            creatureList = new ArrayList<Biome.SpawnListEntry>(biome.func_76747_a(EnumCreatureType.CREATURE));
            creatureList.removeIf(entry -> entry.field_76292_a == 0 || !IMoCEntity.class.isAssignableFrom(entry.field_76300_b));
            creatureSpawnMap.put((Object)biome, creatureList);
            waterCreatureList = new ArrayList<Biome.SpawnListEntry>(biome.func_76747_a(EnumCreatureType.WATER_CREATURE));
            waterCreatureList.removeIf(entry -> entry.field_76292_a == 0 || !IMoCEntity.class.isAssignableFrom(entry.field_76300_b));
            waterCreatureSpawnMap.put((Object)biome, waterCreatureList);
        }
    }

    public static void addBiomeTypes() {
        ResourceLocation aridHighland;
        BiomeDictionary.addTypes((Biome)Biomes.field_76770_e, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{MoCEntities.STEEP});
        BiomeDictionary.addTypes((Biome)Biomes.field_76783_v, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{MoCEntities.STEEP});
        BiomeDictionary.addTypes((Biome)Biomes.field_185443_S, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{MoCEntities.STEEP});
        BiomeDictionary.addTypes((Biome)Biomes.field_185434_af, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{MoCEntities.STEEP});
        BiomeDictionary.addTypes((Biome)Biomes.field_185437_ai, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MESA});
        BiomeDictionary.addTypes((Biome)Biomes.field_185438_aj, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MESA});
        BiomeDictionary.addTypes((Biome)Biomes.field_185439_ak, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MESA});
        ResourceLocation rockyPlateau = new ResourceLocation("traverse:rocky_plateau");
        if (ForgeRegistries.BIOMES.containsKey(rockyPlateau)) {
            BiomeDictionary.addTypes((Biome)((Biome)ForgeRegistries.BIOMES.getValue(rockyPlateau)), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        }
        if (ForgeRegistries.BIOMES.containsKey(aridHighland = new ResourceLocation("traverse:arid_highland"))) {
            BiomeDictionary.addTypes((Biome)((Biome)ForgeRegistries.BIOMES.getValue(aridHighland)), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SAVANNA});
        }
    }

    @SubscribeEvent
    public void onPopulateChunk(PopulateChunkEvent.Populate event) {
        if (!MoCreatures.proxy.worldGenSpawningCreatures && !MoCreatures.proxy.worldGenSpawningWaterCreatures) {
            return;
        }
        if (event.getType() == PopulateChunkEvent.Populate.EventType.ANIMALS) {
            int chunkX = event.getChunkX() * 16;
            int chunkZ = event.getChunkZ() * 16;
            int centerX = chunkX + 8;
            int centerZ = chunkZ + 8;
            World world = event.getWorld();
            Random rand = event.getRand();
            BlockPos blockPos = new BlockPos(chunkX, 0, chunkZ);
            Biome biome = world.func_180494_b(blockPos.func_177982_a(16, 0, 16));
            if (MoCreatures.proxy.worldGenSpawningCreatures) {
                MoCTools.performCustomWorldGenSpawning(world, biome, centerX, centerZ, 16, 16, rand, (List)creatureSpawnMap.get((Object)biome), EntityLiving.SpawnPlacementType.ON_GROUND);
            }
            if (MoCreatures.proxy.worldGenSpawningWaterCreatures) {
                MoCTools.performCustomWorldGenSpawning(world, biome, centerX, centerZ, 16, 16, rand, (List)waterCreatureSpawnMap.get((Object)biome), EntityLiving.SpawnPlacementType.IN_WATER);
            }
        }
    }
}

