/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.hunter.MoCEntityPetScorpion;
import drzhark.mocreatures.entity.neutral.MoCEntityElephant;
import drzhark.mocreatures.entity.neutral.MoCEntityKitty;
import drzhark.mocreatures.entity.neutral.MoCEntityOstrich;
import drzhark.mocreatures.entity.neutral.MoCEntityWyvern;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.item.MoCItemSword;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MoCItemWhip
extends MoCItemSword {
    private float AttackSpeed;

    public MoCItemWhip(String name, Item.ToolMaterial material, float attackSpeedIn) {
        super(name, 0, material);
        this.field_77777_bU = 1;
        this.AttackSpeed = attackSpeedIn;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        Block block1 = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (side != EnumFacing.DOWN && block1 == Blocks.field_150350_a && block != Blocks.field_150350_a && block != Blocks.field_150472_an) {
            this.whipFX(worldIn, pos);
            worldIn.func_184133_a(player, pos, MoCSoundEvents.ENTITY_GENERIC_WHIP, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            player.func_184811_cZ().func_185145_a((Item)this, 20);
            stack.func_77972_a(2, (EntityLivingBase)player);
            List list = worldIn.func_72839_b((Entity)player, player.func_174813_aQ().func_186662_g(12.0));
            for (Entity entity : list) {
                MoCEntityElephant entityelephant;
                MoCEntityPetScorpion petscorpion;
                MoCEntityWyvern entitywyvern;
                MoCEntityKitty entitykitty;
                MoCEntityHorse entityhorse;
                if (entity instanceof MoCEntityAnimal) {
                    MoCEntityAnimal animal = (MoCEntityAnimal)entity;
                    if (MoCreatures.proxy.enableOwnership && animal.getOwnerId() != null && !player.func_110124_au().equals(animal.getOwnerId()) && !MoCTools.isThisPlayerAnOP(player)) continue;
                }
                if (entity instanceof MoCEntityBigCat) {
                    MoCEntityBigCat entitybigcat = (MoCEntityBigCat)entity;
                    if (entitybigcat.getIsTamed()) {
                        entitybigcat.setSitting(!entitybigcat.getIsSitting());
                        entitybigcat.setIsJumping(false);
                        entitybigcat.func_70661_as().func_75499_g();
                        entitybigcat.func_70624_b(null);
                    } else if (worldIn.func_175659_aa().func_151525_a() > 0 && entitybigcat.getIsAdult()) {
                        entitybigcat.func_70624_b((EntityLivingBase)player);
                    }
                }
                if (entity instanceof MoCEntityHorse && (entityhorse = (MoCEntityHorse)entity).getIsTamed()) {
                    if (entityhorse.func_184187_bx() == null) {
                        entityhorse.setSitting(!entityhorse.getIsSitting());
                        entityhorse.setIsJumping(false);
                        entityhorse.func_70661_as().func_75499_g();
                        entityhorse.func_70624_b(null);
                    } else if (entityhorse.isNightmare()) {
                        entityhorse.setNightmareInt(100);
                    } else if (entityhorse.sprintCounter == 0) {
                        entityhorse.sprintCounter = 1;
                    }
                }
                if (entity instanceof MoCEntityKitty && (entitykitty = (MoCEntityKitty)entity).getKittyState() > 2 && entitykitty.whipable()) {
                    entitykitty.setSitting(!entitykitty.getIsSitting());
                    entitykitty.setIsJumping(false);
                    entitykitty.func_70661_as().func_75499_g();
                    entitykitty.func_70624_b(null);
                }
                if (entity instanceof MoCEntityWyvern && (entitywyvern = (MoCEntityWyvern)entity).getIsTamed() && entitywyvern.func_184187_bx() == null && !entitywyvern.isOnAir()) {
                    entitywyvern.setSitting(!entitywyvern.getIsSitting());
                    entitywyvern.setIsJumping(false);
                    entitywyvern.func_70661_as().func_75499_g();
                    entitywyvern.func_70624_b(null);
                }
                if (entity instanceof MoCEntityPetScorpion && (petscorpion = (MoCEntityPetScorpion)entity).getIsTamed() && petscorpion.func_184187_bx() == null) {
                    petscorpion.setSitting(!petscorpion.getIsSitting());
                    petscorpion.setIsJumping(false);
                    petscorpion.func_70661_as().func_75499_g();
                    petscorpion.func_70624_b(null);
                }
                if (entity instanceof MoCEntityOstrich) {
                    MoCEntityOstrich entityostrich = (MoCEntityOstrich)entity;
                    if (entityostrich.func_184207_aI() && entityostrich.sprintCounter == 0) {
                        entityostrich.sprintCounter = 1;
                    }
                    if (entityostrich.getIsTamed() && entityostrich.func_184187_bx() == null) {
                        entityostrich.setHiding(!entityostrich.getHiding());
                        entityostrich.setIsJumping(false);
                        entityostrich.func_70661_as().func_75499_g();
                        entityostrich.func_70624_b(null);
                    }
                }
                if (!(entity instanceof MoCEntityElephant) || !(entityelephant = (MoCEntityElephant)entity).func_184207_aI() || entityelephant.sprintCounter != 0) continue;
                entityelephant.sprintCounter = 1;
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        target.func_184185_a(MoCSoundEvents.ENTITY_GENERIC_WHIP, 0.5f, 2.0f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        return super.func_77644_a(stack, target, attacker);
    }

    public void whipFX(World world, BlockPos pos) {
        double d = (float)pos.func_177958_n() + 0.5f;
        double d1 = (float)pos.func_177956_o() + 1.0f;
        double d2 = (float)pos.func_177952_p() + 0.5f;
        double d3 = 0.22f;
        double d4 = 0.27f;
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d - d4, d1 + d3, d2, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.FLAME, d - d4, d1 + d3, d2, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d + d4, d1 + d3, d2, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.FLAME, d + d4, d1 + d3, d2, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.FLAME, d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.FLAME, d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.FLAME, d, d1, d2, 0.0, 0.0, 0.0, new int[0]);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Damage modifier", (double)this.func_150931_i(), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Speed modifier", (double)this.AttackSpeed - 4.0, 0));
        }
        return multimap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"info.mocreatures.whip", (Object[])new Object[0]));
    }
}

