/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.command;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CommandMoCTP
extends CommandBase {
    private static final List<String> commands = new ArrayList<String>();
    private static final List<String> aliases = new ArrayList<String>();

    public String func_71517_b() {
        return "moctp";
    }

    public List<String> func_71514_a() {
        return aliases;
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "commands.moctp.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        int petId;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Error" + TextFormatting.WHITE + ": You must enter a valid entity ID.", new Object[0]));
            return;
        }
        if (!(sender instanceof EntityPlayer)) {
            return;
        }
        try {
            petId = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            petId = -1;
        }
        String playername = sender.func_70005_c_();
        EntityPlayer player = (EntityPlayer)sender;
        MoCPetData ownerPetData = MoCreatures.instance.mapData.getPetData(player.func_110124_au());
        if (ownerPetData != null) {
            for (int i = 0; i < ownerPetData.getTamedList().func_74745_c(); ++i) {
                NBTTagCompound nbt = ownerPetData.getTamedList().func_150305_b(i);
                if (!nbt.func_74764_b("PetId") || nbt.func_74762_e("PetId") != petId) continue;
                String petName = nbt.func_74779_i("Name");
                WorldServer world = DimensionManager.getWorld((int)nbt.func_74762_e("Dimension"));
                if (this.teleportLoadedPet(world, player, petId, petName, sender)) break;
                double posX = nbt.func_150295_c("Pos", 6).func_150309_d(0);
                double posY = nbt.func_150295_c("Pos", 6).func_150309_d(1);
                double posZ = nbt.func_150295_c("Pos", 6).func_150309_d(2);
                int x = MathHelper.func_76128_c((double)posX);
                int y = MathHelper.func_76128_c((double)posY);
                int z = MathHelper.func_76128_c((double)posZ);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Found unloaded pet " + TextFormatting.GREEN + nbt.func_74779_i("id") + TextFormatting.WHITE + " with name " + TextFormatting.AQUA + nbt.func_74779_i("Name") + TextFormatting.WHITE + " at location " + TextFormatting.LIGHT_PURPLE + x + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + y + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + z + TextFormatting.WHITE + " with Pet ID " + TextFormatting.BLUE + nbt.func_74762_e("PetId"), new Object[0]));
                boolean result = this.teleportLoadedPet(world, player, petId, petName, sender);
                if (!result) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Unable to transfer entity ID " + TextFormatting.GREEN + petId + TextFormatting.WHITE + ". It may only be transferred to " + TextFormatting.AQUA + player.func_70005_c_(), new Object[0]));
                }
                break;
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Tamed entity could not be located.", new Object[0]));
        }
    }

    protected List<String> getSortedPossibleCommands(ICommandSender par1ICommandSender) {
        Collections.sort(commands);
        return commands;
    }

    public boolean teleportLoadedPet(WorldServer world, EntityPlayer player, int petId, String petName, ICommandSender par1ICommandSender) {
        for (int j = 0; j < world.field_72996_f.size(); ++j) {
            Entity entity = (Entity)world.field_72996_f.get(j);
            if (!IMoCTameable.class.isAssignableFrom(entity.getClass()) || ((IMoCTameable)entity).getPetName().equals("") || ((IMoCTameable)entity).getOwnerPetId() != petId) continue;
            NBTTagCompound compound = new NBTTagCompound();
            entity.func_189511_e(compound);
            if (compound.func_82582_d() || compound.func_74779_i("Owner").isEmpty()) continue;
            String owner = compound.func_74779_i("Owner");
            String name = compound.func_74779_i("Name");
            if (owner.isEmpty() || !owner.equalsIgnoreCase(player.func_70005_c_())) continue;
            if (entity.field_71093_bK == player.field_71093_bK) {
                entity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            } else if (!player.field_70170_p.field_72995_K) {
                Entity newEntity = EntityList.func_191304_a(entity.getClass(), (World)player.field_70170_p);
                if (newEntity != null) {
                    MoCTools.copyDataFromOld(newEntity, entity);
                    newEntity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    DimensionManager.getWorld((int)player.field_71093_bK).func_72838_d(newEntity);
                }
                if (entity.func_184187_bx() != null) {
                    entity.func_184187_bx().func_184210_p();
                }
                entity.field_70128_L = true;
                world.func_82742_i();
                DimensionManager.getWorld((int)player.field_71093_bK).func_82742_i();
            }
            par1ICommandSender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + name + TextFormatting.WHITE + " has been tp'd to location " + Math.round(player.field_70165_t) + ", " + Math.round(player.field_70163_u) + ", " + Math.round(player.field_70161_v) + " in dimension " + player.field_71093_bK, new Object[0]));
            return true;
        }
        return false;
    }

    public void sendCommandHelp(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a72Listing MoCreatures commands", new Object[0]));
        for (String command : commands) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(command, new Object[0]));
        }
    }

    static {
        commands.add("/moctp <entityid> <playername>");
        commands.add("/moctp <petname> <playername>");
        aliases.add("moctp");
    }
}

