/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.command;

import com.mojang.authlib.GameProfile;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.config.MoCConfigCategory;
import drzhark.mocreatures.config.MoCConfiguration;
import drzhark.mocreatures.config.MoCProperty;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.MoCEntityData;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandMoCreatures
extends CommandBase {
    private static final List<String> commands = new ArrayList<String>();
    private static final List<String> aliases = new ArrayList<String>();
    private static final List<String> tabCompletionStrings = new ArrayList<String>();

    public String func_71517_b() {
        return "mocreatures";
    }

    public List<String> func_71514_a() {
        return aliases;
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "commands.mocreatures.usage";
    }

    public List<String> addTabCompletionOptions(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        return CommandMoCreatures.func_71530_a((String[])par2ArrayOfStr, (String[])tabCompletionStrings.toArray(new String[0]));
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        boolean saved;
        MoCConfiguration config;
        String command;
        block91: {
            IMoCEntity mocreature;
            command = args.length == 0 ? "help" : args[0];
            String par2 = "";
            if (args.length > 1) {
                par2 = args[1];
            }
            String par3 = "";
            if (args.length == 3) {
                par3 = args[2];
            }
            config = MoCreatures.proxy.mocSettingsConfig;
            saved = false;
            if (command.equalsIgnoreCase("tamed") || command.equalsIgnoreCase("tame")) {
                ArrayList<Integer> foundIds;
                if (args.length == 2 && !Character.isDigit(args[1].charAt(0))) {
                    int unloadedCount = 0;
                    int loadedCount = 0;
                    foundIds = new ArrayList();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    GameProfile profile = server.func_152358_ax().func_152655_a(par2);
                    if (profile == null) {
                        return;
                    }
                    Integer[] integerArray = DimensionManager.getIDs();
                    int n = integerArray.length;
                    for (int i = 0; i < n; ++i) {
                        int dimension = integerArray[i];
                        WorldServer world = DimensionManager.getWorld((int)dimension);
                        for (int j = 0; j < world.field_72996_f.size(); ++j) {
                            IMoCTameable mocreature2;
                            Entity entity = (Entity)world.field_72996_f.get(j);
                            if (!IMoCTameable.class.isAssignableFrom(entity.getClass()) || !(mocreature2 = (IMoCTameable)entity).getOwnerId().equals(profile.getId())) continue;
                            ++loadedCount;
                            foundIds.add(mocreature2.getOwnerPetId());
                            arrayList.add(TextFormatting.WHITE + "Found pet with " + TextFormatting.DARK_AQUA + "Type" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + ((EntityLiving)mocreature2).func_70005_c_() + TextFormatting.DARK_AQUA + ", Name" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + mocreature2.getPetName() + TextFormatting.DARK_AQUA + ", Owner" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + profile.getName() + TextFormatting.DARK_AQUA + ", PetId" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + mocreature2.getOwnerPetId() + TextFormatting.DARK_AQUA + ", Dimension" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + entity.field_71093_bK + TextFormatting.DARK_AQUA + ", Pos" + TextFormatting.WHITE + ":" + TextFormatting.LIGHT_PURPLE + Math.round(entity.field_70165_t) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(entity.field_70163_u) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(entity.field_70161_v));
                        }
                    }
                    MoCPetData ownerPetData = MoCreatures.instance.mapData.getPetData(profile.getId());
                    if (ownerPetData != null) {
                        for (int i = 0; i < ownerPetData.getTamedList().func_74745_c(); ++i) {
                            NBTTagCompound nbt = ownerPetData.getTamedList().func_150305_b(i);
                            if (!nbt.func_74764_b("PetId") || foundIds.contains(nbt.func_74762_e("PetId"))) continue;
                            ++unloadedCount;
                            double posX = nbt.func_150295_c("Pos", 6).func_150309_d(0);
                            double posY = nbt.func_150295_c("Pos", 6).func_150309_d(1);
                            double posZ = nbt.func_150295_c("Pos", 6).func_150309_d(2);
                            arrayList.add(TextFormatting.WHITE + "Found unloaded pet with " + TextFormatting.DARK_AQUA + "Type" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("EntityName") + TextFormatting.DARK_AQUA + ", Name" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("Name") + TextFormatting.DARK_AQUA + ", Owner" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("Owner") + TextFormatting.DARK_AQUA + ", PetId" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74762_e("PetId") + TextFormatting.DARK_AQUA + ", Dimension" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74762_e("Dimension") + TextFormatting.DARK_AQUA + ", Pos" + TextFormatting.WHITE + ":" + TextFormatting.LIGHT_PURPLE + Math.round(posX) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(posY) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(posZ));
                        }
                    }
                    if (arrayList.size() > 0) {
                        this.sendPageHelp(sender, (byte)10, arrayList, args, "Listing tamed pets");
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("Loaded tamed count : " + TextFormatting.AQUA + loadedCount + TextFormatting.WHITE + ", Unloaded count : " + TextFormatting.AQUA + unloadedCount + TextFormatting.WHITE + ", Total count : " + TextFormatting.AQUA + (ownerPetData != null ? ownerPetData.getTamedList().func_74745_c() : 0), new Object[0]));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("Player " + TextFormatting.GREEN + par2 + TextFormatting.WHITE + " does not have any tamed animals.", new Object[0]));
                    }
                } else if (command.equalsIgnoreCase("tamed") || command.equalsIgnoreCase("tame") && !par2.equals("")) {
                    int i;
                    int unloadedCount = 0;
                    int loadedCount = 0;
                    foundIds = new ArrayList<Integer>();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ObjectIterator profile = DimensionManager.getIDs();
                    int ownerPetData = ((Integer[])profile).length;
                    for (i = 0; i < ownerPetData; ++i) {
                        int dimension = profile[i];
                        WorldServer world = DimensionManager.getWorld((int)dimension);
                        for (int j = 0; j < world.field_72996_f.size(); ++j) {
                            Entity entity = (Entity)world.field_72996_f.get(j);
                            if (!IMoCTameable.class.isAssignableFrom(entity.getClass()) || (mocreature = (IMoCTameable)entity).getOwnerPetId() == -1) continue;
                            ++loadedCount;
                            foundIds.add(mocreature.getOwnerPetId());
                            arrayList.add(TextFormatting.WHITE + "Found pet with " + TextFormatting.DARK_AQUA + "Type" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + ((EntityLiving)mocreature).func_70005_c_() + TextFormatting.DARK_AQUA + ", Name" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + mocreature.getPetName() + TextFormatting.DARK_AQUA + ", Owner" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + mocreature.getOwnerId() + TextFormatting.DARK_AQUA + ", PetId" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + mocreature.getOwnerPetId() + TextFormatting.DARK_AQUA + ", Dimension" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + entity.field_71093_bK + TextFormatting.DARK_AQUA + ", Pos" + TextFormatting.WHITE + ":" + TextFormatting.LIGHT_PURPLE + Math.round(entity.field_70165_t) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(entity.field_70163_u) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(entity.field_70161_v));
                        }
                    }
                    for (MoCPetData ownerPetData2 : MoCreatures.instance.mapData.getPetMap().values()) {
                        for (i = 0; i < ownerPetData2.getTamedList().func_74745_c(); ++i) {
                            NBTTagCompound nbt = ownerPetData2.getTamedList().func_150305_b(i);
                            if (!nbt.func_74764_b("PetId") || foundIds.contains(nbt.func_74762_e("PetId"))) continue;
                            ++unloadedCount;
                            double posX = nbt.func_150295_c("Pos", 10).func_150309_d(0);
                            double posY = nbt.func_150295_c("Pos", 10).func_150309_d(1);
                            double posZ = nbt.func_150295_c("Pos", 10).func_150309_d(2);
                            arrayList.add(TextFormatting.WHITE + "Found unloaded pet with " + TextFormatting.DARK_AQUA + "Type" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("EntityName") + TextFormatting.DARK_AQUA + ", Name" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("Name") + TextFormatting.DARK_AQUA + ", Owner" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("Owner") + TextFormatting.DARK_AQUA + ", PetId" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74762_e("PetId") + TextFormatting.DARK_AQUA + ", Dimension" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74762_e("Dimension") + TextFormatting.DARK_AQUA + ", Pos" + TextFormatting.WHITE + ":" + TextFormatting.LIGHT_PURPLE + Math.round(posX) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(posY) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(posZ));
                        }
                    }
                    this.sendPageHelp(sender, (byte)10, arrayList, args, "Listing tamed pets");
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Loaded tamed count : " + TextFormatting.AQUA + loadedCount + TextFormatting.WHITE + (!MoCreatures.isServer() ? ", Unloaded Count : " + TextFormatting.AQUA + unloadedCount + TextFormatting.WHITE + ", Total count : " + TextFormatting.AQUA + (loadedCount + unloadedCount) : ""), new Object[0]));
                }
            } else if (command.equalsIgnoreCase("tp") && args.length == 3) {
                int petId;
                try {
                    petId = Integer.parseInt(par2);
                }
                catch (NumberFormatException e) {
                    petId = -1;
                }
                String playername = args[2];
                EntityPlayerMP player2 = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playername);
                if (player2 == null) {
                    return;
                }
                MoCPetData moCPetData = MoCreatures.instance.mapData.getPetData(player2.func_110124_au());
                if (moCPetData != null) {
                    for (int i = 0; i < moCPetData.getTamedList().func_74745_c(); ++i) {
                        NBTTagCompound nbt = moCPetData.getTamedList().func_150305_b(i);
                        if (!nbt.func_74764_b("PetId") || nbt.func_74762_e("PetId") != petId) continue;
                        String petName = nbt.func_74779_i("Name");
                        WorldServer world = DimensionManager.getWorld((int)nbt.func_74762_e("Dimension"));
                        if (this.teleportLoadedPet(world, player2, petId, petName, sender)) break;
                        double posX = nbt.func_150295_c("Pos", 10).func_150309_d(0);
                        double posY = nbt.func_150295_c("Pos", 10).func_150309_d(1);
                        double posZ = nbt.func_150295_c("Pos", 10).func_150309_d(2);
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("Found unloaded pet " + TextFormatting.GREEN + nbt.func_74779_i("id") + TextFormatting.WHITE + " with name " + TextFormatting.AQUA + nbt.func_74779_i("Name") + TextFormatting.WHITE + " at location " + TextFormatting.LIGHT_PURPLE + Math.round(posX) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(posY) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(posZ) + TextFormatting.WHITE + " with Pet ID " + TextFormatting.BLUE + nbt.func_74762_e("PetId"), new Object[0]));
                        boolean result = this.teleportLoadedPet(world, player2, petId, petName, sender);
                        if (!result) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Unable to transfer entity ID " + TextFormatting.GREEN + petId + TextFormatting.WHITE + ". It may only be transferred to " + TextFormatting.AQUA + player2.func_70005_c_(), new Object[0]));
                        }
                        break;
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Tamed entity could not be located.", new Object[0]));
                }
            } else if (command.equalsIgnoreCase("tamedcount")) {
                List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
                for (EntityPlayerMP player : players) {
                    if (!player.func_70005_c_().equalsIgnoreCase(par2)) continue;
                    int n = MoCTools.numberTamedByPlayer((EntityPlayer)player);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + par2 + "'s recorded tamed count is " + TextFormatting.AQUA + n, new Object[0]));
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Could not find player " + TextFormatting.GREEN + par2 + TextFormatting.RED + ". Please verify the player is online and/or name was entered correctly.", new Object[0]));
            } else if (command.equalsIgnoreCase("growup") && args.length == 2) {
                int petId;
                EntityPlayerMP player;
                try {
                    petId = Integer.parseInt(par2);
                }
                catch (NumberFormatException e) {
                    petId = -1;
                }
                String playername = sender.func_70005_c_();
                player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playername);
                if (player == null) {
                    return;
                }
                MoCPetData moCPetData = MoCreatures.instance.mapData.getPetData(player.func_110124_au());
                if (moCPetData != null) {
                    boolean found = false;
                    block29: for (int i = 0; i < moCPetData.getTamedList().func_74745_c(); ++i) {
                        NBTTagCompound nbt = moCPetData.getTamedList().func_150305_b(i);
                        if (!nbt.func_74764_b("PetId") || nbt.func_74762_e("PetId") != petId) continue;
                        String petName = nbt.func_74779_i("Name");
                        WorldServer world = DimensionManager.getWorld((int)nbt.func_74762_e("Dimension"));
                        for (int j = 0; j < world.field_72996_f.size(); ++j) {
                            Entity entity = (Entity)world.field_72996_f.get(j);
                            if (!MoCEntityAnimal.class.isAssignableFrom(entity.getClass()) || ((MoCEntityAnimal)(mocreature = (MoCEntityAnimal)entity)).getOwnerPetId() != petId) continue;
                            found = true;
                            if (((MoCEntityAnimal)mocreature).getIsAdult()) {
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Pet " + TextFormatting.GREEN + petId + TextFormatting.WHITE + " named " + TextFormatting.GREEN + petName + TextFormatting.WHITE + " is already an adult.", new Object[0]));
                                break block29;
                            }
                            ((MoCEntityAnimal)mocreature).setAge(((MoCEntityAnimal)mocreature).getMaxAge());
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Pet " + TextFormatting.GREEN + petId + TextFormatting.WHITE + " named " + TextFormatting.GREEN + petName + TextFormatting.WHITE + " has been grown up.", new Object[0]));
                            break block29;
                        }
                        break;
                    }
                    if (!found) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("Tamed entity with ID " + TextFormatting.GREEN + petId + TextFormatting.WHITE + "could not be located.", new Object[0]));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Tamed entity with ID " + TextFormatting.GREEN + petId + TextFormatting.WHITE + "could not be located.", new Object[0]));
                }
            } else if (args.length >= 2 && (command.equalsIgnoreCase("frequency") || command.equalsIgnoreCase("minspawn") || command.equalsIgnoreCase("maxspawn") || command.equalsIgnoreCase("maxchunk") || command.equalsIgnoreCase("canspawn"))) {
                MoCEntityData entityData = (MoCEntityData)MoCreatures.mocEntityMap.get((Object)par2);
                if (entityData != null) {
                    MoCProperty prop;
                    if (command.equalsIgnoreCase("frequency")) {
                        if (par3 == null) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " frequency is " + TextFormatting.AQUA + entityData.getFrequency() + TextFormatting.WHITE + ".", new Object[0]));
                        } else {
                            try {
                                entityData.setFrequency(Integer.parseInt(par3));
                                prop = MoCreatures.proxy.mocEntityConfig.get(entityData.getEntityName(), "frequency");
                                prop.value = par3;
                                saved = true;
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " frequency to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                            }
                            catch (NumberFormatException ex) {
                                this.sendCommandHelp(sender);
                            }
                        }
                    } else if (command.equalsIgnoreCase("min") || command.equalsIgnoreCase("minspawn")) {
                        if (par3 == null) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " minGroupSpawn is " + TextFormatting.AQUA + entityData.getMinSpawn() + TextFormatting.WHITE + ".", new Object[0]));
                        } else {
                            try {
                                entityData.setMinSpawn(Integer.parseInt(par3));
                                prop = MoCreatures.proxy.mocEntityConfig.get(entityData.getEntityName(), "minspawn");
                                prop.value = par3;
                                saved = true;
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " minGroupSpawn to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                            }
                            catch (NumberFormatException ex) {
                                this.sendCommandHelp(sender);
                            }
                        }
                    } else if (command.equalsIgnoreCase("max") || command.equalsIgnoreCase("maxspawn")) {
                        if (par3 == null) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " maxGroupSpawn is " + TextFormatting.AQUA + entityData.getMaxSpawn() + TextFormatting.WHITE + ".", new Object[0]));
                        } else {
                            try {
                                entityData.setMaxSpawn(Integer.parseInt(par3));
                                prop = MoCreatures.proxy.mocEntityConfig.get(entityData.getEntityName(), "maxspawn");
                                prop.value = par3;
                                saved = true;
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " maxGroupSpawn to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                            }
                            catch (NumberFormatException ex) {
                                this.sendCommandHelp(sender);
                            }
                        }
                    } else if (command.equalsIgnoreCase("chunk") || command.equalsIgnoreCase("maxchunk")) {
                        if (par3 == null) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " maxInChunk is " + TextFormatting.AQUA + entityData.getMaxInChunk() + TextFormatting.WHITE + ".", new Object[0]));
                        } else {
                            try {
                                entityData.setMaxSpawn(Integer.parseInt(par3));
                                prop = MoCreatures.proxy.mocEntityConfig.get(entityData.getEntityName(), "maxchunk");
                                prop.value = par3;
                                saved = true;
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " maxInChunk to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                            }
                            catch (NumberFormatException ex) {
                                this.sendCommandHelp(sender);
                            }
                        }
                    } else if (command.equalsIgnoreCase("canspawn")) {
                        if (par3 == null) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " canSpawn is " + TextFormatting.AQUA + entityData.getCanSpawn() + TextFormatting.WHITE + ".", new Object[0]));
                        } else {
                            try {
                                entityData.setCanSpawn(Boolean.parseBoolean(par3));
                                prop = MoCreatures.proxy.mocEntityConfig.get(entityData.getEntityName(), "canspawn");
                                prop.set(par3);
                                saved = true;
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " canSpawn to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                            }
                            catch (NumberFormatException ex) {
                                this.sendCommandHelp(sender);
                            }
                        }
                    }
                }
            } else if (args.length == 1) {
                for (Map.Entry catEntry : config.categories.entrySet()) {
                    String catName = ((MoCConfigCategory)catEntry.getValue()).getQualifiedName();
                    if (catName.equalsIgnoreCase("custom-id-settings")) continue;
                    for (Map.Entry<String, MoCProperty> propEntry : ((MoCConfigCategory)catEntry.getValue()).entrySet()) {
                        if (propEntry.getValue() == null || !propEntry.getKey().equalsIgnoreCase(command)) continue;
                        List<String> propList = propEntry.getValue().valueList;
                        String propValue = propEntry.getValue().value;
                        if (propList == null && propValue == null || !par2.equals("")) continue;
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + propEntry.getKey() + TextFormatting.WHITE + " is " + TextFormatting.AQUA + propValue, new Object[0]));
                        break block91;
                    }
                }
            } else {
                for (Map.Entry catEntry : config.categories.entrySet()) {
                    for (Map.Entry entry : ((MoCConfigCategory)catEntry.getValue()).entrySet()) {
                        if (entry.getValue() == null || !((String)entry.getKey()).equalsIgnoreCase(command)) continue;
                        MoCProperty property = (MoCProperty)entry.getValue();
                        List<String> propList = ((MoCProperty)entry.getValue()).valueList;
                        String propValue = ((MoCProperty)entry.getValue()).getString();
                        if (propList == null && propValue == null) continue;
                        if (((MoCProperty)entry.getValue()).getType() == MoCProperty.Type.BOOLEAN) {
                            if (!par2.equalsIgnoreCase("true") && !par2.equalsIgnoreCase("false")) continue;
                            property.set(par2);
                            saved = true;
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + (String)entry.getKey() + " to " + TextFormatting.AQUA + par2 + ".", new Object[0]));
                            continue;
                        }
                        if (((MoCProperty)entry.getValue()).getType() == MoCProperty.Type.INTEGER) {
                            try {
                                Integer.parseInt(par2);
                                property.set(par2);
                                saved = true;
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + (String)entry.getKey() + " to " + TextFormatting.AQUA + par2 + ".", new Object[0]));
                            }
                            catch (NumberFormatException ex) {
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Invalid value entered. Please enter a valid number.", new Object[0]));
                            }
                            continue;
                        }
                        if (((MoCProperty)entry.getValue()).getType() != MoCProperty.Type.DOUBLE) continue;
                        try {
                            Double.parseDouble(par2);
                            property.set(par2);
                            saved = true;
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + (String)entry.getKey() + " to " + TextFormatting.AQUA + par2 + ".", new Object[0]));
                        }
                        catch (NumberFormatException ex) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Invalid value entered. Please enter a valid number.", new Object[0]));
                        }
                    }
                }
            }
        }
        if (command.equalsIgnoreCase("help")) {
            int n;
            List<String> list = this.getSortedPossibleCommands(sender);
            int b0 = 10;
            int i = (list.size() - 1) / b0;
            boolean bl = false;
            if (args.length > 1) {
                try {
                    n = CommandMoCreatures.func_175764_a((String)args[1], (int)1, (int)(i + 1)) - 1;
                }
                catch (NumberInvalidException numberinvalidexception) {
                    numberinvalidexception.printStackTrace();
                }
            }
            int k = Math.min((int)((n + true) * b0), list.size());
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.DARK_GREEN + "--- Showing MoCreatures help page " + (n + 1) + " of " + (i + 1) + "(/moc help <page>)---", new Object[0]));
            for (int l = n * b0; l < k; ++l) {
                String commandToSend = list.get(l);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(commandToSend, new Object[0]));
            }
        }
        if (saved) {
            config.save();
            MoCreatures.proxy.readGlobalConfigValues();
        }
    }

    protected List<String> getSortedPossibleCommands(ICommandSender par1ICommandSender) {
        Collections.sort(commands);
        return commands;
    }

    public boolean teleportLoadedPet(WorldServer world, EntityPlayerMP player, int petId, String petName, ICommandSender par1ICommandSender) {
        for (int j = 0; j < world.field_72996_f.size(); ++j) {
            Entity entity = (Entity)world.field_72996_f.get(j);
            if (!IMoCTameable.class.isAssignableFrom(entity.getClass()) || ((IMoCTameable)entity).getPetName().equals("") || ((IMoCTameable)entity).getOwnerPetId() != petId) continue;
            NBTTagCompound compound = new NBTTagCompound();
            entity.func_189511_e(compound);
            if (compound.func_82582_d() || compound.func_74779_i("Owner").isEmpty()) continue;
            String owner = compound.func_74779_i("Owner");
            String name = compound.func_74779_i("Name");
            if (owner.isEmpty() || !owner.equalsIgnoreCase(player.func_70005_c_())) continue;
            if (entity.field_71093_bK == player.field_71093_bK) {
                entity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            } else if (!player.field_70170_p.field_72995_K) {
                Entity newEntity = EntityList.func_191304_a(entity.getClass(), (World)player.field_70170_p);
                if (newEntity != null) {
                    MoCTools.copyDataFromOld(newEntity, entity);
                    newEntity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    DimensionManager.getWorld((int)player.field_71093_bK).func_72838_d(newEntity);
                }
                if (entity.func_184187_bx() != null) {
                    entity.func_184187_bx().func_184210_p();
                }
                entity.field_70128_L = true;
                world.func_82742_i();
                DimensionManager.getWorld((int)player.field_71093_bK).func_82742_i();
            }
            par1ICommandSender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + name + TextFormatting.WHITE + " has been tp'd to location " + Math.round(player.field_70165_t) + ", " + Math.round(player.field_70163_u) + ", " + Math.round(player.field_70161_v) + " in dimension " + player.field_71093_bK, new Object[0]));
            return true;
        }
        return false;
    }

    public void sendCommandHelp(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a72Listing MoCreatures commands", new Object[0]));
        for (String command : commands) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(command, new Object[0]));
        }
    }

    public void sendPageHelp(ICommandSender sender, byte pagelimit, ArrayList<String> list, String[] par2ArrayOfStr, String title) {
        int x = (list.size() - 1) / pagelimit;
        int j = 0;
        if (Character.isDigit(par2ArrayOfStr[par2ArrayOfStr.length - 1].charAt(0))) {
            try {
                j = CommandMoCreatures.func_175764_a((String)par2ArrayOfStr[par2ArrayOfStr.length - 1], (int)1, (int)(x + 1)) - 1;
            }
            catch (NumberInvalidException numberinvalidexception) {
                numberinvalidexception.printStackTrace();
            }
        }
        int k = Math.min((j + 1) * pagelimit, list.size());
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.WHITE + title + " (pg " + TextFormatting.WHITE + (j + 1) + TextFormatting.DARK_GREEN + "/" + TextFormatting.WHITE + (x + 1) + ")", new Object[0]));
        for (int l = j * pagelimit; l < k; ++l) {
            String tamedInfo = list.get(l);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(tamedInfo, new Object[0]));
        }
    }

    static {
        commands.add("/moc attackdolphins <boolean>");
        commands.add("/moc attackhorses <boolean>");
        commands.add("/moc attackwolves <boolean>");
        commands.add("/moc canspawn <boolean>");
        commands.add("/moc caveogrechance <float>");
        commands.add("/moc caveogrestrength <float>");
        commands.add("/moc debug <boolean>");
        commands.add("/moc destroydrops <boolean>");
        commands.add("/moc enablehunters <boolean>");
        commands.add("/moc easybreeding <boolean>");
        commands.add("/moc elephantbulldozer <boolean>");
        commands.add("/moc enableownership <boolean>");
        commands.add("/moc fireogrechance <int>");
        commands.add("/moc fireogrestrength <float>");
        commands.add("/moc frequency <entity> <int>");
        commands.add("/moc golemdestroyblocks <boolean>");
        commands.add("/moc growup <petid>");
        commands.add("/moc tamed");
        commands.add("/moc tamed <playername>");
        commands.add("/moc maxchunk <entity> <int>");
        commands.add("/moc maxspawn <entity> <int>");
        commands.add("/moc maxtamedperop <int>");
        commands.add("/moc maxtamedperplayer <int>");
        commands.add("/moc minspawn <entity> <int>");
        commands.add("/moc motherwyverneggdropchance <int>");
        commands.add("/moc ogreattackrange <int>");
        commands.add("/moc ogrestrength <float>");
        commands.add("/moc ostricheggdropchance <int>");
        commands.add("/moc rareitemdropchance <int>");
        commands.add("/moc spawnhorse <int>");
        commands.add("/moc spawnwyvern <int>");
        commands.add("/moc tamedcount <playername>");
        commands.add("/moc tp <petid> <playername>");
        commands.add("/moc <command> value");
        commands.add("/moc wyverneggdropchance <int>");
        commands.add("/moc zebrachance <int>");
        aliases.add("moc");
        tabCompletionStrings.add("attackdolphins");
        tabCompletionStrings.add("attackhorses");
        tabCompletionStrings.add("attackwolves");
        tabCompletionStrings.add("canspawn");
        tabCompletionStrings.add("caveogrechance");
        tabCompletionStrings.add("caveogrestrength");
        tabCompletionStrings.add("debug");
        tabCompletionStrings.add("destroydrops");
        tabCompletionStrings.add("easybreeding");
        tabCompletionStrings.add("elephantbulldozer");
        tabCompletionStrings.add("enableownership");
        tabCompletionStrings.add("fireogrechance");
        tabCompletionStrings.add("fireogrestrength");
        tabCompletionStrings.add("forcedespawns");
        tabCompletionStrings.add("frequency");
        tabCompletionStrings.add("golemdestroyblocks");
        tabCompletionStrings.add("growup");
        tabCompletionStrings.add("tamed");
        tabCompletionStrings.add("maxchunk");
        tabCompletionStrings.add("maxspawn");
        tabCompletionStrings.add("maxtamedperop");
        tabCompletionStrings.add("maxtamedperplayer");
        tabCompletionStrings.add("minspawn");
        tabCompletionStrings.add("motherwyverneggdropchance");
        tabCompletionStrings.add("ogreattackrange");
        tabCompletionStrings.add("ogreattackstrength");
        tabCompletionStrings.add("ostricheggdropchance");
        tabCompletionStrings.add("rareitemdropchance");
        tabCompletionStrings.add("spawnhorse");
        tabCompletionStrings.add("spawnwyvern");
        tabCompletionStrings.add("tamedcount");
        tabCompletionStrings.add("tp");
        tabCompletionStrings.add("wyverneggdropchance");
        tabCompletionStrings.add("zebrachance");
    }
}

