/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.core;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import wanion.unidict.core.UniDictCoreMod;

public class UniDictCoreModTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraftforge.oredict.OreIngredient")) {
            ClassReader classReader = new ClassReader(basicClass);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            FieldNode newField = new FieldNode(1, "oreName", "Ljava/lang/String;", null, null);
            classNode.fields.add(newField);
            for (MethodNode method : classNode.methods) {
                if (!method.name.equals("<init>") || !method.desc.equals("(Ljava/lang/String;)V")) continue;
                InsnNode lastReturn = null;
                for (AbstractInsnNode instruction : method.instructions) {
                    if (!(instruction instanceof InsnNode) || instruction.getOpcode() != 177) continue;
                    lastReturn = (InsnNode)instruction;
                }
                if (lastReturn == null) {
                    UniDictCoreMod.LOGGER.error("Failed to transform 'net.minecraftforge.oredict.OreIngredient', failed to find last return.");
                    break;
                }
                method.instructions.insertBefore(lastReturn, this.getCode());
                UniDictCoreMod.LOGGER.info("Successfully transformed 'net.minecraftforge.oredict.OreIngredient'.");
                break;
            }
            ClassWriter classWriter = new ClassWriter(2);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        if (transformedName.equals("wanion.unidict.common.Util")) {
            ClassReader classReader = new ClassReader(basicClass);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode method : classNode.methods) {
                if (!method.name.equals("getOreNameFromIngredient")) continue;
                method.instructions.clear();
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/oredict/OreIngredient", "oreName", "Ljava/lang/String;"));
                method.instructions.add((AbstractInsnNode)new InsnNode(176));
                UniDictCoreMod.LOGGER.info("Successfully transformed 'wanion.unidict.common.Util.getOreNameFromIngredient'.");
                break;
            }
            ClassWriter classWriter = new ClassWriter(2);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return basicClass;
    }

    private InsnList getCode() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraftforge/oredict/OreIngredient", "oreName", "Ljava/lang/String;"));
        return list;
    }
}

