/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.crafttweaker.support.railcraft;

import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import info.tritusk.modpack.crafttweaker.support.railcraft.RailcraftTweaker;
import java.util.Locale;
import mods.railcraft.api.crafting.Crafters;
import mods.railcraft.api.crafting.IRockCrusherCrafter;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="railcraft")
@ZenClass(value="mods.railcraft.RockCrusher")
@ZenRegister
public final class RockCrusherSupport {
    @ZenMethod
    public static void addRecipe(final String name, final WeightedItemStack[] outputs, final IIngredient input) {
        RailcraftTweaker.DELAYED_ACTIONS.add(new IAction(){

            public void apply() {
                IRockCrusherCrafter.IRockCrusherRecipeBuilder recipe = (IRockCrusherCrafter.IRockCrusherRecipeBuilder)Crafters.rockCrusher().makeRecipe((Object)CraftTweakerMC.getIngredient((IIngredient)input)).name(name);
                for (int i = 0; i < Math.min(outputs.length, 9); ++i) {
                    if (outputs[i] == null) continue;
                    WeightedItemStack output = outputs[i];
                    recipe = recipe.addOutput(CraftTweakerMC.getItemStack((IItemStack)output.getStack()), output.getChance());
                }
                recipe.register();
            }

            public String describe() {
                return null;
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(String name) {
        RailcraftTweaker.DELAYED_REMOVALS.add(new PreciseRemoval(name));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        RockCrusherSupport.removeRecipeByInput(input);
    }

    @ZenMethod
    public static void removeRecipeByInput(IItemStack input) {
        RailcraftTweaker.DELAYED_REMOVALS.add(new FuzzyRemoval(CraftTweakerMC.getItemStack((IItemStack)input)));
    }

    private static final class FuzzyRemoval
    implements IAction {
        private final ItemStack input;

        FuzzyRemoval(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            Crafters.rockCrusher().getRecipes().removeIf(recipe -> recipe.getInput().apply(this.input));
        }

        public String describe() {
            return null;
        }
    }

    private static final class PreciseRemoval
    implements IAction {
        private final String recipeName;

        PreciseRemoval(String recipeName) {
            this.recipeName = recipeName;
        }

        public void apply() {
            Crafters.rockCrusher().getRecipes().removeIf(r -> this.recipeName.equals(r.getName().toString()));
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Remove Rock Crusher recipe '%s'", this.recipeName);
        }
    }
}

