/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.block.tile;

import ic2.api.energy.prefab.BasicSink;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.info.ILocatable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.RechargeHelper;
import thaumcraft.client.fx.FXDispatcher;
import weissmoon.electromagictools.network.PacketHandler;
import weissmoon.electromagictools.network.TileUpdatePacket;

public class TileIndustrialChargePedestal
extends TileEntity
implements ITickable,
IEnergySink,
IAspectContainer,
ILocatable {
    private final Limithadler itemStackHandler = new Limithadler();
    private final BasicSink energySink;
    private int charging = 0;
    private boolean hasItem = false;
    private static final AspectList EMPTY_ASPECT_LIST = new AspectList();
    private final AspectList ASPECT_LIST = new AspectList();
    private BlockPos UP_POS;
    private IBlockState blockstate;
    private static final float R = 0.7529412f;
    private static final float G = 1.0f;
    private static final float B = 1.0f;

    public TileIndustrialChargePedestal() {
        this.energySink = new BasicSink((ILocatable)this, 100000.0, 4);
    }

    public double getDemandedEnergy() {
        return this.energySink.getDemandedEnergy();
    }

    public int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        return this.energySink.injectEnergy(directionFrom, amount, voltage);
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return side != EnumFacing.UP;
    }

    public void func_73660_a() {
        ItemStack stack = this.itemStackHandler.getStackInSlot(0);
        if (stack.func_77973_b() instanceof IRechargable && this.energySink.getEnergyStored() >= 10000.0) {
            int vis = 1;
            if (this.energySink.getEnergyStored() >= 50000.0) {
                vis = 5;
            } else if (this.energySink.getEnergyStored() >= 20000.0) {
                ++vis;
                if (this.energySink.getEnergyStored() >= 30000.0) {
                    ++vis;
                    if (this.energySink.getEnergyStored() >= 40000.0) {
                        ++vis;
                    }
                }
            }
            IRechargable item = (IRechargable)stack.func_77973_b();
            float charge = RechargeHelper.rechargeItemBlindly((ItemStack)stack, null, (int)vis);
            if (charge > 0.0f) {
                this.energySink.useEnergy((double)(10000.0f * charge));
                this.itemStackHandler.updateInSlot(0, stack);
                if (this.blockstate == null) {
                    this.blockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
                }
                this.field_145850_b.func_180501_a(this.field_174879_c, this.blockstate, 2);
                this.func_70296_d();
                if (!this.field_145850_b.field_72995_K) {
                    FXDispatcher.INSTANCE.drawWispyMotes((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.9, (double)this.field_174879_c.func_177952_p() + 0.1, 0.0, (double)vis * 0.01, (double)vis * 0.01, 9, 0.7529412f, 1.0f, 1.0f, 0.0f);
                    FXDispatcher.INSTANCE.drawWispyMotes((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.9, (double)this.field_174879_c.func_177952_p() + 0.9, 0.0, (double)vis * 0.01, (double)vis * -0.01, 9, 0.7529412f, 1.0f, 1.0f, 0.0f);
                    FXDispatcher.INSTANCE.drawWispyMotes((double)this.field_174879_c.func_177958_n() + 0.1, (double)this.field_174879_c.func_177956_o() + 0.9, (double)this.field_174879_c.func_177952_p() + 0.5, (double)vis * 0.01, (double)vis * 0.01, 0.0, 9, 0.7529412f, 1.0f, 1.0f, 0.0f);
                    FXDispatcher.INSTANCE.drawWispyMotes((double)this.field_174879_c.func_177958_n() + 0.9, (double)this.field_174879_c.func_177956_o() + 0.9, (double)this.field_174879_c.func_177952_p() + 0.5, (double)vis * -0.01, (double)vis * 0.01, 0.0, 9, 0.7529412f, 1.0f, 1.0f, 0.0f);
                }
            }
        }
    }

    public int getCharging() {
        return this.charging;
    }

    public boolean hasItem() {
        return this.hasItem;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return null;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        compound.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        return compound;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        this.energySink.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
        this.energySink.readFromNBT(compound);
    }

    public void onLoad() {
        super.onLoad();
        this.energySink.onLoad();
        this.UP_POS = this.field_174879_c.func_177984_a();
    }

    public void func_145843_s() {
        this.energySink.invalidate();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.energySink.onChunkUnload();
        super.onChunkUnload();
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public AspectList getAspects() {
        if (this.itemStackHandler.getStackInSlot(0).func_77973_b() instanceof IRechargable) {
            for (Aspect aspect : this.ASPECT_LIST.getAspects()) {
                this.ASPECT_LIST.remove(aspect);
            }
            int i = RechargeHelper.getCharge((ItemStack)this.itemStackHandler.getStackInSlot(0));
            this.ASPECT_LIST.add(Aspect.ENERGY, i);
            return this.ASPECT_LIST;
        }
        return EMPTY_ASPECT_LIST;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    public int addToContainer(Aspect tag, int amount) {
        return amount;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        return 0;
    }

    public BlockPos getUP_POS() {
        return this.UP_POS;
    }

    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    public World getWorldObj() {
        return this.field_145850_b;
    }

    private class Limithadler
    extends ItemStackHandler {
        public Limithadler() {
            super(1);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.validateSlotIndex(slot);
            if (((ItemStack)this.stacks.get(slot)).func_190916_E() < 1) {
                this.stacks.set(slot, (Object)stack);
                this.onContentsChanged(slot);
            }
        }

        public void updateInSlot(int slot, @Nonnull ItemStack stack) {
            this.validateSlotIndex(slot);
            this.stacks.set(slot, (Object)stack);
            this.onContentsChanged(slot);
        }

        public void onContentsChanged(int slot) {
            TileUpdatePacket packet;
            if (TileIndustrialChargePedestal.this.field_145850_b instanceof WorldServer && (packet = new TileUpdatePacket(TileIndustrialChargePedestal.this.field_174879_c, TileIndustrialChargePedestal.this.func_189517_E_())) != null) {
                PacketHandler.INSTANCE.sendToAllTracking((IMessage)packet, new NetworkRegistry.TargetPoint(((TileIndustrialChargePedestal)TileIndustrialChargePedestal.this).field_145850_b.field_73011_w.getDimension(), (double)TileIndustrialChargePedestal.this.field_174879_c.func_177958_n(), (double)TileIndustrialChargePedestal.this.field_174879_c.func_177956_o(), (double)TileIndustrialChargePedestal.this.field_174879_c.func_177952_p(), 40.0));
            }
            TileIndustrialChargePedestal.this.func_70296_d();
        }

        public boolean isItemValid(int index, ItemStack stack) {
            return stack.func_77973_b() instanceof IRechargable;
        }
    }
}

