/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thaumcraft.common.tiles.crafting.TilePedestal;
import weissmoon.core.helper.RNGHelper;
import weissmoon.electromagictools.item.ModItems;

public class StormCraftingTicker {
    private final World world;
    private final BlockPos pos;

    public StormCraftingTicker(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world == this.world) {
            if (this.world.func_175667_e(this.pos)) {
                TileEntity ped = this.world.func_175625_s(this.pos.func_177979_c(2));
                if (ped instanceof TilePedestal) {
                    TilePedestal pedestal = (TilePedestal)ped;
                    if (pedestal.func_70301_a(0).func_190926_b()) {
                        if (pedestal.func_70301_a(0).func_77973_b() == ModItems.stormBreaker) {
                            this.world.func_72838_d((Entity)new EntityLightningBolt(this.world, (double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), false));
                        } else {
                            this.world.func_72838_d((Entity)new EntityLightningBolt(this.world, (double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), true));
                        }
                        this.unload();
                    }
                } else {
                    this.unload();
                }
                float chance = RNGHelper.getRNGFloat().floatValue();
                if ((double)chance > 0.95) {
                    this.world.func_72838_d((Entity)new EntityLightningBolt(this.world, (double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), true));
                } else if ((double)chance < 0.55 && (double)chance > 0.5) {
                    this.world.func_72838_d((Entity)new EntityLightningBolt(this.world, (double)((float)this.pos.func_177958_n() + RNGHelper.getRNGFloat().floatValue() * 16.0f), (double)((float)this.pos.func_177956_o() + RNGHelper.getRNGFloat().floatValue() * 16.0f), (double)((float)this.pos.func_177952_p() + RNGHelper.getRNGFloat().floatValue() * 16.0f), false));
                } else if ((double)chance < 0.0) {
                    this.world.func_72838_d((Entity)new EntityLightningBolt(this.world, (double)((float)this.pos.func_177958_n() + RNGHelper.getRNGFloat().floatValue() * 16.0f), (double)((float)this.pos.func_177956_o() + RNGHelper.getRNGFloat().floatValue() * 16.0f), (double)((float)this.pos.func_177952_p() + RNGHelper.getRNGFloat().floatValue() * 16.0f), true));
                }
            } else {
                this.unload();
            }
        } else {
            this.unload();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() == this.world) {
            this.unload();
        }
    }

    private void unload() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }
}

