/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.event;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import thaumcraft.api.casters.ICasterTriggerManager;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.common.blocks.devices.BlockPedestal;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.tiles.crafting.TileInfusionMatrix;
import thaumcraft.common.tiles.crafting.TilePedestal;
import weissmoon.electromagictools.event.StormCraftingTicker;
import weissmoon.electromagictools.item.ModItems;

public class WWMTCastTriggerManager
implements ICasterTriggerManager {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performTrigger(World world, ItemStack casterStack, EntityPlayer player, BlockPos pos, EnumFacing side, int event) {
        if (event != 1) return false;
        try {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileInfusionMatrix) {
                TileInfusionMatrix matrix = (TileInfusionMatrix)tileEntity;
                if (!matrix.active) {
                    return false;
                }
                TileEntity ped = world.func_175625_s(pos.func_177979_c(2));
                if (ped instanceof TilePedestal) {
                    TilePedestal pedestal = (TilePedestal)ped;
                    ItemStack input = pedestal.func_70301_a(0);
                    if (input.func_190926_b()) {
                        return false;
                    }
                    ArrayList<BlockPos> pedestals = new ArrayList<BlockPos>();
                    for (int a = -8; a <= 8; ++a) {
                        for (int b = -8; b <= 8; ++b) {
                            for (int c = -3; c <= 7; ++c) {
                                BlockPos effectPos;
                                Block block;
                                int x = -a;
                                int y = c;
                                int z = -b;
                                if (a == 0 && b == 0 || !((block = world.func_180495_p(effectPos = new BlockPos((Vec3i)pos).func_177982_a(x, y, z)).func_177230_c()) instanceof BlockPedestal)) continue;
                                pedestals.add(effectPos);
                            }
                        }
                    }
                    ArrayList<ItemStack> components = new ArrayList<ItemStack>();
                    for (BlockPos epos : pedestals) {
                        TilePedestal pedestalC;
                        TileEntity pedC = world.func_175625_s(epos);
                        if (!(pedC instanceof TilePedestal) || (pedestalC = (TilePedestal)pedC).func_70301_a(0).func_190926_b()) continue;
                        components.add(pedestalC.func_70301_a(0).func_77946_l());
                    }
                    InfusionRecipe recipe = ThaumcraftCraftingManager.findMatchingInfusionRecipe(components, (ItemStack)input.func_77946_l(), (EntityPlayer)player);
                    if (recipe == null) return false;
                    if (!(recipe.getRecipeOutput() instanceof ItemStack)) return false;
                    if (((ItemStack)recipe.getRecipeOutput()).func_77973_b() != ModItems.stormBreaker) {
                        return false;
                    }
                }
            }
            world.func_72912_H().func_76069_a(true);
            world.func_72912_H().func_76084_b(true);
            MinecraftForge.EVENT_BUS.register((Object)new StormCraftingTicker(world, pos));
            return false;
        }
        catch (Error error) {
            // empty catch block
        }
        return false;
    }
}

