/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TileUpdatePacket
implements IMessage,
IMessageHandler<TileUpdatePacket, IMessage> {
    private BlockPos blockPos;
    private NBTTagCompound nbt;

    public TileUpdatePacket() {
    }

    public TileUpdatePacket(BlockPos blockPosIn, NBTTagCompound compoundIn) {
        this.blockPos = blockPosIn;
        this.nbt = compoundIn;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.nbt = CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
        this.blockPos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)this.nbt, (DataOutput)new ByteBufOutputStream(buf));
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
        buf.writeLong(this.blockPos.func_177986_g());
    }

    public IMessage onMessage(TileUpdatePacket message, MessageContext ctx) {
        this.nbt = message.nbt;
        this.blockPos = message.blockPos;
        if (this.nbt == null) {
            return null;
        }
        Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e.func_175625_s(this.blockPos)).handleUpdateTag(this.nbt);
        return null;
    }
}

