/*
 * Decompiled with CFR 0.152.
 */
package veovismuaddib.linking_tweaks.listeners;

import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import veovismuaddib.linking_tweaks.ModMain;

public class StarFissureSavedData
extends WorldSavedData {
    private static final String DATA_NAME = "linking_tweaks_star_fissures";
    private static final String LIST_NAME = "ProtectedPlayers";
    private static final Set<UUID> survivingEntities = new TreeSet<UUID>();

    public StarFissureSavedData() {
        super(DATA_NAME);
    }

    public StarFissureSavedData(String s) {
        super(s);
    }

    public static StarFissureSavedData get(World world) {
        MapStorage storage = world.func_175693_T();
        StarFissureSavedData instance = null;
        try {
            instance = (StarFissureSavedData)storage.func_75742_a(StarFissureSavedData.class, DATA_NAME);
        }
        finally {
            if (instance == null) {
                instance = new StarFissureSavedData();
                storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
        }
        return instance;
    }

    public void addSurvivingEntity(Entity e) {
        survivingEntities.add(e.getPersistentID());
        this.func_76185_a();
    }

    public void removeSurvivingEntity(Entity e) {
        survivingEntities.remove(e.getPersistentID());
        this.func_76185_a();
    }

    public boolean containsSurvivingEntity(Entity e) {
        return survivingEntities.contains(e.getPersistentID());
    }

    public void func_76184_a(NBTTagCompound nbt) {
        ModMain.logger.info("Reading from NBT");
        NBTTagList survivingEntitiesNbt = nbt.func_150295_c(LIST_NAME, 8);
        for (NBTBase nbtId : survivingEntitiesNbt) {
            try {
                String idString = ((NBTTagString)nbtId).func_150285_a_();
                UUID id = UUID.fromString(idString);
                survivingEntities.add(id);
            }
            catch (Exception e) {
                ModMain.logger.error("Failed to parse surviving entities from NBT");
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        ModMain.logger.info("Writing to NBT");
        NBTTagList survivingEntitiesNbt = nbt.func_150295_c(LIST_NAME, 8);
        for (UUID id : survivingEntities) {
            survivingEntitiesNbt.func_74742_a((NBTBase)new NBTTagString(id.toString()));
        }
        nbt.func_74782_a("uuids", (NBTBase)survivingEntitiesNbt);
        return nbt;
    }
}

