/*
 * Decompiled with CFR 0.152.
 */
package io.github.chaosunity.forgelin.transformer;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import io.github.chaosunity.forgelin.transformer.Transformer;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R,\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003\u00a8\u0006\u0016"}, d2={"Lio/github/chaosunity/forgelin/transformer/ForgelinTransformer;", "Lnet/minecraft/launchwrapper/IClassTransformer;", "<init>", "()V", "transformers", "Lcom/google/common/collect/Multimap;", "", "Lkotlin/Function1;", "", "getTransformers$annotations", "transform", "p0", "p1", "p2", "addTransformation", "", "clazz", "Lkotlin/reflect/KClass;", "Lio/github/chaosunity/forgelin/transformer/Transformer;", "name", "transformation", "Companion", "Forgelin-Continuous"})
public final class ForgelinTransformer
implements IClassTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Multimap<String, Function1<byte[], byte[]>> transformers;
    private static final Logger LOGGER = LogManager.getLogger((String)"Forgelin-Continuous Transformer");

    public ForgelinTransformer() {
        ListMultimap listMultimap = MultimapBuilder.hashKeys((int)30).arrayListValues(1).build();
        Intrinsics.checkNotNullExpressionValue(listMultimap, "build(...)");
        this.transformers = (Multimap)listMultimap;
        LOGGER.info("Begin register to-be-transformed classes");
        LOGGER.info("Skipping registration...");
        LOGGER.info("Registration for transformation is completed");
    }

    private static /* synthetic */ void getTransformers$annotations() {
    }

    @Nullable
    public byte[] transform(@NotNull String p0, @NotNull String p1, @Nullable byte[] p2) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Collection transformations = this.transformers.get((Object)p1);
        if (p2 == null) {
            return null;
        }
        byte[] transformedBytes = p2;
        for (Function1 transformation : transformations) {
            LOGGER.info("Transforming...");
            transformedBytes = (byte[])transformation.invoke(transformedBytes);
        }
        return transformedBytes;
    }

    private final void addTransformation(KClass<? extends Transformer> clazz) {
        String classQualifiedName = clazz.getQualifiedName();
        LOGGER.info("Adding class " + classQualifiedName + " to the transformation queue");
        Transformer transformer = clazz.getObjectInstance();
        if (transformer == null) {
            throw new IllegalStateException("Internal transformation error: unable to get transformer `" + classQualifiedName + "` instance");
        }
        Transformer objectInstance = transformer;
        this.transformers.put((Object)objectInstance.getTarget(), (Object)new Function1<byte[], byte[]>((Object)objectInstance){

            public final byte[] invoke(byte[] p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((Transformer)this.receiver).transform(p0);
            }
        });
    }

    private final void addTransformation(String name, Function1<? super byte[], byte[]> transformation) {
        LOGGER.info("Adding class " + name + " to the transformation queue");
        this.transformers.put((Object)name, transformation);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/github/chaosunity/forgelin/transformer/ForgelinTransformer$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "Forgelin-Continuous"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

