/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.JsonContext;
import pl.asie.charset.lib.recipe.IRecipeResultBuilder;
import pl.asie.charset.lib.recipe.ingredient.IngredientCharset;
import pl.asie.charset.module.storage.barrels.BarrelUpgrade;
import pl.asie.charset.module.storage.barrels.CharsetStorageBarrels;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;

public class IngredientBarrel
extends IngredientCharset {
    private static final Map<IngredientBarrel, ItemStack[][]> matchingStacksCache = new HashMap<IngredientBarrel, ItemStack[][]>();
    private boolean includeCarts;
    private Set<BarrelUpgrade> upgradeBlacklist;

    private static Set<BarrelUpgrade> setFromJson(JsonContext context, JsonObject jsonObject, String memberName) {
        if (jsonObject.has(memberName)) {
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            JsonArray array = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)memberName);
            for (JsonElement element : array) {
                builder.add((Object)BarrelUpgrade.valueOf(element.getAsString()));
            }
            return builder.build();
        }
        return Collections.emptySet();
    }

    public IngredientBarrel(JsonContext context, JsonObject json) {
        this.includeCarts = JsonUtils.func_151209_a((JsonObject)json, (String)"carts", (boolean)false);
        this.upgradeBlacklist = IngredientBarrel.setFromJson(context, json, "upgradeBlacklist");
    }

    public boolean arePermutationsDistinct() {
        return true;
    }

    protected ItemStack[][] createMatchingStacks() {
        ArrayList stacks;
        ArrayList stacks2 = stacks = CharsetStorageBarrels.BARRELS;
        if (this.includeCarts || !this.upgradeBlacklist.isEmpty()) {
            stacks2 = Lists.newArrayList();
            for (ItemStack s : stacks) {
                EnumSet<BarrelUpgrade> upgrades = EnumSet.noneOf(BarrelUpgrade.class);
                if (s.func_77942_o()) {
                    TileEntityDayBarrel.populateUpgrades(upgrades, s.func_77978_p());
                }
                for (BarrelUpgrade bUpgrade : this.upgradeBlacklist) {
                    if (!upgrades.contains((Object)bUpgrade)) continue;
                    upgrades = null;
                    break;
                }
                if (upgrades == null) continue;
                stacks2.add(s);
                if (!this.includeCarts) continue;
                stacks2.add(CharsetStorageBarrels.barrelCartItem.makeBarrelCart(s));
            }
        }
        ItemStack[][] stackArray = new ItemStack[stacks2.size()][1];
        for (int i = 0; i < stacks2.size(); ++i) {
            stackArray[i][0] = (ItemStack)stacks2.get(i);
        }
        return stackArray;
    }

    public boolean hasMatchingStacks() {
        return true;
    }

    public boolean matches(ItemStack stack, IRecipeResultBuilder builder) {
        if (!stack.func_190926_b() && (stack.func_77973_b() == CharsetStorageBarrels.barrelItem || this.includeCarts && stack.func_77973_b() == CharsetStorageBarrels.barrelCartItem)) {
            if (!this.upgradeBlacklist.isEmpty()) {
                EnumSet<BarrelUpgrade> upgrades = EnumSet.noneOf(BarrelUpgrade.class);
                if (stack.func_77942_o()) {
                    TileEntityDayBarrel.populateUpgrades(upgrades, stack.func_77978_p());
                }
                for (BarrelUpgrade upgrade : this.upgradeBlacklist) {
                    if (!upgrades.contains((Object)upgrade)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IngredientBarrel)) {
            return false;
        }
        IngredientBarrel other = (IngredientBarrel)((Object)o);
        return other.includeCarts == this.includeCarts && other.upgradeBlacklist.equals(this.upgradeBlacklist);
    }

    public int hashCode() {
        return (this.includeCarts ? 31 : 0) + this.upgradeBlacklist.hashCode();
    }
}

