/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.barrels.modcompat.chiselsandbits;

import java.lang.reflect.Field;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.IChiselsAndBitsAddon;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.modcompat.chiselsandbits.CharsetChiselsAndBitsPlugin;
import pl.asie.charset.module.storage.barrels.CharsetStorageBarrels;

@CharsetChiselsAndBitsPlugin(value="storage.barrels")
public class CharsetChiselsBitsBarrelCompat
implements IChiselsAndBitsAddon {
    private static Item cb_block_bit;
    private static Item cb_bit_bag;

    private int getBitBagStackMultiplier(IChiselAndBitsAPI api) {
        IBitBag bag;
        int bitStackSize = new ItemStack(cb_block_bit).func_77976_d();
        if (cb_bit_bag != null && (bag = api.getBitbag(new ItemStack(cb_bit_bag))) != null) {
            return bag.getBitbagStackSize() / bitStackSize;
        }
        try {
            Class<?> coreClass = Class.forName("mod.chiselsandbits.core.ChiselsAndBits");
            if (coreClass != null) {
                Object config = coreClass.getMethod("getConfig", new Class[0]).invoke(null, new Object[0]);
                Field bagStackSizeField = config.getClass().getField("bagStackSize");
                bagStackSizeField.setAccessible(true);
                int v = (Integer)bagStackSizeField.get(config);
                return v / bitStackSize;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ModCharset.logger.warn("Chisels and Bits present but could not read bag stack size! Using default (x8).");
        return 8;
    }

    public void onReadyChiselsAndBits(IChiselAndBitsAPI api) {
        cb_block_bit = Item.func_111206_d((String)"chiselsandbits:block_bit");
        if (cb_block_bit != null) {
            cb_bit_bag = Item.func_111206_d((String)"chiselsandbits:bit_bag");
            int multiplier = this.getBitBagStackMultiplier(api);
            CharsetStorageBarrels.stackDivisorMultiplierMap.put((Object)cb_block_bit, multiplier);
            CharsetStorageBarrels.stackSizeMultiplierMap.put((Object)cb_block_bit, multiplier);
        }
    }
}

