/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.property;

import com.google.gson.JsonObject;
import java.util.Arrays;
import mod.bespectacled.modernbetaforge.api.property.StringProperty;
import mod.bespectacled.modernbetaforge.property.visitor.EntryValuePropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.FactoryPropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.GuiPropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.PropertyVisitor;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public final class ListProperty
extends StringProperty {
    private final String[] values;

    public ListProperty(int index, String[] values) {
        super(values[MathHelper.func_76125_a((int)index, (int)0, (int)(values.length - 1))]);
        this.values = values;
    }

    public ListProperty(String value, String[] values) {
        this(ListProperty.indexOfOrDefault(value, values), values);
    }

    @Override
    public String getType() {
        return "list";
    }

    @Override
    public void visitFactory(FactoryPropertyVisitor visitor, ModernBetaGeneratorSettings.Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
        visitor.visit(this, factory, registryKey, jsonObject);
    }

    @Override
    public GuiPageButtonList.GuiListEntry visitGui(GuiPropertyVisitor visitor, int guiIdentifier) {
        return visitor.visit(this, guiIdentifier);
    }

    @Override
    public void visitEntryValue(EntryValuePropertyVisitor visitor, int guiIdentifier, Object value, ResourceLocation registryKey) {
        visitor.visit(this, guiIdentifier, ((Float)value).floatValue(), registryKey);
    }

    @Override
    public String visitNameFormatter(PropertyVisitor visitor) {
        return visitor.visit(this);
    }

    public String[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public int indexOf(String value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!value.equals(this.values[i])) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfOrDefault(String value, String[] values) {
        int index = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!value.equals(values[i])) continue;
            index = i;
        }
        return index;
    }
}

