/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.registry;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import mod.bespectacled.modernbetaforge.ModernBeta;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public final class ModernBetaRegistry<T> {
    private final String name;
    private final Map<ResourceLocation, RegistryEntry<T>> registryEntries;

    protected ModernBetaRegistry(String name) {
        this.name = name;
        this.registryEntries = new LinkedHashMap<ResourceLocation, RegistryEntry<T>>();
    }

    public void register(ResourceLocation registryKey, T entry) {
        if (this.contains(registryKey)) {
            throw new IllegalArgumentException("[Modern Beta] Registry " + this.name + " already contains entry named " + registryKey);
        }
        this.registryEntries.put(registryKey, new RegistryEntry(entry));
    }

    public T get(ResourceLocation registryKey) {
        if (!this.contains(registryKey)) {
            throw new NoSuchElementException("[Modern Beta] Registry " + this.name + " does not contain entry named " + registryKey);
        }
        return (T)((RegistryEntry)this.registryEntries.get(registryKey)).entry;
    }

    public T getOrElse(ResourceLocation registryKey, ResourceLocation alternateKey) {
        if (!this.contains(registryKey)) {
            String warning = String.format("Did not find key '%s' for registry '%s', getting alternate entry.", registryKey, this.name);
            ModernBeta.log(Level.WARN, warning);
            return this.get(alternateKey);
        }
        return (T)((RegistryEntry)this.registryEntries.get(registryKey)).entry;
    }

    public T getOrElse(ResourceLocation registryKey, T alternateValue) {
        if (!this.contains(registryKey)) {
            String warning = String.format("Did not find key '%s' for registry '%s', getting alternate entry.", registryKey, this.name);
            ModernBeta.log(Level.WARN, warning);
            return alternateValue;
        }
        return (T)((RegistryEntry)this.registryEntries.get(registryKey)).entry;
    }

    public boolean contains(ResourceLocation registryKey) {
        return this.registryEntries.containsKey(registryKey);
    }

    public boolean contains(T value) {
        return this.registryEntries.containsValue(value);
    }

    public List<T> getValues() {
        return this.registryEntries.entrySet().stream().map(e -> ((RegistryEntry)e.getValue()).entry).collect(Collectors.toList());
    }

    public List<ResourceLocation> getKeys() {
        return this.registryEntries.keySet().stream().collect(Collectors.toList());
    }

    public Set<Map.Entry<ResourceLocation, T>> getEntrySet() {
        return this.registryEntries.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), ((RegistryEntry)e.getValue()).entry)).collect(Collectors.toSet());
    }

    public Map.Entry<ResourceLocation, T> getRandomEntry(Random random) {
        ArrayList<Map.Entry<ResourceLocation, T>> entries = new ArrayList<Map.Entry<ResourceLocation, T>>(this.getEntrySet());
        return (Map.Entry)entries.get(random.nextInt(entries.size()));
    }

    private static class RegistryEntry<T> {
        private final T entry;

        private RegistryEntry(T entry) {
            this.entry = entry;
        }
    }
}

