/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.chunk.noise;

import java.util.List;
import mod.bespectacled.modernbetaforge.api.world.chunk.noise.NoiseColumnSampler;
import mod.bespectacled.modernbetaforge.api.world.chunk.noise.NoiseSampler;
import mod.bespectacled.modernbetaforge.api.world.chunk.noise.NoiseSettings;
import mod.bespectacled.modernbetaforge.util.MathUtil;

public final class NoiseSource {
    private final NoiseColumnSampler noiseColumnSampler;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    private final double[] noise;
    private double lowerNW;
    private double lowerSW;
    private double lowerNE;
    private double lowerSE;
    private double upperNW;
    private double upperSW;
    private double upperNE;
    private double upperSE;
    private double nw;
    private double ne;
    private double sw;
    private double se;
    private double n;
    private double s;
    private double density;

    public NoiseSource(NoiseColumnSampler noiseColumnSampler, int noiseSizeX, int noiseSizeY, int noiseSizeZ) {
        this.noiseColumnSampler = noiseColumnSampler;
        this.noiseSizeX = noiseSizeX;
        this.noiseSizeY = noiseSizeY;
        this.noiseSizeZ = noiseSizeZ;
        this.noise = new double[(noiseSizeX + 1) * (noiseSizeY + 1) * (noiseSizeZ + 1)];
    }

    public final void sampleInitialNoise(int startNoiseX, int startNoiseZ, NoiseSettings noiseSettings, List<NoiseSampler> noiseSamplers) {
        this.sampleNoise(startNoiseX, startNoiseZ, noiseSettings, noiseSamplers);
    }

    public final void sampleNoiseCorners(int noiseX, int noiseY, int noiseZ) {
        this.lowerNW = this.noise[((noiseX + 0) * (this.noiseSizeX + 1) + (noiseZ + 0)) * (this.noiseSizeY + 1) + (noiseY + 0)];
        this.lowerSW = this.noise[((noiseX + 0) * (this.noiseSizeX + 1) + (noiseZ + 1)) * (this.noiseSizeY + 1) + (noiseY + 0)];
        this.lowerNE = this.noise[((noiseX + 1) * (this.noiseSizeX + 1) + (noiseZ + 0)) * (this.noiseSizeY + 1) + (noiseY + 0)];
        this.lowerSE = this.noise[((noiseX + 1) * (this.noiseSizeX + 1) + (noiseZ + 1)) * (this.noiseSizeY + 1) + (noiseY + 0)];
        this.upperNW = this.noise[((noiseX + 0) * (this.noiseSizeX + 1) + (noiseZ + 0)) * (this.noiseSizeY + 1) + (noiseY + 1)];
        this.upperSW = this.noise[((noiseX + 0) * (this.noiseSizeX + 1) + (noiseZ + 1)) * (this.noiseSizeY + 1) + (noiseY + 1)];
        this.upperNE = this.noise[((noiseX + 1) * (this.noiseSizeX + 1) + (noiseZ + 0)) * (this.noiseSizeY + 1) + (noiseY + 1)];
        this.upperSE = this.noise[((noiseX + 1) * (this.noiseSizeX + 1) + (noiseZ + 1)) * (this.noiseSizeY + 1) + (noiseY + 1)];
    }

    public final void sampleNoiseY(double deltaY) {
        this.nw = MathUtil.lerp(deltaY, this.lowerNW, this.upperNW);
        this.sw = MathUtil.lerp(deltaY, this.lowerSW, this.upperSW);
        this.ne = MathUtil.lerp(deltaY, this.lowerNE, this.upperNE);
        this.se = MathUtil.lerp(deltaY, this.lowerSE, this.upperSE);
    }

    public final void sampleNoiseX(double deltaX) {
        this.n = MathUtil.lerp(deltaX, this.nw, this.ne);
        this.s = MathUtil.lerp(deltaX, this.sw, this.se);
    }

    public final void sampleNoiseZ(double deltaZ) {
        this.density = MathUtil.lerp(deltaZ, this.n, this.s);
    }

    public final double sample() {
        return this.density;
    }

    private void sampleNoise(int startNoiseX, int startNoiseZ, NoiseSettings noiseSettings, List<NoiseSampler> noiseSamplers) {
        double[] buffer = new double[this.noiseSizeY + 1];
        int ndx = 0;
        for (int localNoiseX = 0; localNoiseX < this.noiseSizeX + 1; ++localNoiseX) {
            int noiseX = startNoiseX + localNoiseX;
            for (int localNoiseZ = 0; localNoiseZ < this.noiseSizeZ + 1; ++localNoiseZ) {
                int noiseZ = startNoiseZ + localNoiseZ;
                this.noiseColumnSampler.sampleNoiseColumn(buffer, startNoiseX, startNoiseZ, localNoiseX, localNoiseZ, this.noiseSizeX, this.noiseSizeY, this.noiseSizeZ);
                for (int noiseY = 0; noiseY < this.noiseSizeY + 1; ++noiseY) {
                    double density = buffer[noiseY];
                    for (int i = 0; i < noiseSamplers.size(); ++i) {
                        density = noiseSamplers.get(i).sample(density, noiseX, noiseY, noiseZ, this.noiseSizeX, this.noiseSizeY, this.noiseSizeZ);
                    }
                    density = noiseSettings.topSlideSettings.applyTopSlide(density, noiseY, this.noiseSizeY);
                    density = noiseSettings.bottomSlideSettings.applyBottomSlide(density, noiseY);
                    this.noise[ndx++] = density;
                }
            }
        }
    }
}

