/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.chunk.source;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverBeach;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverCustom;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverOcean;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.data.FiniteDataHandler;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.spawn.WorldSpawner;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionRules;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionStep;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjector;
import mod.bespectacled.modernbetaforge.world.chunk.blocksource.BlockSourceDefault;
import mod.bespectacled.modernbetaforge.world.chunk.blocksource.BlockSourceRules;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevHouse;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import mod.bespectacled.modernbetaforge.world.spawn.IndevWorldSpawner;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public abstract class FiniteChunkSource
extends ChunkSource {
    protected static final Block PLACEHOLDER_BLOCK = Blocks.field_150467_bQ;
    protected static final int MAX_FLOODS = 640;
    protected final int levelWidth;
    protected final int levelLength;
    protected final int levelHeight;
    protected final float levelCaveWidth;
    protected final int[] levelHeightmap;
    protected final BiomeSource biomeSource;
    private final IndevHouse levelHouse;
    private Consumer<String> levelNotifier;
    private LevelDataContainer levelDataContainer;
    private String phase;
    private float phaseProgress;

    public FiniteChunkSource(long seed, ModernBetaGeneratorSettings settings) {
        super(seed, settings);
        this.levelWidth = settings.levelWidth >> 4 << 4;
        this.levelLength = settings.levelLength >> 4 << 4;
        this.levelHeight = settings.levelHeight;
        this.levelCaveWidth = settings.levelCaveWidth;
        this.levelHeightmap = new int[this.levelWidth * this.levelLength];
        this.biomeSource = ModernBetaRegistries.BIOME_SOURCE.get(settings.biomeSource).apply(seed, settings);
        this.levelHouse = IndevHouse.fromId(this.settings.levelHouse);
    }

    @Override
    public final WorldSpawner getWorldSpawner() {
        return new IndevWorldSpawner();
    }

    @Override
    public void provideInitialChunk(ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        if (this.inWorldBounds(startX, startZ)) {
            this.pregenerateLevelOrWait(this.levelDataContainer);
            this.generateTerrain(chunkPrimer, chunkX, chunkZ, this.biomeSource);
        } else {
            this.generateBorder(chunkPrimer, chunkX, chunkZ);
        }
    }

    @Override
    public void provideProcessedChunk(ChunkPrimer chunkPrimer, int chunkX, int chunkZ, List<StructureComponent> structureComponents) {
    }

    @Override
    public final void provideSurface(World world, Biome[] biomes, ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight(int x, int z, HeightmapChunk.Type type) {
        if (!this.inLevelBounds(x += this.levelWidth / 2, 0, z += this.levelLength / 2)) {
            return this.getBorderHeight(x, z, type);
        }
        FiniteChunkSource finiteChunkSource = this;
        synchronized (finiteChunkSource) {
            this.levelDataContainer = this.levelDataContainer == null || !this.levelDataContainer.generated ? new LevelDataContainer(this.levelWidth, this.levelHeight, this.levelLength) : this.levelDataContainer;
            this.pregenerateLevelOrWait(this.levelDataContainer);
        }
        return this.getLevelHeight(x, z, type);
    }

    public Block getLevelBlock(int x, int y, int z) {
        x = MathHelper.func_76125_a((int)x, (int)0, (int)(this.levelWidth - 1));
        y = MathHelper.func_76125_a((int)y, (int)0, (int)(this.levelHeight - 1));
        z = MathHelper.func_76125_a((int)z, (int)0, (int)(this.levelLength - 1));
        return this.levelDataContainer.getLevelBlock(x, y, z, this.levelWidth, this.levelLength);
    }

    public void setLevelBlock(int x, int y, int z, Block block) {
        x = MathHelper.func_76125_a((int)x, (int)0, (int)(this.levelWidth - 1));
        y = MathHelper.func_76125_a((int)y, (int)0, (int)(this.levelHeight - 1));
        z = MathHelper.func_76125_a((int)z, (int)0, (int)(this.levelLength - 1));
        this.levelDataContainer.setLevelBlock(x, y, z, this.levelWidth, this.levelLength, block);
    }

    public int getLevelHeight(int x, int z, HeightmapChunk.Type type) {
        int y;
        x = MathHelper.func_76125_a((int)x, (int)0, (int)(this.levelWidth - 1));
        z = MathHelper.func_76125_a((int)z, (int)0, (int)(this.levelLength - 1));
        Predicate<Block> testBlock = block -> {
            switch (type) {
                case SURFACE: {
                    return block == Blocks.field_150350_a || block == this.defaultFluid.func_177230_c();
                }
                case OCEAN: {
                    return block == Blocks.field_150350_a;
                }
                case FLOOR: {
                    return block == Blocks.field_150350_a || block == this.defaultFluid.func_177230_c();
                }
            }
            return block == Blocks.field_150350_a;
        };
        for (y = this.levelHeight; testBlock.test(this.getLevelBlock(x, y, z)) && y > 0; --y) {
        }
        return y;
    }

    public int getLevelWidth() {
        return this.levelWidth;
    }

    public int getLevelLength() {
        return this.levelLength;
    }

    public int getLevelHeight() {
        return this.levelHeight;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setLevelNotifier(Consumer<String> levelNotifier) {
        this.levelNotifier = levelNotifier;
    }

    public void loadOrCreateLevelDataContainer(World world) {
        if (this.levelDataContainer == null) {
            this.levelDataContainer = ModernBetaConfig.generatorOptions.saveIndevLevels ? this.tryLoadLevel(world) : new LevelDataContainer(this.levelWidth, this.levelHeight, this.levelLength);
        }
    }

    public void saveLevelDataContainer(World world) {
        if (ModernBetaConfig.generatorOptions.saveIndevLevels) {
            this.trySaveLevel(world, this.levelDataContainer);
            if (ModernBetaConfig.debugOptions.debugIndevLevelSaves) {
                this.debugLevelDataHandler(world, this.levelDataContainer);
            }
        }
    }

    public void pregenerateTerrainOrWait() {
        this.pregenerateLevelOrWait(this.levelDataContainer);
    }

    public void buildHouse(WorldServer world, BlockPos spawnPos, boolean isBonusChestEnabled) {
        if (this.levelHouse == IndevHouse.NONE) {
            return;
        }
        this.setPhase("Building");
        int spawnX = spawnPos.func_177958_n();
        int spawnY = spawnPos.func_177956_o() + 1;
        int spawnZ = spawnPos.func_177952_p();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        Random random = new Random(world.func_72905_C());
        Block wallBlock = this.levelHouse.wallBlock;
        Block floorBlock = this.levelHouse.floorBlock;
        for (int x = spawnX - 3; x <= spawnX + 3; ++x) {
            for (int y = spawnY - 2; y <= spawnY + 2; ++y) {
                for (int z = spawnZ - 3; z <= spawnZ + 3; ++z) {
                    Block block;
                    Block block2 = block = y < spawnY - 1 ? Blocks.field_150343_Z : Blocks.field_150350_a;
                    if (x == spawnX - 3 || z == spawnZ - 3 || x == spawnX + 3 || z == spawnZ + 3 || y == spawnY - 2 || y == spawnY + 2) {
                        block = floorBlock;
                        if (y >= spawnY - 1) {
                            block = wallBlock;
                        }
                    }
                    if (z == spawnZ + 3 && x == spawnX && y >= spawnY - 1 && y <= spawnY) {
                        block = Blocks.field_150350_a;
                    }
                    world.func_175656_a((BlockPos)blockPos.func_181079_c(x, y, z), block.func_176223_P());
                }
            }
        }
        world.func_175656_a((BlockPos)blockPos.func_181079_c(spawnX - 3 + 1, spawnY, spawnZ), Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST));
        world.func_175656_a((BlockPos)blockPos.func_181079_c(spawnX + 3 - 1, spawnY, spawnZ), Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST));
        if (isBonusChestEnabled) {
            IBlockState chestState = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH);
            world.func_180501_a((BlockPos)blockPos.func_181079_c(spawnX, spawnY - 1, spawnZ - 2), chestState, 2);
            TileEntity tileEntity = world.func_175625_s((BlockPos)blockPos);
            if (tileEntity instanceof TileEntityChest) {
                ((TileEntityChest)tileEntity).func_189404_a(LootTableList.field_186420_b, random.nextLong());
            }
        }
    }

    public boolean inWorldBounds(int x, int z) {
        return (x += this.levelWidth / 2) >= 0 && x < this.levelWidth && (z += this.levelLength / 2) >= 0 && z < this.levelLength;
    }

    public boolean hasPregenerated() {
        if (this.levelDataContainer != null) {
            return this.levelDataContainer.generated;
        }
        return false;
    }

    @Override
    public boolean skipChunk(int chunkX, int chunkZ) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        return !this.inWorldBounds(startX, startZ);
    }

    @Override
    public void pruneChunk(World world, int chunkX, int chunkZ) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        if (this.inWorldBounds(startX, startZ)) {
            return;
        }
        for (int x = startX; x < startX + 16; ++x) {
            for (int z = startZ; z < startZ + 16; ++z) {
                int height = this.getHeight(x, z, HeightmapChunk.Type.OCEAN);
                for (int y = world.func_72940_L() - 1; y > height; --y) {
                    if (world.func_180495_p((BlockPos)blockPos.func_181079_c(x, y, z)).func_177230_c() == Blocks.field_150350_a) continue;
                    world.func_175656_a((BlockPos)blockPos, BlockStates.AIR);
                }
            }
        }
    }

    @Override
    public BiomeInjectionRules buildBiomeInjectorRules(BiomeSource biomeSource) {
        boolean replaceOceans = this.getGeneratorSettings().replaceOceanBiomes;
        boolean replaceBeaches = this.getGeneratorSettings().replaceBeachBiomes;
        BiomeInjectionRules.Builder builder = new BiomeInjectionRules.Builder();
        Predicate<BiomeInjectionRules.BiomeInjectionContext> deepOceanPredicate = context -> BiomeInjector.atOceanDepth(context.getPos().func_177956_o(), 16, this.getSeaLevel()) && BiomeInjector.isFluidBlock(context.getStateAbove(), this.defaultFluid);
        Predicate<BiomeInjectionRules.BiomeInjectionContext> oceanPredicate = context -> BiomeInjector.atOceanDepth(context.getPos().func_177956_o(), 4, this.getSeaLevel()) && BiomeInjector.isFluidBlock(context.getStateAbove(), this.defaultFluid);
        Predicate<BiomeInjectionRules.BiomeInjectionContext> beachPredicate = context -> BiomeInjector.atBeachDepth(context.getPos().func_177956_o(), this.getSeaLevel()) && BiomeInjector.isBeachBlock(context.getState(), context.getBiome());
        if (replaceOceans && biomeSource instanceof BiomeResolverOcean) {
            BiomeResolverOcean biomeResolverOcean = (BiomeResolverOcean)((Object)biomeSource);
            builder.add(deepOceanPredicate, biomeResolverOcean::getDeepOceanBiome, BiomeInjectionStep.PRE_SURFACE);
            builder.add(oceanPredicate, biomeResolverOcean::getOceanBiome, BiomeInjectionStep.PRE_SURFACE);
        }
        if (replaceBeaches && biomeSource instanceof BiomeResolverBeach) {
            BiomeResolverBeach biomeResolverBeach = (BiomeResolverBeach)((Object)biomeSource);
            builder.add(beachPredicate, biomeResolverBeach::getBeachBiome, BiomeInjectionStep.POST_SURFACE);
        }
        for (ModernBetaRegistries.BiomeResolverCreator resolverCreator : ModernBetaRegistries.BIOME_RESOLVER.getValues()) {
            BiomeResolverCustom customResolver = resolverCreator.apply(this, this.settings);
            builder.add(customResolver.getCustomPredicate(), customResolver::getCustomBiome, BiomeInjectionStep.CUSTOM);
        }
        return builder.build();
    }

    protected abstract void pregenerateTerrain();

    protected abstract void generateBorder(ChunkPrimer var1, int var2, int var3);

    protected abstract int getBorderHeight(int var1, int var2, HeightmapChunk.Type var3);

    protected synchronized void pregenerateLevelOrWait(LevelDataContainer levelDataContainer) {
        if (!levelDataContainer.generated) {
            this.pregenerateTerrain();
            levelDataContainer.generated = true;
        }
    }

    protected boolean inLevelBounds(int x, int y, int z) {
        return x >= 0 && x < this.levelWidth && y >= 0 && y < this.levelHeight && z >= 0 && z < this.levelLength;
    }

    protected boolean atLevelBounds(int x, int y, int z) {
        return x == 0 || x == this.levelWidth - 1 || y == 0 || y == this.levelHeight - 1 || z == 0 || z == this.levelLength - 1;
    }

    protected void fillOblateSpheroid(float centerX, float centerY, float centerZ, float radius, Block fillBlock) {
        for (int x = (int)(centerX - radius); x <= (int)(centerX + radius); ++x) {
            for (int y = (int)(centerY - radius); y <= (int)(centerY + radius); ++y) {
                for (int z = (int)(centerZ - radius); z <= (int)(centerZ + radius); ++z) {
                    Block block;
                    float dx = (float)x - centerX;
                    float dy = (float)y - centerY;
                    float dz = (float)z - centerZ;
                    if (!(dx * dx + dy * dy * 2.0f + dz * dz < radius * radius) || !this.inCaveBounds(x, y, z) || (block = this.getLevelBlock(x, y, z)) != this.defaultBlock.func_177230_c()) continue;
                    this.setLevelBlock(x, y, z, fillBlock);
                }
            }
        }
    }

    protected int flood(int x, int y, int z, Block fillBlock, Block replaceBlock) {
        return this.flood(x, y, z, fillBlock, replaceBlock, null);
    }

    protected int flood(int startX, int startY, int startZ, Block fillBlock, Block replaceBlock, Vec3d[] floodedPositions) {
        ArrayDeque<Vec3d> positions = new ArrayDeque<Vec3d>();
        int flooded = 0;
        Vec3d startPos = new Vec3d((double)startX, (double)startY, (double)startZ);
        positions.add(startPos);
        int x = startX;
        int y = startY;
        int z = startZ;
        while (!positions.isEmpty()) {
            Vec3d pos = (Vec3d)positions.poll();
            x = (int)pos.field_72450_a;
            y = (int)pos.field_72448_b;
            z = (int)pos.field_72449_c;
            Block block = this.getLevelBlock(x, y, z);
            if (block != replaceBlock) continue;
            this.setLevelBlock(x, y, z, fillBlock);
            if (floodedPositions != null) {
                floodedPositions[flooded] = pos;
            }
            ++flooded;
            if (floodedPositions != null && this.atLevelBounds(x, y, z)) {
                return -1;
            }
            if (floodedPositions != null && flooded >= 640) break;
            if (y - 1 >= 0) {
                this.tryFlood(x, y - 1, z, replaceBlock, positions);
            }
            if (x - 1 >= 0) {
                this.tryFlood(x - 1, y, z, replaceBlock, positions);
            }
            if (x + 1 < this.levelWidth) {
                this.tryFlood(x + 1, y, z, replaceBlock, positions);
            }
            if (z - 1 >= 0) {
                this.tryFlood(x, y, z - 1, replaceBlock, positions);
            }
            if (z + 1 >= this.levelLength) continue;
            this.tryFlood(x, y, z + 1, replaceBlock, positions);
        }
        return flooded;
    }

    protected void setPhase(String phase) {
        this.phase = phase;
        if (this.levelNotifier != null) {
            this.levelNotifier.accept(phase);
        }
        ModernBeta.log(Level.INFO, this.phase + "..");
    }

    protected void setPhaseProgress(float phaseProgress) {
        this.phaseProgress = phaseProgress;
    }

    private void generateTerrain(ChunkPrimer chunkPrimer, int chunkX, int chunkZ, BiomeSource biomeSource) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        int offsetX = this.levelWidth / 2;
        int offsetZ = this.levelLength / 2;
        BlockSourceDefault defaultSource = new BlockSourceDefault(this.defaultBlock);
        BlockSourceRules blockSources = new BlockSourceRules.Builder(this.defaultBlock).add(defaultSource).add(this.blockSources).build();
        for (int localX = 0; localX < 16; ++localX) {
            int x = localX + startX;
            for (int localZ = 0; localZ < 16; ++localZ) {
                int z = localZ + startZ;
                Biome biome = biomeSource.getBiome(x, z);
                boolean isNether = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
                for (int y = this.levelHeight - 1; y >= 0; --y) {
                    Block block = this.getLevelBlock(x + offsetX, y, z + offsetZ);
                    IBlockState blockState = block.func_176223_P();
                    if (block == Blocks.field_150349_c) {
                        blockState = biome.field_76752_A;
                    } else if (block == Blocks.field_150346_d) {
                        blockState = biome.field_76753_B;
                    } else if (block == Blocks.field_150354_m && isNether) {
                        blockState = Blocks.field_150425_aM.func_176223_P();
                    }
                    defaultSource.setBlockState(blockState);
                    chunkPrimer.func_177855_a(localX, y, localZ, blockSources.sample(x, y, z));
                }
            }
        }
    }

    private boolean inCaveBounds(int x, int y, int z) {
        return x > 0 && x < this.levelWidth - 1 && y > 0 && y < this.levelHeight - 1 && z > 0 && z < this.levelLength - 1;
    }

    private void tryFlood(int x, int y, int z, Block replaceBlock, Deque<Vec3d> positions) {
        Block block = this.getLevelBlock(x, y, z);
        if (block == replaceBlock) {
            positions.add(new Vec3d((double)x, (double)y, (double)z));
        }
    }

    private LevelDataContainer tryLoadLevel(World world) {
        return new FiniteDataHandler(world, this).readLevelData(this.levelWidth, this.levelHeight, this.levelLength);
    }

    private boolean trySaveLevel(World world, LevelDataContainer levelDataContainer) {
        return new FiniteDataHandler(world, this).writeLevelData(levelDataContainer.levelData, (BiMap<Byte, String>)levelDataContainer.levelMap);
    }

    private void debugLevelDataHandler(World world, LevelDataContainer levelDataContainer) {
        ModernBeta.log(Level.INFO, String.format("Attempting to read level file '%s'..", "mblevel.dat"));
        try {
            LevelDataContainer readLevelData = new FiniteDataHandler(world, this).readLevelData(this.levelWidth, this.levelHeight, this.levelLength);
            for (int x = 0; x < this.levelWidth; ++x) {
                for (int y = 0; y < this.levelHeight; ++y) {
                    for (int z = 0; z < this.levelLength; ++z) {
                        Block found;
                        Block expected = levelDataContainer.getLevelBlock(x, y, z, this.levelWidth, this.levelLength);
                        if (expected == (found = readLevelData.getLevelBlock(x, y, z, this.levelWidth, this.levelLength))) continue;
                        ModernBeta.log(Level.INFO, String.format("Level data did not match, expected %s, found %s at position %d/%d/%d!", expected.getRegistryName(), found.getRegistryName(), x, y, z));
                    }
                }
            }
            ModernBeta.log(Level.INFO, String.format("Level file '%s' was validated with no errors found..", "mblevel.dat"));
        }
        catch (Exception e) {
            ModernBeta.log(Level.WARN, String.format("Level file '%s' is missing or corrupted and couldn't be loaded. Level will be generated and then saved!", "mblevel.dat"));
            ModernBeta.log(Level.WARN, "Error: " + e.getMessage());
        }
    }

    public static class LevelDataContainer {
        private final byte[] levelData;
        private final BiMap<Byte, String> levelMap;
        private final BiMap<Byte, Block> levelBlockMap;
        private byte blockId;
        private boolean generated;

        public LevelDataContainer(int levelWidth, int levelHeight, int levelLength) {
            this.levelData = new byte[levelWidth * levelHeight * levelLength];
            this.levelMap = HashBiMap.create();
            this.levelBlockMap = HashBiMap.create();
            this.blockId = 0;
            this.generated = false;
            byte by = this.blockId;
            this.blockId = (byte)(by + 1);
            this.levelMap.put((Object)by, (Object)Blocks.field_150350_a.getRegistryName().toString());
            Arrays.fill(this.levelData, (Byte)this.levelMap.inverse().get((Object)Blocks.field_150350_a.getRegistryName().toString()));
        }

        public LevelDataContainer(byte[] levelData, BiMap<Byte, String> levelMap) {
            this.levelData = levelData;
            this.levelMap = levelMap;
            this.levelBlockMap = HashBiMap.create();
            this.generated = true;
        }

        private Block getLevelBlock(int x, int y, int z, int levelWidth, int levelLength) {
            byte blockId = this.levelData[(y * levelLength + z) * levelWidth + x];
            if (!this.levelBlockMap.containsKey((Object)blockId)) {
                String registryName = (String)this.levelMap.get((Object)blockId);
                this.levelBlockMap.put((Object)blockId, (Object)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName)));
            }
            return (Block)this.levelBlockMap.get((Object)blockId);
        }

        private void setLevelBlock(int x, int y, int z, int levelWidth, int levelLength, Block block) {
            String registryName = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString();
            if (!this.levelMap.containsValue((Object)registryName)) {
                byte by = this.blockId;
                this.blockId = (byte)(by + 1);
                this.levelMap.put((Object)by, (Object)registryName);
            }
            if (this.levelMap.size() > 255) {
                throw new IndexOutOfBoundsException("Level data block map size exceeded 255!");
            }
            this.levelData[(y * levelLength + z) * levelWidth + x] = (Byte)this.levelMap.inverse().get((Object)registryName);
        }
    }
}

