/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.chunk.source;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.world.chunk.blocksource.BlockSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.noise.NoiseSampler;
import mod.bespectacled.modernbetaforge.api.world.chunk.noise.NoiseSettings;
import mod.bespectacled.modernbetaforge.api.world.chunk.noise.NoiseSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.surface.SurfaceBuilder;
import mod.bespectacled.modernbetaforge.registry.ModernBetaBuiltInTypes;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.chunk.ChunkCache;
import mod.bespectacled.modernbetaforge.util.chunk.DensityChunk;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.chunk.blocksource.BlockSourceRules;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import mod.bespectacled.modernbetaforge.world.structure.StructureWeightSampler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.StructureComponent;

public abstract class NoiseChunkSource
extends ChunkSource {
    protected final int verticalNoiseResolution;
    protected final int horizontalNoiseResolution;
    protected final int noiseSizeX;
    protected final int noiseSizeZ;
    protected final int noiseSizeY;
    protected final int noiseTopY;
    private final ChunkCache<HeightmapChunk> heightmapCache;
    private final ChunkCache<DensityChunk> densityCache;
    private final Map<ResourceLocation, NoiseSampler> noiseSamplers;
    private final NoiseSettings noiseSettings;
    private final SurfaceBuilder surfaceBuilder;
    private final PerlinOctaveNoise minLimitOctaveNoise;
    private final PerlinOctaveNoise maxLimitOctaveNoise;
    private final PerlinOctaveNoise mainOctaveNoise;

    public NoiseChunkSource(long seed, ModernBetaGeneratorSettings settings) {
        super(seed, settings);
        NoiseSettings noiseSettings = ModernBetaRegistries.NOISE_SETTING.get(settings.chunkSource);
        this.verticalNoiseResolution = noiseSettings.sizeVertical * 4;
        this.horizontalNoiseResolution = noiseSettings.sizeHorizontal * 4;
        this.noiseSizeX = 16 / this.horizontalNoiseResolution;
        this.noiseSizeZ = 16 / this.horizontalNoiseResolution;
        this.noiseSizeY = Math.floorDiv(this.worldHeight, this.verticalNoiseResolution);
        this.noiseTopY = Math.floorDiv(this.worldHeight, this.verticalNoiseResolution);
        this.heightmapCache = new ChunkCache<HeightmapChunk>("heightmap", this::sampleHeightmap);
        this.densityCache = new ChunkCache<DensityChunk>("density", this::sampleDensities);
        this.noiseSamplers = new LinkedHashMap<ResourceLocation, NoiseSampler>();
        ModernBetaRegistries.NOISE_SAMPLER.getEntrySet().forEach(entry -> this.noiseSamplers.put((ResourceLocation)entry.getKey(), ((ModernBetaRegistries.NoiseSamplerCreator)entry.getValue()).apply(this, this.settings)));
        this.noiseSettings = noiseSettings;
        this.surfaceBuilder = ModernBetaRegistries.SURFACE_BUILDER.getOrElse(settings.surfaceBuilder, (ModernBetaRegistries.SurfaceBuilderCreator)ModernBetaBuiltInTypes.Surface.BETA.getRegistryKey()).apply(this, settings);
        this.minLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.maxLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.mainOctaveNoise = new PerlinOctaveNoise(this.random, 8, true);
    }

    @Override
    public void provideInitialChunk(ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        this.densityCache.get(chunkX, chunkZ);
    }

    @Override
    public void provideProcessedChunk(ChunkPrimer chunkPrimer, int chunkX, int chunkZ, List<StructureComponent> structureComponents) {
        this.generateTerrain(chunkPrimer, chunkX, chunkZ, structureComponents);
    }

    @Override
    public void provideSurface(World world, Biome[] biomes, ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        this.surfaceBuilder.provideSurface(world, biomes, chunkPrimer, chunkX, chunkZ);
    }

    @Override
    public int getHeight(int x, int z, HeightmapChunk.Type type) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return this.heightmapCache.get(chunkX, chunkZ).getHeight(x, z, type);
    }

    public double getDensity(ResourceLocation key, int x, int y, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return this.densityCache.get(chunkX, chunkZ).sample(key, x, y, z);
    }

    public NoiseSampler getNoiseSampler(ResourceLocation key) {
        if (!this.noiseSamplers.containsKey(key)) {
            String error = String.format("[Modern Beta] Noise Sampler map does not contain key '%s'!", key);
            throw new IllegalArgumentException(error);
        }
        return this.noiseSamplers.get(key);
    }

    public NoiseSettings getNoiseSettings() {
        return this.noiseSettings;
    }

    public String debugNoiseSettings() {
        return String.format("Noise Sizes: %d %d %d", this.noiseSizeX, this.noiseSizeY, this.noiseSizeZ);
    }

    public String debugNoiseCoordinates(int x, int y, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        int localNoiseX = (x & 0xF) / this.noiseSizeX;
        int localNoiseZ = (z & 0xF) / this.noiseSizeZ;
        int noiseY = y / this.verticalNoiseResolution;
        return String.format("Noise: %d %d %d in %d %d", localNoiseX, noiseY, localNoiseZ, chunkX, chunkZ);
    }

    public String debugNoiseModifiers(int x, int y, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        int startNoiseX = chunkX * this.noiseSizeX;
        int startNoiseZ = chunkZ * this.noiseSizeZ;
        int localNoiseX = (x & 0xF) / this.noiseSizeX;
        int localNoiseZ = (z & 0xF) / this.noiseSizeZ;
        int noiseY = y / this.verticalNoiseResolution;
        NoiseScaleDepth noiseScaleDepth = this.sampleNoiseScaleDepth(startNoiseX, startNoiseZ, localNoiseX, localNoiseZ);
        double scale = noiseScaleDepth.scale;
        double depth = noiseScaleDepth.depth;
        double offset = this.sampleNoiseOffset(noiseY, scale, depth);
        return String.format("Scale: %.3f Depth: %.3f Offset: %.3f", scale, depth, offset);
    }

    protected void sampleNoiseColumn(double[] buffer, int startNoiseX, int startNoiseZ, int localNoiseX, int localNoiseZ) {
        int noiseX = startNoiseX + localNoiseX;
        int noiseZ = startNoiseZ + localNoiseZ;
        double coordinateScale = this.settings.coordinateScale;
        double heightScale = this.settings.heightScale;
        double mainNoiseScaleX = this.settings.mainNoiseScaleX;
        double mainNoiseScaleY = this.settings.mainNoiseScaleY;
        double mainNoiseScaleZ = this.settings.mainNoiseScaleZ;
        double lowerLimitScale = this.settings.lowerLimitScale;
        double upperLimitScale = this.settings.upperLimitScale;
        NoiseScaleDepth noiseScaleDepth = this.sampleNoiseScaleDepth(startNoiseX, startNoiseZ, localNoiseX, localNoiseZ);
        double scale = noiseScaleDepth.scale;
        double depth = noiseScaleDepth.depth;
        for (int noiseY = 0; noiseY < buffer.length; ++noiseY) {
            double density;
            double densityOffset = this.sampleNoiseOffset(noiseY, scale, depth);
            double mainNoise = (this.mainOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale / mainNoiseScaleX, heightScale / mainNoiseScaleY, coordinateScale / mainNoiseScaleZ) / 10.0 + 1.0) / 2.0;
            if (mainNoise < 0.0) {
                density = this.minLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / lowerLimitScale;
            } else if (mainNoise > 1.0) {
                density = this.maxLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / upperLimitScale;
            } else {
                double minLimitNoise = this.minLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / lowerLimitScale;
                double maxLimitNoise = this.maxLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / upperLimitScale;
                density = minLimitNoise + (maxLimitNoise - minLimitNoise) * mainNoise;
            }
            buffer[noiseY] = density - densityOffset;
        }
    }

    protected abstract NoiseScaleDepth sampleNoiseScaleDepth(int var1, int var2, int var3, int var4);

    protected abstract double sampleNoiseOffset(int var1, double var2, double var4);

    private void generateTerrain(ChunkPrimer chunkPrimer, int chunkX, int chunkZ, List<StructureComponent> structureComponents) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        int sizeX = this.horizontalNoiseResolution * this.noiseSizeX;
        int sizeZ = this.horizontalNoiseResolution * this.noiseSizeZ;
        int sizeY = this.verticalNoiseResolution * this.noiseSizeY;
        StructureWeightSampler weightSampler = new StructureWeightSampler(structureComponents);
        DensityChunk densityChunk = this.densityCache.get(chunkX, chunkZ);
        BlockSourceRules blockSources = new BlockSourceRules.Builder(this.defaultBlock).add(this.getInitialBlockSource(densityChunk, weightSampler)).add(this.blockSources).build();
        for (int localX = 0; localX < sizeX; ++localX) {
            int x = localX + startX;
            for (int localZ = 0; localZ < sizeZ; ++localZ) {
                int z = localZ + startZ;
                for (int y = 0; y < sizeY; ++y) {
                    chunkPrimer.func_177855_a(localX, y, localZ, blockSources.sample(x, y, z));
                }
            }
        }
    }

    private HeightmapChunk sampleHeightmap(int chunkX, int chunkZ) {
        short worldMinY = 0;
        short worldHeight = (short)this.worldHeight;
        int minStructureHeight = 32;
        short[] heightmapSurface = new short[256];
        short[] heightmapOcean = new short[256];
        short[] heightmapFloor = new short[256];
        short[] heightmapStructure = new short[256];
        int sizeX = this.horizontalNoiseResolution * this.noiseSizeX;
        int sizeZ = this.horizontalNoiseResolution * this.noiseSizeZ;
        int sizeY = this.verticalNoiseResolution * this.noiseSizeY;
        DensityChunk densityChunk = this.densityCache.get(chunkX, chunkZ);
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int y = 0; y < sizeY; ++y) {
                    double density = densityChunk.sample(x, y, z);
                    boolean isSolid = density > 0.0;
                    short height = (short)y;
                    int ndx = z + x * 16;
                    if (y < this.getSeaLevel() || isSolid) {
                        heightmapOcean[ndx] = height;
                        if (height >= 8) {
                            heightmapStructure[ndx] = height;
                        }
                    }
                    if (isSolid) {
                        heightmapSurface[ndx] = height;
                    }
                    if (isSolid && heightmapFloor[ndx] == worldMinY) {
                        heightmapFloor[ndx] = worldHeight;
                    }
                    if (!isSolid && heightmapFloor[ndx] == worldHeight) {
                        heightmapFloor[ndx] = (short)(height - 1);
                    }
                    if (height != 0 || heightmapStructure[ndx] != 0) continue;
                    heightmapStructure[ndx] = minStructureHeight;
                }
            }
        }
        return new HeightmapChunk(heightmapSurface, heightmapOcean, heightmapFloor, heightmapStructure);
    }

    private NoiseSource createInitialNoiseSource() {
        NoiseSource noiseSource = new NoiseSource((buffer, startX, startZ, localX, localZ, sizeX, sizeY, sizeZ) -> this.sampleNoiseColumn(buffer, startX, startZ, localX, localZ), this.noiseSizeX, this.noiseSizeY, this.noiseSizeZ);
        return noiseSource;
    }

    private BlockSource getInitialBlockSource(DensityChunk densityChunk, StructureWeightSampler weightSampler) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        return (x, y, z) -> {
            IBlockState blockState = BlockStates.AIR;
            double density = densityChunk.sample(x, y, z);
            density = MathHelper.func_151237_a((double)(density / 200.0), (double)-1.0, (double)1.0);
            density = density / 2.0 - density * density * density / 24.0;
            if ((density += weightSampler.sample(this, (BlockPos)mutablePos.func_181079_c(x, y, z))) > 0.0) {
                blockState = null;
            } else if (y < this.getSeaLevel()) {
                blockState = this.defaultFluid;
            }
            return blockState;
        };
    }

    private DensityChunk sampleDensities(int chunkX, int chunkZ) {
        int sizeX = this.horizontalNoiseResolution * this.noiseSizeX;
        int sizeZ = this.horizontalNoiseResolution * this.noiseSizeZ;
        int sizeY = this.verticalNoiseResolution * this.noiseSizeY;
        List noiseSamplers = this.noiseSamplers.entrySet().stream().map(e -> (NoiseSampler)e.getValue()).collect(Collectors.toCollection(ArrayList::new));
        LinkedHashMap<ResourceLocation, NoiseSource> noiseSources = new LinkedHashMap<ResourceLocation, NoiseSource>();
        noiseSources.put(DensityChunk.INITIAL, this.createInitialNoiseSource());
        ModernBetaRegistries.NOISE_COLUMN_SAMPLER.getEntrySet().forEach(entry -> noiseSources.put((ResourceLocation)entry.getKey(), new NoiseSource(((ModernBetaRegistries.NoiseColumnSamplerCreator)entry.getValue()).apply(this, this.settings), this.noiseSizeX, this.noiseSizeY, this.noiseSizeZ)));
        noiseSources.entrySet().forEach(entry -> ((NoiseSource)entry.getValue()).sampleInitialNoise(chunkX * this.noiseSizeX, chunkZ * this.noiseSizeZ, this.noiseSettings, ((ResourceLocation)entry.getKey()).equals((Object)DensityChunk.INITIAL) ? noiseSamplers : ImmutableList.of()));
        LinkedHashMap<ResourceLocation, double[]> densityMap = new LinkedHashMap<ResourceLocation, double[]>();
        for (Map.Entry entry2 : noiseSources.entrySet()) {
            NoiseSource noiseSource = (NoiseSource)entry2.getValue();
            double[] densities = new double[sizeX * sizeZ * sizeY];
            for (int subChunkX = 0; subChunkX < this.noiseSizeX; ++subChunkX) {
                for (int subChunkZ = 0; subChunkZ < this.noiseSizeZ; ++subChunkZ) {
                    for (int subChunkY = 0; subChunkY < this.noiseSizeY; ++subChunkY) {
                        noiseSource.sampleNoiseCorners(subChunkX, subChunkY, subChunkZ);
                        for (int subY = 0; subY < this.verticalNoiseResolution; ++subY) {
                            int y = subY + subChunkY * this.verticalNoiseResolution;
                            double deltaY = (double)subY / (double)this.verticalNoiseResolution;
                            noiseSource.sampleNoiseY(deltaY);
                            for (int subX = 0; subX < this.horizontalNoiseResolution; ++subX) {
                                int x = subX + subChunkX * this.horizontalNoiseResolution;
                                double deltaX = (double)subX / (double)this.horizontalNoiseResolution;
                                noiseSource.sampleNoiseX(deltaX);
                                for (int subZ = 0; subZ < this.horizontalNoiseResolution; ++subZ) {
                                    int z = subZ + subChunkZ * this.horizontalNoiseResolution;
                                    double deltaZ = (double)subZ / (double)this.horizontalNoiseResolution;
                                    noiseSource.sampleNoiseZ(deltaZ);
                                    densities[(y * 16 + x) * 16 + z] = noiseSource.sample();
                                }
                            }
                        }
                    }
                }
            }
            densityMap.put((ResourceLocation)entry2.getKey(), densities);
        }
        return new DensityChunk(densityMap);
    }

    protected static class NoiseScaleDepth {
        public static final NoiseScaleDepth ZERO = new NoiseScaleDepth(0.0, 0.0);
        public final double scale;
        public final double depth;

        public NoiseScaleDepth(double scale, double depth) {
            this.scale = scale;
            this.depth = depth;
        }
    }
}

