/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.spawn;

import java.util.Random;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import net.minecraft.util.math.BlockPos;

public interface WorldSpawner {
    public static final WorldSpawner DEFAULT = new WorldSpawner(){

        @Override
        public BlockPos locateSpawn(BlockPos spawnPos, ChunkSource chunkSource, BiomeSource biomeSource) {
            int radius = 64;
            int minAdjacent = 9;
            int numTries = 0;
            int maxTries = 10000;
            Random random = new Random(chunkSource.getSeed());
            int centerX = spawnPos.func_177958_n() + random.nextInt(256) - 128;
            int centerZ = spawnPos.func_177952_p() + random.nextInt(256) - 128;
            while (numTries < maxTries) {
                int r2 = radius * radius;
                for (int dX = centerX - radius; dX < centerX + radius; ++dX) {
                    for (int dZ = centerZ - radius; dZ < centerZ + radius; ++dZ) {
                        int oceanY;
                        double distance = MathUtil.distance(centerX, centerZ, dX, dZ);
                        if (!(distance < (double)r2)) continue;
                        int surfaceY = chunkSource.getHeight(dX, dZ, HeightmapChunk.Type.SURFACE);
                        if (surfaceY >= (oceanY = chunkSource.getHeight(dX, dZ, HeightmapChunk.Type.OCEAN)) && surfaceY > 0) {
                            int numAdjacent = 0;
                            for (int aX = dX - 1; aX <= dX + 1; ++aX) {
                                for (int aZ = dZ - 1; aZ <= dZ + 1; ++aZ) {
                                    int aY = chunkSource.getHeight(aX, aZ, HeightmapChunk.Type.SURFACE);
                                    if (aY < surfaceY - 2 || aY > surfaceY + 2) continue;
                                    ++numAdjacent;
                                }
                            }
                            if (numAdjacent >= minAdjacent) {
                                return new BlockPos(dX, surfaceY + 1, dZ);
                            }
                        }
                        ++numTries;
                    }
                }
                radius *= 2;
            }
            return spawnPos;
        }
    };

    public BlockPos locateSpawn(BlockPos var1, ChunkSource var2, BiomeSource var3);
}

