/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.bespectacled.modernbetaforge.client.gui.GuiScreenCustomizeWorld;
import mod.bespectacled.modernbetaforge.util.SoundUtil;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiScreenCustomizeRegistry
extends GuiScreen {
    private static final String PREFIX_REGISTRY = "createWorld.customize.registry.modernbetaforge.";
    private static final String PREFIX_SETTINGS = "createWorld.customize.custom.modernbetaforge.";
    private static final int DEFAULT_SLOT_HEIGHT = 32;
    private static final int MAX_SEARCH_LENGTH = 40;
    private static final int SEARCH_BAR_LENGTH = 360;
    private static final int GUI_ID_SELECT = 0;
    private static final int GUI_ID_CANCEL = 1;
    private static final int GUI_ID_SEARCH = 2;
    private static final int GUI_ID_RESET = 3;
    private final GuiScreenCustomizeWorld parent;
    private final BiConsumer<String, ModernBetaGeneratorSettings.Factory> consumer;
    private final Function<ResourceLocation, String> nameFormatter;
    private final int slotHeight;
    private final boolean displayIcons;
    private final String initialEntry;
    private final String searchEntry;
    private final boolean startSearchFocused;
    private final String langName;
    private final List<ResourceLocation> registryKeys;
    private final List<Info> entries;
    private ModernBetaGeneratorSettings.Factory settings;
    private ListPreset list;
    private GuiTextField fieldSearch;
    private GuiButton buttonSelect;
    private String searchText;
    private int hoveredElement;
    private long hoveredTime;
    private int prevMouseX;
    private int prevMouseY;
    protected String title;

    public GuiScreenCustomizeRegistry(GuiScreenCustomizeWorld parent, BiConsumer<String, ModernBetaGeneratorSettings.Factory> consumer, Function<ResourceLocation, String> nameFormatter, int slotHeight, String initialEntry, String langName, List<ResourceLocation> registryKeys) {
        this(parent, consumer, nameFormatter, slotHeight, false, initialEntry, "", false, langName, registryKeys);
    }

    public GuiScreenCustomizeRegistry(GuiScreenCustomizeWorld parent, BiConsumer<String, ModernBetaGeneratorSettings.Factory> consumer, Function<ResourceLocation, String> nameFormatter, String initialEntry, String langName, List<ResourceLocation> registryKeys) {
        this(parent, consumer, nameFormatter, 32, false, initialEntry, "", false, langName, registryKeys);
    }

    public GuiScreenCustomizeRegistry(GuiScreenCustomizeWorld parent, BiConsumer<String, ModernBetaGeneratorSettings.Factory> consumer, Function<ResourceLocation, String> nameFormatter, int slotHeight, boolean displayIcons, String initialEntry, String searchEntry, boolean startSearchFocused, String langName, List<ResourceLocation> registryKeys) {
        this.title = String.format("%s %s", I18n.func_135052_a((String)"createWorld.customize.registry.modernbetaforge.title", (Object[])new Object[0]), I18n.func_135052_a((String)(PREFIX_SETTINGS + langName), (Object[])new Object[0]));
        this.parent = parent;
        this.consumer = consumer;
        this.nameFormatter = nameFormatter;
        this.slotHeight = slotHeight;
        this.displayIcons = displayIcons;
        this.initialEntry = initialEntry;
        this.searchEntry = searchEntry;
        this.startSearchFocused = startSearchFocused;
        this.langName = langName;
        this.registryKeys = registryKeys;
        this.entries = this.loadEntries();
        this.hoveredElement = -1;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.buttonSelect = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 122, this.field_146295_m - 27, 120, 20, I18n.func_135052_a((String)"createWorld.customize.registry.modernbetaforge.select", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)(PREFIX_SETTINGS + this.langName), (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 3, this.field_146295_m - 27, 120, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 180 - 100, 40, 50, 20, I18n.func_135052_a((String)"createWorld.customize.registry.modernbetaforge.search", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 + 180 - 50, 40, 50, 20, I18n.func_135052_a((String)"createWorld.customize.registry.modernbetaforge.reset", (Object[])new Object[0])));
        this.searchText = I18n.func_135052_a((String)"createWorld.customize.registry.modernbetaforge.search.info", (Object[])new Object[0]);
        this.settings = ModernBetaGeneratorSettings.Factory.jsonToFactory(this.parent.getSettingsString());
        this.list = this.list != null ? new ListPreset(this, this.list.selected) : new ListPreset(this, this.initialEntry);
        int slotHeight = this.slotHeight;
        int slotSelected = this.list.selected;
        int slotsDisplayed = (this.list.field_148158_l - 66 - 32) / slotHeight;
        if (slotSelected > slotsDisplayed - 1) {
            this.list.func_148145_f(slotHeight * (slotSelected - slotsDisplayed) + slotHeight * slotsDisplayed);
        }
        this.fieldSearch = new GuiTextField(5, this.field_146289_q, this.field_146294_l / 2 - 180, 40, 360, 20);
        this.fieldSearch.func_146203_f(40);
        this.fieldSearch.func_146180_a(this.searchEntry);
        this.fieldSearch.func_146195_b(this.startSearchFocused);
        this.updateButtonValidity();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.func_178039_p();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.list.func_148128_a(mouseX, mouseY, partialTicks);
        this.fieldSearch.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 12, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.searchText, this.field_146294_l / 2 - 180, 30, 0xA0A0A0);
    }

    public void func_73876_c() {
        this.fieldSearch.func_146178_a();
        super.func_73876_c();
    }

    public void updateButtonValidity() {
        this.buttonSelect.field_146124_l = this.hasValidSelection();
    }

    protected void func_73864_a(int mouseX, int mouseY, int clicked) throws IOException {
        this.fieldSearch.func_146192_a(mouseX, mouseY, clicked);
        super.func_73864_a(mouseX, mouseY, clicked);
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (!this.fieldSearch.func_146201_a(character, keyCode)) {
            super.func_73869_a(character, keyCode);
        }
        if (this.fieldSearch.func_146206_l() && keyCode == 28 || keyCode == 156) {
            SoundUtil.playClickSound(this.field_146297_k.func_147118_V());
            this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizeRegistry(this.parent, this.consumer, this.nameFormatter, this.slotHeight, this.displayIcons, this.initialEntry, this.fieldSearch.func_146179_b(), true, this.langName, this.registryKeys));
        }
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        switch (guiButton.field_146127_k) {
            case 0: {
                this.consumer.accept(this.entries.get((int)this.list.selected).registryName, this.settings);
                this.parent.loadValues(this.settings.toString());
                this.parent.setSettingsModified(!this.settings.equals(this.parent.getDefaultSettings()));
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                break;
            }
            case 1: {
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                break;
            }
            case 2: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizeRegistry(this.parent, this.consumer, this.nameFormatter, this.slotHeight, this.displayIcons, this.initialEntry, this.fieldSearch.func_146179_b(), this.fieldSearch.func_146206_l() && !this.fieldSearch.func_146179_b().isEmpty(), this.langName, this.registryKeys));
                break;
            }
            case 3: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizeRegistry(this.parent, this.consumer, this.nameFormatter, this.slotHeight, this.displayIcons, this.initialEntry, "", false, this.langName, this.registryKeys));
            }
        }
    }

    private boolean hasValidSelection() {
        return this.list.selected > -1 && this.list.selected < this.entries.size();
    }

    private List<Info> loadEntries() {
        ArrayList<Info> entries = new ArrayList<Info>();
        for (ResourceLocation registryKey : this.registryKeys) {
            String formattedName = this.nameFormatter.apply(registryKey);
            if (this.searchEntry != null && !this.searchEntry.isEmpty() && !formattedName.toLowerCase().contains(this.searchEntry.toLowerCase()) && !registryKey.toString().toLowerCase().contains(this.searchEntry.toLowerCase())) continue;
            entries.add(new Info(formattedName, registryKey.toString()));
        }
        return entries;
    }

    @SideOnly(value=Side.CLIENT)
    private static class Info {
        public String name;
        public String registryName;

        public Info(String name, String registryName) {
            this.name = name;
            this.registryName = registryName;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ListPreset
    extends GuiSlot {
        private static final int LIST_PADDING_TOP = 66;
        private static final int LIST_PADDING_BOTTOM = 32;
        private final GuiScreenCustomizeRegistry parent;
        public int selected;

        public ListPreset(GuiScreenCustomizeRegistry parent, int initialEntry) {
            super(parent.field_146297_k, parent.field_146294_l, parent.field_146295_m, 66, parent.field_146295_m - 32, parent.slotHeight);
            this.parent = parent;
            this.selected = initialEntry;
        }

        public ListPreset(GuiScreenCustomizeRegistry parent, String initialEntry) {
            super(parent.field_146297_k, parent.field_146294_l, parent.field_146295_m, 66, parent.field_146295_m - 32, parent.slotHeight);
            this.parent = parent;
            this.selected = -1;
            for (int i = 0; i < parent.entries.size(); ++i) {
                Info info = (Info)parent.entries.get(i);
                if (!info.registryName.equals(initialEntry.toString())) continue;
                this.selected = i;
            }
        }

        public void func_178039_p() {
            boolean inSlotBounds;
            super.func_178039_p();
            int paddingR = 0;
            int listL = (this.field_148155_a - this.func_148139_c()) / 2;
            int listR = (this.field_148155_a + this.func_148139_c()) / 2 + paddingR;
            int listMouseY = this.field_148162_h - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
            int element = listMouseY / this.field_148149_f;
            boolean inListBounds = this.func_148141_e(this.field_148162_h) && this.field_148162_h >= this.field_148153_b && this.field_148162_h <= this.field_148154_c;
            boolean bl = inSlotBounds = this.field_148150_g >= listL && this.field_148150_g <= listR;
            if (inListBounds && inSlotBounds && listMouseY >= 0 && element < this.func_148127_b()) {
                this.parent.hoveredElement = element;
            } else {
                this.parent.hoveredElement = -1;
            }
        }

        public void func_148128_a(int mouseX, int mouseY, float partialTicks) {
            super.func_148128_a(mouseX, mouseY, partialTicks);
            if (this.parent.hoveredElement != -1 && mouseX != this.parent.prevMouseX && mouseY != this.parent.prevMouseY) {
                this.parent.hoveredTime = System.currentTimeMillis();
                this.parent.prevMouseX = mouseX;
                this.parent.prevMouseY = mouseY;
            }
        }

        protected int func_148127_b() {
            return this.parent.entries.size();
        }

        protected void func_148144_a(int selected, boolean doubleClicked, int mouseX, int mouseY) {
            this.selected = selected;
            this.parent.updateButtonValidity();
            this.parent.consumer.accept(((Info)((GuiScreenCustomizeRegistry)this.parent).entries.get((int)((GuiScreenCustomizeRegistry)this.parent).list.selected)).registryName, this.parent.settings);
            if (doubleClicked) {
                SoundUtil.playClickSound(this.field_148161_k.func_147118_V());
                this.parent.parent.loadValues(this.parent.settings.toString());
                this.parent.parent.setSettingsModified(!this.parent.settings.equals(this.parent.parent.getDefaultSettings()));
                this.parent.field_146297_k.func_147108_a((GuiScreen)this.parent.parent);
            }
        }

        protected boolean func_148131_a(int selected) {
            return selected == this.selected;
        }

        protected void func_148123_a() {
        }

        protected void func_192638_a(int insideLeft, int insideTop, int mouseX, int mouseY, float partialTicks) {
            int paddingL = 4;
            int paddingR = 0;
            int paddingY = 1;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            for (int entry = 0; entry < this.func_148127_b(); ++entry) {
                int y = insideTop + entry * this.field_148149_f + this.field_148160_j;
                int height = this.field_148149_f - 4;
                if (y > this.field_148154_c || y + height < this.field_148153_b) {
                    this.func_192639_a(entry, insideLeft, y, partialTicks);
                }
                if (this.field_148166_t && this.func_148131_a(entry)) {
                    int l = this.field_148152_e + (this.field_148155_a / 2 - this.func_148139_c() / 2) + paddingL;
                    int r = this.field_148152_e + this.field_148155_a / 2 + this.func_148139_c() / 2 + paddingR;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179090_x();
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    bufferbuilder.func_181662_b((double)l, (double)(y + height + 2 + paddingY), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)r, (double)(y + height + 2 + paddingY), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)r, (double)(y - 2 + paddingY), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)l, (double)(y - 2 + paddingY), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)(l + 1), (double)(y + height + 1 + paddingY), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)(r - 1), (double)(y + height + 1 + paddingY), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)(r - 1), (double)(y - 1 + paddingY), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    bufferbuilder.func_181662_b((double)(l + 1), (double)(y - 1 + paddingY), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179098_w();
                }
                this.func_192637_a(entry, insideLeft, y, height, mouseX, mouseY, partialTicks);
            }
        }

        protected void func_192637_a(int entry, int x, int y, int height, int mouseX, int mouseY, float partialTicks) {
            Info info = (Info)this.parent.entries.get(entry);
            int paddingL = 6;
            int paddingY = 3;
            boolean hovered = this.parent.hoveredElement == entry;
            int nameColor = hovered ? 0xFFFFA0 : 0xFFFFFF;
            int registryNameColor = hovered ? 10526785 : 0xA0A0A0;
            this.parent.field_146289_q.func_78276_b(info.name, x + paddingL, y + paddingY, nameColor);
            this.parent.field_146289_q.func_78276_b(info.registryName, x + paddingL, y + 12 + paddingY, registryNameColor);
        }
    }
}

