/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.compat.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.client.gui.GuiPredicate;
import mod.bespectacled.modernbetaforge.api.property.BooleanProperty;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaClientRegistries;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.client.gui.GuiPredicates;
import mod.bespectacled.modernbetaforge.compat.BiomeCompat;
import mod.bespectacled.modernbetaforge.compat.CarverCompat;
import mod.bespectacled.modernbetaforge.compat.ClientCompat;
import mod.bespectacled.modernbetaforge.compat.Compat;
import mod.bespectacled.modernbetaforge.compat.NetherCompat;
import mod.bespectacled.modernbetaforge.compat.SurfaceCompat;
import mod.bespectacled.modernbetaforge.compat.biomesoplenty.BiomesOPlentyCoralReefResolver;
import mod.bespectacled.modernbetaforge.compat.biomesoplenty.BiomesOPlentyKelpForestResolver;
import mod.bespectacled.modernbetaforge.world.biome.source.ReleaseBiomeSource;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import org.apache.logging.log4j.Level;

public class CompatBiomesOPlenty
implements Compat,
ClientCompat,
BiomeCompat,
SurfaceCompat,
CarverCompat,
NetherCompat {
    public static final String MOD_ID = "biomesoplenty";
    public static final String ADDON_ID = "compatbiomesoplenty";
    public static final ResourceLocation KEY_USE_COMPAT = new ResourceLocation("compatbiomesoplenty", "useCompat");
    public static final ResourceLocation KEY_CORAL_REEF_RESOLVER = new ResourceLocation("compatbiomesoplenty", "resolverCoralReef");
    public static final ResourceLocation KEY_KELP_FOREST_RESOLVER = new ResourceLocation("compatbiomesoplenty", "resolverKelpForest");
    private List<BiomeManager.BiomeEntry>[] biomeEntries = new ArrayList[BiomeManager.BiomeType.values().length];

    @Override
    public void load() {
        ModernBeta.log(Level.WARN, "Biomes O' Plenty has been detected, classic Nether settings will be disabled due to incompatibilties!");
        ModernBetaRegistries.PROPERTY.register(KEY_USE_COMPAT, new BooleanProperty(true));
        ModernBetaRegistries.BIOME_RESOLVER.register(KEY_CORAL_REEF_RESOLVER, BiomesOPlentyCoralReefResolver::new);
        ModernBetaRegistries.BIOME_RESOLVER.register(KEY_KELP_FOREST_RESOLVER, BiomesOPlentyKelpForestResolver::new);
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            this.biomeEntries[type.ordinal()] = new ArrayList<BiomeManager.BiomeEntry>();
        }
        int ndx = BiomeManager.BiomeType.DESERT.ordinal();
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.brushland, 10);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.chaparral, 10);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.lush_desert, 2);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.outback, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.steppe, 5);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.wasteland, 5);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.xeric_shrubland, 3);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.oasis, 5);
        ndx = BiomeManager.BiomeType.WARM.ordinal();
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.bamboo_forest, 3);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.bayou, 10);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.eucalyptus_forest, 5);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.flower_field, 2);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.grassland, 3);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.lavender_fields, 3);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.lush_swamp, 10);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.mangrove, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.marsh, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.mystic_grove, 1);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.orchard, 3);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.overgrown_cliffs, 2);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.prairie, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.rainforest, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.sacred_springs, 1);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.shrubland, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.temperate_rainforest, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.tropical_rainforest, 5);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.woodland, 10);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.pasture, 5);
        ndx = BiomeManager.BiomeType.COOL.ordinal();
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.bog, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.boreal_forest, 5);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.cherry_blossom_grove, 2);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.coniferous_forest, 10);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.crag, 2);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.dead_forest, 3);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.dead_swamp, 3);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.fen, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.grassland, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.grove, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.highland, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.land_of_lakes, 3);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.maple_woods, 10);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.meadow, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.moor, 5);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.mountain, 3);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.ominous_woods, 1);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.quagmire, 2);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.redwood_forest, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.seasonal_forest, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.shield, 5);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.tundra, 10);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.wetland, 5);
        ndx = BiomeManager.BiomeType.ICY.ordinal();
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.alps, 5);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.cold_desert, 10);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.snowy_coniferous_forest, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.snowy_forest, 7);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.snowy_tundra, 10);
        this.addBiomeEntry(ndx, (Optional<Biome>)BOPBiomes.glacier, 5);
    }

    @Override
    public String getModId() {
        return MOD_ID;
    }

    @Override
    public void loadClient() {
        ModernBetaClientRegistries.GUI_PREDICATE.register(KEY_USE_COMPAT, new GuiPredicate(settings -> GuiPredicates.isBiomeInstanceOf(settings, ReleaseBiomeSource.class), new int[0]));
    }

    @Override
    public List<BiomeManager.BiomeEntry>[] getBiomeEntries() {
        return this.biomeEntries;
    }

    @Override
    public boolean shouldGetBiomeEntries(ModernBetaGeneratorSettings settings) {
        return settings.getBooleanProperty(KEY_USE_COMPAT);
    }

    @Override
    public List<Biome> getBiomesWithCustomSurfaces() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.alps);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.bamboo_forest);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.bayou);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.bog);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.chaparral);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.cold_desert);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.crag);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.dead_swamp);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.glacier);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.lush_swamp);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.mangrove);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.moor);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.mystic_grove);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.overgrown_cliffs);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.quagmire);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.redwood_forest);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.shield);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.wetland);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.xeric_shrubland);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.coral_reef);
        this.addBiomeSurface((ImmutableList.Builder<Biome>)builder, (Optional<Biome>)BOPBiomes.kelp_forest);
        return builder.build();
    }

    @Override
    public List<Block> getCarvables() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        this.addCarverBlock((ImmutableList.Builder<Block>)builder, BOPBlocks.grass);
        this.addCarverBlock((ImmutableList.Builder<Block>)builder, BOPBlocks.dirt);
        return builder.build();
    }

    private void addBiomeEntry(int ndx, Optional<Biome> biome, int weight) {
        if (biome != null && biome.isPresent()) {
            this.biomeEntries[ndx].add(new BiomeManager.BiomeEntry((Biome)biome.get(), weight));
        }
    }

    private void addBiomeSurface(ImmutableList.Builder<Biome> builder, Optional<Biome> biome) {
        if (biome != null && biome.isPresent()) {
            builder.add(biome.get());
        }
    }

    private void addCarverBlock(ImmutableList.Builder<Block> builder, Block block) {
        if (block != null) {
            builder.add((Object)block);
        }
    }
}

