/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.compat.buildcraft;

import java.util.function.Predicate;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverAddSingleBiome;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.compat.buildcraft.CompatBuildCraftEnergy;
import mod.bespectacled.modernbetaforge.registry.ModernBetaBuiltInTypes;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionRules;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BuildCraftOilOceanResolver
extends BiomeResolverAddSingleBiome {
    public static final ResourceLocation BIOME_ID = new ResourceLocation("buildcraftenergy", "oil_ocean");
    private final boolean isReleaseBiomeSource;
    private final boolean useCompat;

    public BuildCraftOilOceanResolver(ChunkSource chunkSource, ModernBetaGeneratorSettings settings) {
        super(BIOME_ID, chunkSource.getSeed(), 5521L, 73379L, settings.getFloatProperty(CompatBuildCraftEnergy.KEY_OIL_OCEAN_CHANCE));
        this.isReleaseBiomeSource = settings.biomeSource.equals((Object)ModernBetaBuiltInTypes.Biome.RELEASE.getRegistryKey());
        this.useCompat = settings.getBooleanProperty(CompatBuildCraftEnergy.KEY_USE_COMPAT);
    }

    @Override
    public Predicate<BiomeInjectionRules.BiomeInjectionContext> getCustomPredicate() {
        return context -> !this.isReleaseBiomeSource && this.useCompat && BiomeDictionary.hasType((Biome)context.getBiome(), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
    }
}

