/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.mixin.client;

import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.mixin.accessor.AccessorEntityRenderer;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.world.ModernBetaWorldType;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public abstract class MixinEntityRenderer {
    @Unique
    private static int modernBeta_renderDistance = 16;
    @Unique
    private static float modernBeta_fogWeight = MixinEntityRenderer.calculateFogWeight(16);
    @Unique
    private static float modernBeta_partialTicks = 0.0f;
    @Shadow
    private Minecraft field_78531_r;

    @Inject(method={"updateFogColor(F)V"}, at={@At(value="HEAD")})
    private void recalculateFogWeight(float partialTicks, CallbackInfo info) {
        Minecraft mc = ((AccessorEntityRenderer)((Object)this)).getMC();
        if (mc.field_71474_y.field_151451_c != modernBeta_renderDistance) {
            modernBeta_renderDistance = mc.field_71474_y.field_151451_c;
            modernBeta_fogWeight = MixinEntityRenderer.calculateFogWeight(modernBeta_renderDistance);
        }
        modernBeta_partialTicks = partialTicks;
    }

    @ModifyVariable(method={"updateFogColor(F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getSkyColor(Lnet/minecraft/entity/Entity;F)Lnet/minecraft/util/math/Vec3d;"), ordinal=1)
    private float modifyFogWeighting(float weight) {
        Minecraft mc = ((AccessorEntityRenderer)((Object)this)).getMC();
        if (mc.field_71441_e.func_175624_G() instanceof ModernBetaWorldType && ModernBetaConfig.visualOptions.useOldFogColorBlending) {
            return modernBeta_fogWeight;
        }
        return weight;
    }

    @ModifyVariable(method={"updateFogColor(F)V"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/World;getFogColor(F)Lnet/minecraft/util/math/Vec3d;"), ordinal=1)
    private Vec3d modifyFogColor(Vec3d fogColor) {
        int biomeFogColor;
        Minecraft mc = ((AccessorEntityRenderer)((Object)this)).getMC();
        Entity playerEntity = mc.func_175606_aa();
        Biome biome = mc.field_71441_e.func_180494_b(playerEntity.func_180425_c());
        if (biome instanceof ModernBetaBiome && (biomeFogColor = ((ModernBetaBiome)biome).getFogColor()) != -1) {
            float celestialAngle = this.field_78531_r.field_71441_e.func_72826_c(modernBeta_partialTicks);
            celestialAngle = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
            celestialAngle = MathHelper.func_76131_a((float)celestialAngle, (float)0.0f, (float)1.0f);
            fogColor = MathUtil.convertRGBIntToVec3d(biomeFogColor);
            float r = (float)fogColor.field_72450_a;
            float g = (float)fogColor.field_72448_b;
            float b = (float)fogColor.field_72449_c;
            fogColor = new Vec3d((double)(r *= celestialAngle * 0.94f + 0.06f), (double)(g *= celestialAngle * 0.94f + 0.06f), (double)(b *= celestialAngle * 0.91f + 0.09f));
        }
        return fogColor;
    }

    @Unique
    private static float calculateFogWeight(int renderDistance) {
        int clampedDistance = MathHelper.func_76125_a((int)renderDistance, (int)4, (int)32);
        clampedDistance -= 4;
        int oldRenderDistance = Math.abs((clampedDistance /= 4) - 7);
        float weight = 1.0f / (float)(8 - oldRenderDistance);
        weight = 1.0f - (float)Math.pow(weight, 0.25);
        return weight;
    }
}

