/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.property.BooleanProperty;
import mod.bespectacled.modernbetaforge.compat.ModCompat;
import mod.bespectacled.modernbetaforge.compat.biomesoplenty.CompatBiomesOPlenty;
import mod.bespectacled.modernbetaforge.registry.ModernBetaBuiltInTypes;
import mod.bespectacled.modernbetaforge.util.ForgeRegistryUtil;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import mod.bespectacled.modernbetaforge.world.biome.climate.ClimateMap;
import mod.bespectacled.modernbetaforge.world.chunk.indev.IndevHouse;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.init.Blocks;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class DataFixers {
    private static final Gson GSON = new Gson();
    private static final Map<String, Boolean> SHOULD_GEN_SANDSTONE = ImmutableMap.builder().put((Object)ModernBetaBuiltInTypes.Chunk.BETA.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.ALPHA.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.SKYLANDS.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_611.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_420.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_415.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.PE.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.RELEASE.getId(), (Object)true).build();
    private static final Map<String, Boolean> SHOULD_SPAWN_WOLVES = ImmutableMap.builder().put((Object)ModernBetaBuiltInTypes.Chunk.BETA.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.ALPHA.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.SKYLANDS.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_611.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_420.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_415.getId(), (Object)false).put((Object)ModernBetaBuiltInTypes.Chunk.PE.getId(), (Object)true).put((Object)ModernBetaBuiltInTypes.Chunk.RELEASE.getId(), (Object)true).build();
    private static final Map<String, String> SURFACE_BUILDERS = ImmutableMap.builder().put((Object)ModernBetaBuiltInTypes.Chunk.BETA.getId(), (Object)ModernBetaBuiltInTypes.Surface.BETA.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.ALPHA.getId(), (Object)ModernBetaBuiltInTypes.Surface.ALPHA.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.SKYLANDS.getId(), (Object)ModernBetaBuiltInTypes.Surface.SKYLANDS.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_611.getId(), (Object)ModernBetaBuiltInTypes.Surface.INFDEV.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_420.getId(), (Object)ModernBetaBuiltInTypes.Surface.INFDEV.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_415.getId(), (Object)ModernBetaBuiltInTypes.Surface.INFDEV.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.PE.getId(), (Object)ModernBetaBuiltInTypes.Surface.PE.getId()).put((Object)ModernBetaBuiltInTypes.Chunk.RELEASE.getId(), (Object)ModernBetaBuiltInTypes.Surface.INFDEV.getId()).build();
    private static final Map<String, String> WORLD_SPAWNERS = ImmutableMap.builder().put((Object)ModernBetaBuiltInTypes.Chunk.BETA.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.BETA.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.ALPHA.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.BETA.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.SKYLANDS.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.DEFAULT.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_611.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.INFDEV.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_420.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.INFDEV.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_415.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.INFDEV.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.INFDEV_227.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.INFDEV.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.PE.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.PE.getRegistryString()).put((Object)ModernBetaBuiltInTypes.Chunk.RELEASE.getRegistryString(), (Object)ModernBetaBuiltInTypes.WorldSpawner.DEFAULT.getRegistryString()).build();

    public static void fixDesertBiomes(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, "desertBiomes");
        factory.desertBiomeBase = biomeMap.getOrDefault("landBiome", factory.desertBiomeBase);
        factory.desertBiomeOcean = biomeMap.getOrDefault("oceanBiome", factory.desertBiomeOcean);
        factory.desertBiomeBeach = biomeMap.getOrDefault("beachBiome", factory.desertBiomeBeach);
    }

    public static void fixForestBiomes(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, "forestBiomes");
        factory.forestBiomeBase = biomeMap.getOrDefault("landBiome", factory.forestBiomeBase);
        factory.forestBiomeOcean = biomeMap.getOrDefault("oceanBiome", factory.forestBiomeOcean);
        factory.forestBiomeBeach = biomeMap.getOrDefault("beachBiome", factory.forestBiomeBeach);
    }

    public static void fixIceDesertBiomes(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, "iceDesertBiomes");
        factory.iceDesertBiomeBase = biomeMap.getOrDefault("landBiome", factory.iceDesertBiomeBase);
        factory.iceDesertBiomeOcean = biomeMap.getOrDefault("oceanBiome", factory.iceDesertBiomeOcean);
        factory.iceDesertBiomeBeach = biomeMap.getOrDefault("beachBiome", factory.iceDesertBiomeBeach);
    }

    public static void fixPlainsBiomes(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, "plainsBiomes");
        factory.plainsBiomeBase = biomeMap.getOrDefault("landBiome", factory.plainsBiomeBase);
        factory.plainsBiomeOcean = biomeMap.getOrDefault("oceanBiome", factory.plainsBiomeOcean);
        factory.plainsBiomeBeach = biomeMap.getOrDefault("beachBiome", factory.plainsBiomeBeach);
    }

    public static void fixRainforestBiomes(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, "rainforestBiomes");
        factory.rainforestBiomeBase = biomeMap.getOrDefault("landBiome", factory.rainforestBiomeBase);
        factory.rainforestBiomeOcean = biomeMap.getOrDefault("oceanBiome", factory.rainforestBiomeOcean);
        factory.rainforestBiomeBeach = biomeMap.getOrDefault("beachBiome", factory.rainforestBiomeBeach);
    }

    public static void fixSavannaBiomes(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, "savannaBiomes");
        factory.savannaBiomeBase = biomeMap.getOrDefault("landBiome", factory.savannaBiomeBase);
        factory.savannaBiomeOcean = biomeMap.getOrDefault("oceanBiome", factory.savannaBiomeOcean);
        factory.savannaBiomeBeach = biomeMap.getOrDefault("beachBiome", factory.savannaBiomeBeach);
    }

    public static void fixShrublandBiomes(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, "shrublandBiomes");
        factory.shrublandBiomeBase = biomeMap.getOrDefault("landBiome", factory.shrublandBiomeBase);
        factory.shrublandBiomeOcean = biomeMap.getOrDefault("oceanBiome", factory.shrublandBiomeOcean);
        factory.shrublandBiomeBeach = biomeMap.getOrDefault("beachBiome", factory.shrublandBiomeBeach);
    }

    public static void fixSeasonalForestBiomes(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, "seasonalForestBiomes");
        factory.seasonalForestBiomeBase = biomeMap.getOrDefault("landBiome", factory.seasonalForestBiomeBase);
        factory.seasonalForestBiomeOcean = biomeMap.getOrDefault("oceanBiome", factory.seasonalForestBiomeOcean);
        factory.seasonalForestBiomeBeach = biomeMap.getOrDefault("beachBiome", factory.seasonalForestBiomeBeach);
    }

    public static void fixSwamplandBiomes(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, "swamplandBiomes");
        factory.swamplandBiomeBase = biomeMap.getOrDefault("landBiome", factory.swamplandBiomeBase);
        factory.swamplandBiomeOcean = biomeMap.getOrDefault("oceanBiome", factory.swamplandBiomeOcean);
        factory.swamplandBiomeBeach = biomeMap.getOrDefault("beachBiome", factory.swamplandBiomeBeach);
    }

    public static void fixTaigaBiomes(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, "taigaBiomes");
        factory.taigaBiomeBase = biomeMap.getOrDefault("landBiome", factory.taigaBiomeBase);
        factory.taigaBiomeOcean = biomeMap.getOrDefault("oceanBiome", factory.taigaBiomeOcean);
        factory.taigaBiomeBeach = biomeMap.getOrDefault("beachBiome", factory.taigaBiomeBeach);
    }

    public static void fixTundraBiomes(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        Map<String, String> biomeMap = DataFixers.deserializeBiomeMap(jsonObject, "tundraBiomes");
        factory.tundraBiomeBase = biomeMap.getOrDefault("landBiome", factory.tundraBiomeBase);
        factory.tundraBiomeOcean = biomeMap.getOrDefault("oceanBiome", factory.tundraBiomeOcean);
        factory.tundraBiomeBeach = biomeMap.getOrDefault("beachBiome", factory.tundraBiomeBeach);
    }

    public static void fixSandstone(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        factory.useSandstone = SHOULD_GEN_SANDSTONE.getOrDefault(factory.chunkSource, factory.useSandstone);
    }

    public static void fixWolves(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        factory.spawnWolves = SHOULD_SPAWN_WOLVES.getOrDefault(factory.chunkSource, factory.spawnWolves);
    }

    public static void fixSurfaces(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        factory.surfaceBuilder = SURFACE_BUILDERS.getOrDefault(factory.chunkSource, factory.surfaceBuilder);
    }

    public static void fixBiomeDepthScale(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        factory.useBiomeDepthScale = false;
    }

    public static void fixSkylandsSurface(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        if (factory.chunkSource.equals(ModernBetaBuiltInTypes.Chunk.SKYLANDS.getId())) {
            factory.surfaceBuilder = ModernBetaBuiltInTypes.Surface.SKYLANDS.getId();
        }
    }

    public static void fixSingleBiome(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        factory.singleBiome = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"fixedBiome", (String)factory.singleBiome);
    }

    public static void fixIndevHouse(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        boolean useIndevHouse = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useIndevHouse", (boolean)true);
        factory.levelHouse = useIndevHouse ? IndevHouse.OAK.id : IndevHouse.NONE.id;
    }

    public static void fixResourceLocationChunk(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)ModernBetaBuiltInTypes.Chunk.BETA.getId());
        if (!DataFixers.isResourceFormat(registryString)) {
            factory.chunkSource = ModernBeta.createRegistryKey(registryString).toString();
        }
    }

    public static void fixResourceLocationBiome(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"biomeSource", (String)ModernBetaBuiltInTypes.Biome.BETA.getId());
        if (!DataFixers.isResourceFormat(registryString)) {
            factory.biomeSource = ModernBeta.createRegistryKey(registryString).toString();
        }
    }

    public static void fixResourceLocationSurface(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"surfaceBuilder", (String)ModernBetaBuiltInTypes.Surface.BETA.getId());
        if (!DataFixers.isResourceFormat(registryString)) {
            factory.surfaceBuilder = ModernBeta.createRegistryKey(registryString).toString();
        }
    }

    public static void fixResourceLocationCarver(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"caveCarver", (String)ModernBetaBuiltInTypes.Carver.BETA.getId());
        if (!DataFixers.isResourceFormat(registryString)) {
            factory.caveCarver = ModernBeta.createRegistryKey(registryString).toString();
        }
    }

    public static void fixScaleNoiseScaleX(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)factory.chunkSource);
        boolean isAlpha = registryString.equals(ModernBetaBuiltInTypes.Chunk.ALPHA.getRegistryString());
        boolean isInfdev611 = registryString.equals(ModernBetaBuiltInTypes.Chunk.INFDEV_611.getRegistryString());
        if (isAlpha || isInfdev611) {
            factory.scaleNoiseScaleX = 1.0f;
        }
    }

    public static void fixScaleNoiseScaleZ(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)factory.chunkSource);
        boolean isAlpha = registryString.equals(ModernBetaBuiltInTypes.Chunk.ALPHA.getRegistryString());
        boolean isInfdev611 = registryString.equals(ModernBetaBuiltInTypes.Chunk.INFDEV_611.getRegistryString());
        if (isAlpha || isInfdev611) {
            factory.scaleNoiseScaleZ = 1.0f;
        }
    }

    public static void fixLayerSize(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        int biomeSize;
        factory.layerSize = biomeSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"biomeSize", (int)factory.layerSize);
    }

    public static void fixCaveCarverNone(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        boolean useCaves = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useCaves", (boolean)true);
        if (!useCaves) {
            factory.caveCarver = ModernBetaBuiltInTypes.Carver.NONE.getRegistryString();
        }
    }

    public static void fixWorldSpawner(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        String registryString = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)factory.chunkSource);
        factory.worldSpawner = WORLD_SPAWNERS.getOrDefault(registryString, ModernBetaBuiltInTypes.WorldSpawner.DEFAULT.getRegistryString());
    }

    public static void fixDefaultFluid(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        boolean useLavaOceans = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useLavaOceans", (boolean)false);
        if (useLavaOceans) {
            factory.defaultFluid = Blocks.field_150353_l.getRegistryName().toString();
        }
    }

    public static void fixSandDisks(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        boolean hasVanillaBiome = DataFixers.hasVanillaBiome(factory);
        if (hasVanillaBiome) {
            factory.useSandDisks = true;
        }
    }

    public static void fixGravelDisks(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        boolean hasVanillaBiome = DataFixers.hasVanillaBiome(factory);
        if (hasVanillaBiome) {
            factory.useGravelDisks = true;
        }
    }

    public static void fixClayDisks(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        boolean hasVanillaBiome = DataFixers.hasVanillaBiome(factory);
        if (hasVanillaBiome) {
            factory.useClayDisks = true;
        }
    }

    public static void fixDoublePlants(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        factory.useDoublePlants = factory.useNewFlowers;
    }

    public static void fixSnowyBiomeChance(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        factory.snowyBiomeChance = 6;
    }

    public static void fixLayerVersion1600(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        factory.layerVersion = 1600;
    }

    public static void fixBoPCompat(ModernBetaGeneratorSettings.Factory factory, JsonObject jsonObject) {
        if (ModCompat.isModLoaded("biomesoplenty") && factory.customProperties.containsKey(CompatBiomesOPlenty.KEY_USE_COMPAT)) {
            boolean useModdedBiomes = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useModdedBiomes", (boolean)true);
            factory.customProperties.put(CompatBiomesOPlenty.KEY_USE_COMPAT, new BooleanProperty(useModdedBiomes));
        }
    }

    private static boolean isResourceFormat(String resourceString) {
        return resourceString.split(":").length == 2;
    }

    private static boolean hasVanillaBiome(ModernBetaGeneratorSettings.Factory factory) {
        ModernBetaGeneratorSettings settings = factory.build();
        ResourceLocation biomeSource = settings.biomeSource;
        boolean hasVanillaBiome = true;
        if (biomeSource.equals((Object)ModernBetaBuiltInTypes.Biome.BETA.getRegistryKey()) || biomeSource.equals((Object)ModernBetaBuiltInTypes.Biome.PE.getRegistryKey())) {
            hasVanillaBiome = new ClimateMap(settings).containsNonModernBetaBiomes();
        } else if (biomeSource.equals((Object)ModernBetaBuiltInTypes.Biome.SINGLE.getRegistryKey())) {
            hasVanillaBiome = !(ForgeRegistryUtil.get(settings.singleBiome, ForgeRegistries.BIOMES) instanceof ModernBetaBiome);
        }
        return hasVanillaBiome;
    }

    private static Map<String, String> deserializeBiomeMap(JsonObject jsonObject, String tag) {
        try {
            return (Map)GSON.fromJson(JsonUtils.func_151200_h((JsonObject)jsonObject, (String)tag), LinkedHashMap.class);
        }
        catch (Exception e) {
            ModernBeta.log(Level.INFO, String.format("Couldn't deserialize tag '%s'.", tag));
            return new LinkedHashMap<String, String>();
        }
    }

    public static class DataFix {
        private final String tag;
        private final BiConsumer<ModernBetaGeneratorSettings.Factory, JsonObject> dataFixConsumer;

        public DataFix(String tag, BiConsumer<ModernBetaGeneratorSettings.Factory, JsonObject> dataFixConsumer) {
            this.tag = tag;
            this.dataFixConsumer = dataFixConsumer;
        }

        public String getTag() {
            return this.tag;
        }

        public BiConsumer<ModernBetaGeneratorSettings.Factory, JsonObject> getDataFixConsumer() {
            return this.dataFixConsumer;
        }
    }
}

