/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.util.datafix;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.List;
import mod.bespectacled.modernbetaforge.util.datafix.DataFixTags;
import mod.bespectacled.modernbetaforge.util.datafix.DataFixer;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;

public class ModDataFixers {
    private static final int DATA_VERSION_V1_1_0_0 = 1100;
    private static final int DATA_VERSION_V1_2_0_0 = 1200;
    private static final int DATA_VERSION_V1_2_2_2 = 1222;
    private static final int DATA_VERSION_V1_3_0_0 = 1300;
    private static final int DATA_VERSION_V1_3_1_0 = 1310;
    private static final int DATA_VERSION_V1_4_0_0 = 1400;
    private static final int DATA_VERSION_V1_5_0_0 = 1500;
    private static final int DATA_VERSION_V1_5_2_0 = 1520;
    private static final int DATA_VERSION_V1_6_0_0 = 1600;
    private static final int DATA_VERSION_V1_6_1_0 = 1610;
    private static final int DATA_VERSION_V1_7_0_0 = 1700;
    public static final ModDataFix BIOME_MAP_FIX = ModDataFixers.createModDataFix(1100, DataFixTags.DESERT_BIOMES, DataFixTags.FOREST_BIOMES, DataFixTags.ICE_DESERT_BIOMES, DataFixTags.PLAINS_BIOMES, DataFixTags.RAINFOREST_BIOMES, DataFixTags.SAVANNA_BIOMES, DataFixTags.SHRUBLAND_BIOMES, DataFixTags.SEASONAL_FOREST_BIOMES, DataFixTags.SWAMPLAND_BIOMES, DataFixTags.TAIGA_BIOMES, DataFixTags.TUNDRA_BIOMES, DataFixTags.FIX_SINGLE_BIOME, DataFixTags.FIX_CAVE_CARVER_NONE, DataFixTags.FIX_DEFAULT_FLUID, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix SANDSTONE_WOLVES_SURFACE_FIX = ModDataFixers.createModDataFix(1200, DataFixTags.USE_SANDSTONE, DataFixTags.SPAWN_WOLVES, DataFixTags.SURFACE_BUILDER, DataFixTags.FIX_BIOME_DEPTH_SCALE, DataFixTags.FIX_SINGLE_BIOME, DataFixTags.FIX_CAVE_CARVER_NONE, DataFixTags.FIX_DEFAULT_FLUID, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix SKYLANDS_SURFACE_FIX = ModDataFixers.createModDataFix(1222, DataFixTags.SURFACE_SKYLANDS, DataFixTags.FIX_SINGLE_BIOME, DataFixTags.FIX_CAVE_CARVER_NONE, DataFixTags.FIX_DEFAULT_FLUID, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix SINGLE_BIOME_FIX = ModDataFixers.createModDataFix(1300, DataFixTags.FIX_SINGLE_BIOME, DataFixTags.FIX_CAVE_CARVER_NONE, DataFixTags.FIX_DEFAULT_FLUID, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix INDEV_HOUSE_FIX = ModDataFixers.createModDataFix(1310, DataFixTags.FIX_USE_INDEV_HOUSE, DataFixTags.FIX_CAVE_CARVER_NONE, DataFixTags.FIX_DEFAULT_FLUID, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix RESOURCE_LOCATION_FIX = ModDataFixers.createModDataFix(1400, DataFixTags.FIX_RESOURCE_LOCATION_CHUNK, DataFixTags.FIX_RESOURCE_LOCATION_BIOME, DataFixTags.FIX_RESOURCE_LOCATION_SURFACE, DataFixTags.FIX_RESOURCE_LOCATION_CARVER, DataFixTags.FIX_CAVE_CARVER_NONE, DataFixTags.FIX_DEFAULT_FLUID, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix SCALE_NOISE_FIX = ModDataFixers.createModDataFix(1400, DataFixTags.FIX_SCALE_NOISE_SCALE_X, DataFixTags.FIX_SCALE_NOISE_SCALE_Z, DataFixTags.FIX_CAVE_CARVER_NONE, DataFixTags.FIX_DEFAULT_FLUID, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix LAYER_SIZE_FIX = ModDataFixers.createModDataFix(1500, DataFixTags.FIX_LAYER_SIZE, DataFixTags.FIX_CAVE_CARVER_NONE, DataFixTags.FIX_DEFAULT_FLUID, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix CAVE_CARVER_NONE_FIX = ModDataFixers.createModDataFix(1520, DataFixTags.FIX_CAVE_CARVER_NONE, DataFixTags.FIX_DEFAULT_FLUID, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix SPAWN_LOCATOR_FIX = ModDataFixers.createModDataFix(1520, DataFixTags.FIX_WORLD_SPAWNER, DataFixTags.FIX_DEFAULT_FLUID, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix DEFAULT_FLUID_FIX = ModDataFixers.createModDataFix(1600, DataFixTags.FIX_DEFAULT_FLUID, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix DISKS_FIX = ModDataFixers.createModDataFix(1610, DataFixTags.FIX_SAND_DISKS, DataFixTags.FIX_GRAVEL_DISKS, DataFixTags.FIX_CLAY_DISKS, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix DOUBLE_PLANT_FIX = ModDataFixers.createModDataFix(1610, DataFixTags.FIX_DOUBLE_PLANTS, DataFixTags.FIX_BOP_COMPAT);
    public static final ModDataFix LAYER_VERSION_FIX = ModDataFixers.createModDataFix(1700, DataFixTags.FIX_SNOWY_BIOME_CHANCE, DataFixTags.FIX_LAYER_VERSION_1600, DataFixTags.FIX_BOP_COMPAT);

    private static ModDataFix createModDataFix(final int fixVersion, final ResourceLocation ... dataFixTags) {
        return new ModDataFix((IFixType)FixTypes.LEVEL, new IFixableData(){

            public int func_188216_a() {
                return fixVersion;
            }

            public NBTTagCompound func_188217_a(NBTTagCompound compound) {
                return ModDataFixers.fixGeneratorSettings(compound, Arrays.asList(dataFixTags), this.func_188216_a());
            }
        });
    }

    private static NBTTagCompound fixGeneratorSettings(NBTTagCompound compound, List<ResourceLocation> registryKeys, int fixVersion) {
        String worldName = ModDataFixers.getWorldName(compound);
        if (ModDataFixers.isModernBetaWorld(compound) && compound.func_74764_b("generatorOptions")) {
            JsonObject jsonObject;
            String generatorOptions = compound.func_74779_i("generatorOptions");
            ModernBetaGeneratorSettings.Factory factory = ModernBetaGeneratorSettings.Factory.jsonToFactory(generatorOptions);
            try {
                jsonObject = new JsonParser().parse(generatorOptions).getAsJsonObject();
            }
            catch (Exception e) {
                jsonObject = new JsonObject();
            }
            for (ResourceLocation registryKey : registryKeys) {
                DataFixer.runDataFixer(registryKey, factory, jsonObject, worldName, fixVersion);
            }
            compound.func_74778_a("generatorOptions", factory.toString().replace("\n", ""));
        }
        return compound;
    }

    private static boolean isModernBetaWorld(NBTTagCompound compound) {
        if (compound.func_74764_b("generatorName")) {
            return compound.func_74779_i("generatorName").equals("modernbeta");
        }
        return false;
    }

    private static String getWorldName(NBTTagCompound compound) {
        if (compound.func_74764_b("LevelName")) {
            return compound.func_74779_i("LevelName");
        }
        return "";
    }

    public static class ModDataFix {
        private final IFixType fixType;
        private final IFixableData fixableData;

        public ModDataFix(IFixType fixType, IFixableData fixableData) {
            this.fixType = fixType;
            this.fixableData = fixableData;
        }

        public IFixType getFixType() {
            return this.fixType;
        }

        public IFixableData getFixableData() {
            return this.fixableData;
        }
    }
}

