/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.bespectacled.modernbetaforge.world.feature.WorldGenFancyOak;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ModernBetaBiome
extends Biome {
    private static final List<Biome.SpawnListEntry> EMPTY_LIST = ImmutableList.of();
    public static final WorldGenTrees TREE_FEATURE = new WorldGenTrees(false);
    public static final WorldGenFancyOak BIG_TREE_FEATURE = new WorldGenFancyOak(false);
    protected static final float BASE_HEIGHT_LOW = 0.1f;
    protected static final float HEIGHT_VARY_LOW = 0.2f;
    protected static final float BASE_HEIGHT_TEMPERATE = 0.1f;
    protected static final float HEIGHT_VARY_TEMPERATE = 0.4f;
    protected static final float BASE_HEIGHT_WET = 0.1f;
    protected static final float HEIGHT_VARY_WET = 0.5f;
    protected static final float BASE_HEIGHT_BEACH = 0.0f;
    protected static final float HEIGHT_VARY_BEACH = 0.025f;
    protected static final float BASE_HEIGHT_OCEAN = -1.0f;
    protected static final float HEIGHT_VARY_OCEAN = 0.1f;
    protected static final Biome.SpawnListEntry SHEEP = new Biome.SpawnListEntry(EntitySheep.class, 12, 4, 4);
    protected static final Biome.SpawnListEntry PIG = new Biome.SpawnListEntry(EntityPig.class, 10, 4, 4);
    protected static final Biome.SpawnListEntry CHICKEN = new Biome.SpawnListEntry(EntityChicken.class, 10, 4, 4);
    protected static final Biome.SpawnListEntry COW = new Biome.SpawnListEntry(EntityCow.class, 8, 4, 4);
    protected static final Biome.SpawnListEntry WOLF_FOREST = new Biome.SpawnListEntry(EntityWolf.class, 5, 4, 4);
    protected static final Biome.SpawnListEntry WOLF_TAIGA = new Biome.SpawnListEntry(EntityWolf.class, 8, 4, 4);
    protected static final Biome.SpawnListEntry SPIDER = new Biome.SpawnListEntry(EntitySpider.class, 100, 4, 4);
    protected static final Biome.SpawnListEntry ZOMBIE = new Biome.SpawnListEntry(EntityZombie.class, 95, 4, 4);
    protected static final Biome.SpawnListEntry SKELETON = new Biome.SpawnListEntry(EntitySkeleton.class, 100, 4, 4);
    protected static final Biome.SpawnListEntry CREEPER = new Biome.SpawnListEntry(EntityCreeper.class, 100, 4, 4);
    protected static final Biome.SpawnListEntry SLIME = new Biome.SpawnListEntry(EntitySlime.class, 100, 4, 4);
    protected static final Biome.SpawnListEntry ENDERMAN = new Biome.SpawnListEntry(EntityEnderman.class, 10, 1, 4);
    protected static final Biome.SpawnListEntry WITCH = new Biome.SpawnListEntry(EntityWitch.class, 5, 1, 1);
    protected static final Biome.SpawnListEntry ZOMBIE_VILLAGER = new Biome.SpawnListEntry(EntityZombieVillager.class, 5, 1, 1);
    protected static final Biome.SpawnListEntry SQUID = new Biome.SpawnListEntry(EntitySquid.class, 10, 4, 4);
    protected static final Biome.SpawnListEntry BAT = new Biome.SpawnListEntry(EntityBat.class, 10, 8, 8);
    protected final List<Biome.SpawnListEntry> additionalMonsters = new ArrayList<Biome.SpawnListEntry>();
    protected final List<Biome.SpawnListEntry> additionalCreatures = new ArrayList<Biome.SpawnListEntry>();
    protected final List<Biome.SpawnListEntry> additionalWolves = new ArrayList<Biome.SpawnListEntry>();
    protected final List<Biome.SpawnListEntry> additionalWaterCreatures = new ArrayList<Biome.SpawnListEntry>();
    protected final List<Biome.SpawnListEntry> additionalCaveCreatures = new ArrayList<Biome.SpawnListEntry>();
    protected int skyColor = -1;
    protected int fogColor = -1;
    protected int cloudColor = -1;
    protected int grassColor = -1;
    protected int foliageColor = -1;

    public ModernBetaBiome(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.populateAdditionalMobs(EnumCreatureType.MONSTER, false, ENDERMAN, WITCH, ZOMBIE_VILLAGER);
        this.populateAdditionalMobs(EnumCreatureType.WATER_CREATURE, false, SQUID);
        this.populateAdditionalMobs(EnumCreatureType.AMBIENT, false, BAT);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float temp) {
        if (this.skyColor != -1) {
            return this.skyColor;
        }
        return super.func_76731_a(temp);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos blockPos) {
        if (this.grassColor != -1) {
            return this.grassColor;
        }
        return super.func_180627_b(blockPos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos blockPos) {
        if (this.foliageColor != -1) {
            return this.foliageColor;
        }
        return super.func_180625_c(blockPos);
    }

    @SideOnly(value=Side.CLIENT)
    public int getFogColor() {
        return this.fogColor;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCloudColor() {
        return this.cloudColor;
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        return random.nextInt(10) == 0 ? BIG_TREE_FEATURE : TREE_FEATURE;
    }

    public WorldGenAbstractTree getRandomTreeFeature(Random random, ModernBetaGeneratorSettings settings) {
        return this.func_150567_a(random);
    }

    public boolean canSetIce(World world, BlockPos blockPos, boolean doWaterCheck, double temp) {
        return world.func_175675_v(blockPos);
    }

    public boolean canSetSnow(World world, BlockPos blockPos, double temp) {
        return world.func_175708_f(blockPos, true);
    }

    public List<Biome.SpawnListEntry> getAdditionalSpawnableList(EnumCreatureType creatureType, boolean addWolves) {
        if (addWolves) {
            return this.additionalWolves;
        }
        switch (creatureType) {
            case MONSTER: {
                return this.additionalMonsters;
            }
            case CREATURE: {
                return this.additionalCreatures;
            }
            case WATER_CREATURE: {
                return this.additionalWaterCreatures;
            }
            case AMBIENT: {
                return this.additionalCaveCreatures;
            }
        }
        return EMPTY_LIST;
    }

    protected void populateSpawnableMobs(EnumCreatureType creatureType, Biome.SpawnListEntry ... entries) {
        ArrayList spawnEntries = Lists.newArrayList((Object[])entries);
        switch (creatureType) {
            case MONSTER: {
                this.field_76761_J.addAll(spawnEntries);
                break;
            }
            case CREATURE: {
                this.field_76762_K.addAll(spawnEntries);
                break;
            }
            case WATER_CREATURE: {
                this.field_76755_L.addAll(spawnEntries);
                break;
            }
            case AMBIENT: {
                this.field_82914_M.addAll(spawnEntries);
            }
        }
    }

    protected void populateAdditionalMobs(EnumCreatureType creatureType, boolean addWolves, Biome.SpawnListEntry ... entries) {
        ArrayList spawnEntries = Lists.newArrayList((Object[])entries);
        if (addWolves) {
            this.additionalWolves.addAll(spawnEntries);
            return;
        }
        switch (creatureType) {
            case MONSTER: {
                this.additionalMonsters.addAll(spawnEntries);
                break;
            }
            case CREATURE: {
                this.additionalCreatures.addAll(spawnEntries);
                break;
            }
            case WATER_CREATURE: {
                this.additionalWaterCreatures.addAll(spawnEntries);
                break;
            }
            case AMBIENT: {
                this.additionalCaveCreatures.addAll(spawnEntries);
            }
        }
    }
}

