/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome;

import java.util.List;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;

public class ModernBetaBiomeMobs {
    public static List<Biome.SpawnListEntry> modifySpawnList(List<Biome.SpawnListEntry> spawnEntries, EnumCreatureType creatureType, Biome biome, ModernBetaGeneratorSettings settings) {
        if (biome instanceof ModernBetaBiome) {
            ModernBetaBiome modernBetaBiome = (ModernBetaBiome)biome;
            switch (creatureType) {
                case MONSTER: {
                    ModernBetaBiomeMobs.addMobs(spawnEntries, creatureType, modernBetaBiome, settings.spawnNewMonsterMobs, false);
                    break;
                }
                case CREATURE: {
                    ModernBetaBiomeMobs.addMobs(spawnEntries, creatureType, modernBetaBiome, settings.spawnNewCreatureMobs, false);
                    ModernBetaBiomeMobs.addMobs(spawnEntries, creatureType, modernBetaBiome, settings.spawnWolves, true);
                    break;
                }
                case AMBIENT: {
                    ModernBetaBiomeMobs.addMobs(spawnEntries, creatureType, modernBetaBiome, settings.spawnAmbientMobs, false);
                    break;
                }
                case WATER_CREATURE: {
                    ModernBetaBiomeMobs.addMobs(spawnEntries, creatureType, modernBetaBiome, settings.spawnWaterMobs, false);
                }
            }
        }
        return spawnEntries;
    }

    private static void addMobs(List<Biome.SpawnListEntry> spawnEntries, EnumCreatureType creatureType, ModernBetaBiome biome, boolean shouldAdd, boolean addWolves) {
        if (shouldAdd) {
            spawnEntries.addAll(biome.getAdditionalSpawnableList(creatureType, addWolves));
        }
    }
}

